/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeCellRenderer;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.TransferableEntrySelection;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.groups.UndoableMoveGroup;

public class GroupsTree
extends JTree
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private static final int dragScrollActivationMargin = 10;
    private static final int dragScrollDistance = 5;
    private static long lastDragAutoscroll = 0L;
    private static final long minAutoscrollInterval = 50L;
    private Point idlePoint;
    private long idleStartTime = 0L;
    private static final int idleMargin = 1;
    private static final long idleTimeToExpandNode = 1000L;
    private GroupSelector groupSelector;
    private GroupTreeNode dragNode = null;
    private final GroupTreeCellRenderer cellRenderer = new GroupTreeCellRenderer();

    public GroupsTree(GroupSelector groupSelector) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        this.setRowHeight(Math.max(this.getRowHeight(), metrics.getHeight()));
        this.groupSelector = groupSelector;
        DragGestureRecognizer dgr = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 2, this);
        dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
        new DropTarget(this, this);
        this.setCellRenderer(this.cellRenderer);
        this.setFocusable(false);
        this.setToggleClickCount(0);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setShowsRootHandles(false);
        this.setVisibleRowCount(Globals.prefs.getInt("groupsVisibleRows"));
        this.getSelectionModel().setSelectionMode(4);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        Point p = dsde.getLocation();
        SwingUtilities.convertPointFromScreen(p, this);
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path == null) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            return;
        }
        GroupTreeNode target = (GroupTreeNode)path.getLastPathComponent();
        if (target == null || this.dragNode.isNodeDescendant(target) || this.dragNode == target) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            return;
        }
        dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dragNode = null;
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        boolean scrollRight;
        TreePath path;
        Point cursor = dtde.getLocation();
        long currentTime = System.currentTimeMillis();
        if (this.idlePoint == null) {
            this.idlePoint = cursor;
        }
        GroupTreeNode target = (path = this.getPathForLocation(cursor.x, cursor.y)) == null ? null : (GroupTreeNode)path.getLastPathComponent();
        this.setHighlight1Cell(target);
        if (dtde.isDataFlavorSupported(GroupTreeNode.flavor)) {
            dtde.acceptDrag(2);
        } else if (dtde.isDataFlavorSupported(TransferableEntrySelection.flavorInternal)) {
            if (path == null) {
                dtde.rejectDrag();
            } else if (target.getGroup().supportsAdd()) {
                dtde.acceptDrag(0x40000000);
            } else {
                dtde.rejectDrag();
            }
        } else {
            dtde.rejectDrag();
        }
        if (Math.abs(cursor.x - this.idlePoint.x) < 1 && Math.abs(cursor.y - this.idlePoint.y) < 1) {
            if (currentTime - this.idleStartTime >= 1000L && path != null) {
                this.expandPath(path);
            }
        } else {
            this.idlePoint = cursor;
            this.idleStartTime = currentTime;
        }
        if (currentTime - lastDragAutoscroll < 50L) {
            return;
        }
        Rectangle r = this.getVisibleRect();
        boolean scrollUp = cursor.y - r.y < 10;
        boolean scrollDown = r.y + r.height - cursor.y < 10;
        boolean scrollLeft = cursor.x - r.x < 10;
        boolean bl = scrollRight = r.x + r.width - cursor.x < 10;
        if (scrollUp) {
            r.translate(0, -5);
        } else if (scrollDown) {
            r.translate(0, 5);
        }
        if (scrollLeft) {
            r.translate(-5, 0);
        } else if (scrollRight) {
            r.translate(5, 0);
        }
        this.scrollRectToVisible(r);
        lastDragAutoscroll = currentTime;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        block12: {
            this.setHighlight1Cell(null);
            try {
                Transferable transferable = dtde.getTransferable();
                Point p = dtde.getLocation();
                TreePath path = this.getPathForLocation(p.x, p.y);
                if (path == null) {
                    dtde.rejectDrop();
                    return;
                }
                GroupTreeNode target = (GroupTreeNode)path.getLastPathComponent();
                if (transferable.isDataFlavorSupported(GroupTreeNode.flavor)) {
                    GroupTreeNode source = (GroupTreeNode)transferable.getTransferData(GroupTreeNode.flavor);
                    if (source == target) {
                        dtde.rejectDrop();
                        return;
                    }
                    if (source.isNodeDescendant(target)) {
                        dtde.rejectDrop();
                        return;
                    }
                    Enumeration<TreePath> expandedPaths = this.groupSelector.getExpandedPaths();
                    UndoableMoveGroup undo = new UndoableMoveGroup(this.groupSelector, this.groupSelector.getGroupTreeRoot(), source, target, target.getChildCount());
                    target.add(source);
                    dtde.getDropTargetContext().dropComplete(true);
                    this.groupSelector.revalidateGroups(new TreePath[]{new TreePath(source.getPath())}, this.refreshPaths(expandedPaths));
                    this.groupSelector.concludeMoveGroup(undo, source);
                    break block12;
                }
                if (transferable.isDataFlavorSupported(TransferableEntrySelection.flavorInternal)) {
                    AbstractGroup group = target.getGroup();
                    if (!group.supportsAdd()) {
                        dtde.rejectDrop();
                        return;
                    }
                    TransferableEntrySelection selection = (TransferableEntrySelection)transferable.getTransferData(TransferableEntrySelection.flavorInternal);
                    BibtexEntry[] entries = selection.getSelection();
                    int assignedEntries = 0;
                    for (int i = 0; i < entries.length; ++i) {
                        if (target.getGroup().contains(entries[i])) continue;
                        ++assignedEntries;
                    }
                    if (!Util.warnAssignmentSideEffects(new AbstractGroup[]{group}, selection.getSelection(), this.groupSelector.getActiveBasePanel().getDatabase(), this.groupSelector.frame)) {
                        return;
                    }
                    this.groupSelector.getActiveBasePanel().storeCurrentEdit();
                    AbstractUndoableEdit undo = group.add(selection.getSelection());
                    if (undo instanceof UndoableChangeAssignment) {
                        ((UndoableChangeAssignment)undo).setEditedNode(target);
                    }
                    dtde.getDropTargetContext().dropComplete(true);
                    this.groupSelector.revalidateGroups();
                    this.groupSelector.concludeAssignment(undo, target, assignedEntries);
                    break block12;
                }
                dtde.rejectDrop();
                return;
            }
            catch (IOException ioe) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.setHighlight1Cell(null);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        GroupTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        Cursor cursor = DragSource.DefaultMoveDrop;
        this.dragNode = selectedNode;
        dge.getDragSource().startDrag(dge, cursor, selectedNode, this);
    }

    public GroupTreeNode getSelectedNode() {
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath != null ? (GroupTreeNode)selectionPath.getLastPathComponent() : null;
    }

    public Enumeration<TreePath> refreshPaths(Enumeration<TreePath> paths) {
        Vector<TreePath> freshPaths = new Vector<TreePath>();
        while (paths.hasMoreElements()) {
            freshPaths.add(new TreePath(((DefaultMutableTreeNode)paths.nextElement().getLastPathComponent()).getPath()));
        }
        return freshPaths.elements();
    }

    public TreePath[] refreshPaths(TreePath[] paths) {
        TreePath[] freshPaths = new TreePath[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            freshPaths[i] = new TreePath(((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getPath());
        }
        return freshPaths;
    }

    public void setHighlight1Cell(Object cell) {
        this.cellRenderer.setHighlight1Cell(cell);
        this.repaint();
    }

    public void setHighlight2Cells(Object[] cells) {
        this.cellRenderer.setHighlight2Cells(cells);
        this.repaint();
    }

    public void setHighlight3Cells(Object[] cells) {
        this.cellRenderer.setHighlight3Cells(cells);
        this.repaint();
    }

    public void setHighlightBorderCell(GroupTreeNode node) {
        this.cellRenderer.setHighlightBorderCell(node);
        this.repaint();
    }

    public void sort(GroupTreeNode node, boolean recursive) {
        this.sortWithoutRevalidate(node, recursive);
        this.groupSelector.revalidateGroups();
    }

    protected void sortWithoutRevalidate(GroupTreeNode node, boolean recursive) {
        int i;
        if (node.isLeaf()) {
            return;
        }
        int j = node.getChildCount() - 1;
        while (j > 0) {
            int lastModified = j + 1;
            j = -1;
            for (i = 1; i < lastModified; ++i) {
                GroupTreeNode child1 = (GroupTreeNode)node.getChildAt(i - 1);
                GroupTreeNode child2 = (GroupTreeNode)node.getChildAt(i);
                if (child2.getGroup().getName().compareToIgnoreCase(child1.getGroup().getName()) >= 0) continue;
                node.remove(child1);
                node.insert(child1, i);
                j = i;
            }
        }
        if (recursive) {
            for (i = 0; i < node.getChildCount(); ++i) {
                this.sortWithoutRevalidate((GroupTreeNode)node.getChildAt(i), true);
            }
        }
    }

    public void expandSubtree(GroupTreeNode node) {
        Enumeration<GroupTreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            this.expandPath(new TreePath(e.nextElement().getPath()));
        }
    }

    public void collapseSubtree(GroupTreeNode node) {
        Enumeration<GroupTreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            this.collapsePath(new TreePath(e.nextElement().getPath()));
        }
    }

    public boolean hasExpandedDescendant(TreePath path) {
        GroupTreeNode node = (GroupTreeNode)path.getLastPathComponent();
        Enumeration<GroupTreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreePath pathToChild;
            GroupTreeNode child = e.nextElement();
            if (child.isLeaf() || !this.isExpanded(pathToChild = path.pathByAddingChild(child)) && !this.hasExpandedDescendant(pathToChild)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCollapsedDescendant(TreePath path) {
        GroupTreeNode node = (GroupTreeNode)path.getLastPathComponent();
        Enumeration<GroupTreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreePath pathToChild;
            GroupTreeNode child = e.nextElement();
            if (child.isLeaf() || !this.isCollapsed(pathToChild = path.pathByAddingChild(child)) && !this.hasCollapsedDescendant(pathToChild)) continue;
            return true;
        }
        return false;
    }
}

