/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;

public abstract class EntryFromFileCreator
implements FileFilter {
    ExternalFileType externalFileType;

    public EntryFromFileCreator(ExternalFileType externalFileType) {
        this.externalFileType = externalFileType;
    }

    protected abstract BibtexEntry createBibtexEntry(File var1);

    @Override
    public abstract boolean accept(File var1);

    public abstract String getFormatName();

    public BibtexEntry createEntry(File f, boolean addPathTokensAsKeywords) {
        if (f == null || !f.exists()) {
            return null;
        }
        BibtexEntry newEntry = this.createBibtexEntry(f);
        if (newEntry == null) {
            return null;
        }
        if (addPathTokensAsKeywords) {
            this.appendToField(newEntry, "keywords", this.extractPathesToKeyWordsfield(f.getAbsolutePath()));
        }
        if (newEntry.getField("title") == null) {
            newEntry.setField("title", f.getName());
        }
        this.addFileInfo(newEntry, f);
        return newEntry;
    }

    public ExternalFileType getExternalFileType() {
        return this.externalFileType;
    }

    private String extractPathesToKeyWordsfield(String absolutePath) {
        int MIN_PATH_TOKEN_LENGTH = 4;
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(absolutePath, "" + File.separatorChar);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!st.hasMoreTokens()) break;
            if (token.length() < 4) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(token);
        }
        return sb.toString();
    }

    protected void addFileInfo(BibtexEntry entry, File file) {
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        ExternalFileType fileType = jabRefPreferences.getExternalFileTypeByExt(this.externalFileType.getFieldName());
        String[] possibleFilePaths = JabRef.jrf.basePanel().metaData().getFileDirectory("file");
        File shortenedFileName = Util.shortenFileName(file, possibleFilePaths);
        FileListEntry fileListEntry = new FileListEntry("", shortenedFileName.getPath(), fileType);
        FileListTableModel model = new FileListTableModel();
        model.addEntry(0, fileListEntry);
        entry.setField("file", model.getStringRepresentation());
    }

    protected void appendToField(BibtexEntry entry, String field, String value) {
        if (value == null || "".equals(value)) {
            return;
        }
        String oVal = entry.getField(field);
        if (oVal == null) {
            entry.setField(field, value);
        } else if (!oVal.contains(value)) {
            entry.setField(field, oVal + "," + value);
        }
    }

    protected void addEntrysToEntry(BibtexEntry entry, List<BibtexEntry> entrys) {
        if (entrys != null) {
            for (BibtexEntry e : entrys) {
                this.addEntryDataToEntry(entry, e);
            }
        }
    }

    protected void addEntryDataToEntry(BibtexEntry entry, BibtexEntry e) {
        for (String field : e.getAllFields()) {
            this.appendToField(entry, field, e.getField(field));
        }
    }

    public String toString() {
        if (this.externalFileType == null) {
            return "(undefined)";
        }
        return this.externalFileType.getName() + " (." + this.externalFileType.getExtension() + ")";
    }
}

