/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ZipFileChooser;

public class ImportCustomizationDialog
extends JDialog {
    private final JabRefFrame frame;
    private JButton addFromFolderButton = new JButton(Globals.lang("Add from folder"));
    private JButton addFromJarButton = new JButton(Globals.lang("Add from jar"));
    private JButton showDescButton = new JButton(Globals.lang("Show description"));
    private JButton removeButton = new JButton(Globals.lang("Remove"));
    private JButton closeButton = new JButton(Globals.lang("Close"));
    private JButton helpButton = new JButton(Globals.lang("Help"));
    private JPanel buttons = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JTable customImporterTable;
    private JabRefPreferences prefs = Globals.prefs;
    private ImportCustomizationDialog importCustomizationDialog = this;

    @Override
    public Dimension getSize() {
        int width = 680;
        return new Dimension(width, width / 2);
    }

    private String pathToClass(File basePath, File path) {
        String className = null;
        while (!path.equals(basePath)) {
            className = path.getName() + (className != null ? "." + className : "");
            path = path.getParentFile();
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot < 0) {
            return className;
        }
        className = className.substring(0, lastDot);
        return className;
    }

    void addOrReplaceImporter(CustomImportList.Importer importer) {
        this.prefs.customImports.replaceImporter(importer);
        Globals.importFormatReader.resetImportFormats();
        ((ImportTableModel)this.customImporterTable.getModel()).fireTableDataChanged();
    }

    public ImportCustomizationDialog(JabRefFrame frame_) throws HeadlessException {
        super(frame_, Globals.lang("Manage custom imports"), false);
        this.frame = frame_;
        this.addFromFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomImportList.Importer importer = ((ImportCustomizationDialog)ImportCustomizationDialog.this).prefs.customImports.new CustomImportList.Importer();
                importer.setBasePath(FileDialogs.getNewDir(ImportCustomizationDialog.this.frame, new File(ImportCustomizationDialog.this.prefs.get("workingDirectory")), "", Globals.lang("Select Classpath of New Importer"), 2, false));
                String chosenFileStr = FileDialogs.getNewFile((JFrame)ImportCustomizationDialog.this.frame, importer.getBasePath(), ".class", Globals.lang("Select new ImportFormat Subclass"), 2, false);
                if (chosenFileStr != null) {
                    try {
                        importer.setClassName(ImportCustomizationDialog.this.pathToClass(importer.getBasePath(), new File(chosenFileStr)));
                        importer.setName(importer.getInstance().getFormatName());
                        importer.setCliId(importer.getInstance().getCLIId());
                        ImportCustomizationDialog.this.addOrReplaceImporter(importer);
                        ImportCustomizationDialog.this.customImporterTable.revalidate();
                        ImportCustomizationDialog.this.customImporterTable.repaint();
                        ImportCustomizationDialog.this.frame.setUpImportMenus();
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0", chosenFileStr));
                    }
                    catch (NoClassDefFoundError exc) {
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0. Have you chosen the correct package path?", chosenFileStr));
                    }
                }
            }
        });
        this.addFromFolderButton.setToolTipText(Globals.lang("Add a (compiled) custom ImportFormat class from a class path. \nThe path need not be on the classpath of JabRef."));
        this.addFromJarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String basePath = FileDialogs.getNewFile((JFrame)ImportCustomizationDialog.this.frame, new File(ImportCustomizationDialog.this.prefs.get("workingDirectory")), ".zip,.jar", Globals.lang("Select a Zip-archive"), 2, false);
                ZipFile zipFile = null;
                if (basePath != null) {
                    try {
                        zipFile = new ZipFile(new File(basePath), 1);
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not open %0", basePath) + "\n" + Globals.lang("Have you chosen the correct package path?"));
                        return;
                    }
                    catch (NoClassDefFoundError exc) {
                        exc.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0", basePath) + "\n" + Globals.lang("Have you chosen the correct package path?"));
                    }
                }
                if (zipFile != null) {
                    ZipFileChooser zipFileChooser = new ZipFileChooser(ImportCustomizationDialog.this.importCustomizationDialog, zipFile);
                    zipFileChooser.setVisible(true);
                    ImportCustomizationDialog.this.customImporterTable.revalidate();
                    ImportCustomizationDialog.this.customImporterTable.repaint(10L);
                    ImportCustomizationDialog.this.frame.setUpImportMenus();
                }
            }
        });
        this.addFromJarButton.setToolTipText(Globals.lang("Add a (compiled) custom ImportFormat class from a Zip-archive.\nThe Zip-archive need not be on the classpath of JabRef."));
        this.showDescButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ImportCustomizationDialog.this.customImporterTable.getSelectedRow();
                if (row != -1) {
                    CustomImportList.Importer importer = ((ImportTableModel)ImportCustomizationDialog.this.customImporterTable.getModel()).getImporter(row);
                    try {
                        ImportFormat importFormat = importer.getInstance();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, importFormat.getDescription());
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Could not instantiate %0 %1", importer.getName() + ":\n", exc.getMessage()));
                    }
                } else {
                    JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Please select an importer"));
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ImportCustomizationDialog.this.customImporterTable.getSelectedRow();
                if (row != -1) {
                    ImportCustomizationDialog.this.customImporterTable.removeRowSelectionInterval(row, row);
                    ((ImportCustomizationDialog)ImportCustomizationDialog.this).prefs.customImports.remove(((ImportTableModel)ImportCustomizationDialog.this.customImporterTable.getModel()).getImporter(row));
                    Globals.importFormatReader.resetImportFormats();
                    ImportCustomizationDialog.this.customImporterTable.revalidate();
                    ImportCustomizationDialog.this.customImporterTable.repaint();
                    ImportCustomizationDialog.this.frame.setUpImportMenus();
                } else {
                    JOptionPane.showMessageDialog(ImportCustomizationDialog.this.frame, Globals.lang("Please select an importer."));
                }
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCustomizationDialog.this.dispose();
            }
        };
        this.closeButton.addActionListener(closeAction);
        this.helpButton.addActionListener(new HelpAction(this.frame.helpDiag, "CustomImports.html", "Help"));
        ImportTableModel tableModel = new ImportTableModel();
        this.customImporterTable = new JTable(tableModel);
        TableColumnModel cm = this.customImporterTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(200);
        cm.getColumn(1).setPreferredWidth(80);
        cm.getColumn(2).setPreferredWidth(200);
        cm.getColumn(3).setPreferredWidth(200);
        JScrollPane sp = new JScrollPane(this.customImporterTable, 20, 31);
        this.customImporterTable.setSelectionMode(0);
        this.customImporterTable.setPreferredScrollableViewportSize(this.getSize());
        if (this.customImporterTable.getRowCount() > 0) {
            this.customImporterTable.setRowSelectionInterval(0, 0);
        }
        ActionMap am = this.mainPanel.getActionMap();
        InputMap im = this.mainPanel.getInputMap(2);
        im.put(this.frame.prefs().getKey("Close dialog"), "close");
        am.put("close", closeAction);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)sp, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)this.addFromFolderButton);
        bb.addButton((JComponent)this.addFromJarButton);
        bb.addButton((JComponent)this.showDescButton);
        bb.addButton((JComponent)this.removeButton);
        bb.addButton((JComponent)this.closeButton);
        bb.addUnrelatedGap();
        bb.addButton((JComponent)this.helpButton);
        bb.addGlue();
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttons, "South");
        this.setSize(this.getSize());
        this.pack();
        Util.placeDialog(this, this.frame);
        new FocusRequester(this.customImporterTable);
    }

    class ImportTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{Globals.lang("Import name"), Globals.lang("Command line id"), Globals.lang("ImportFormat class"), Globals.lang("Contained in")};

        ImportTableModel() {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = null;
            CustomImportList.Importer importer = this.getImporter(rowIndex);
            if (columnIndex == 0) {
                value = importer.getName();
            } else if (columnIndex == 1) {
                value = importer.getClidId();
            } else if (columnIndex == 2) {
                value = importer.getClassName();
            } else if (columnIndex == 3) {
                value = importer.getBasePath();
            }
            return value;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return Globals.prefs.customImports.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public CustomImportList.Importer getImporter(int rowIndex) {
            CustomImportList.Importer[] importers = Globals.prefs.customImports.toArray(new CustomImportList.Importer[0]);
            return importers[rowIndex];
        }
    }
}

