/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.msbib.MSBibDatabase;
import org.w3c.dom.Document;

public class MsBibImporter
extends ImportFormat {
    @Override
    public boolean isRecognizedFormat(InputStream in) throws IOException {
        Document docin = null;
        try {
            DocumentBuilder dbuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            docin = dbuild.parse(in);
        }
        catch (Exception e) {
            return false;
        }
        return docin == null || docin.getDocumentElement().getTagName().contains("Sources");
    }

    public String getCLIid() {
        return "msbib";
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream in, OutputPrinter status) throws IOException {
        MSBibDatabase dbase = new MSBibDatabase();
        List<BibtexEntry> entries = dbase.importEntries(in);
        return entries;
    }

    @Override
    public String getFormatName() {
        return "MSBib";
    }
}

