/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.specialfields.SpecialFieldAction;
import net.sf.jabref.specialfields.SpecialFieldMenuAction;

public class SpecialFieldValue {
    private final SpecialField field;
    private final String keyword;
    private final String actionName;
    private String menuString;
    private SpecialFieldAction action = null;
    private SpecialFieldMenuAction menuAction = null;
    private ImageIcon icon;
    private String toolTipText;

    public SpecialFieldValue(SpecialField field, String keyword, String actionName, String menuString, ImageIcon icon, String toolTipText) {
        this.field = field;
        this.keyword = keyword;
        this.actionName = actionName;
        this.menuString = menuString;
        this.icon = icon;
        this.toolTipText = toolTipText;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getMenuString() {
        return this.menuString;
    }

    public JLabel createLabel() {
        JLabel label = new JLabel(this.icon);
        label.setToolTipText(this.toolTipText);
        return label;
    }

    public String getFieldValue() {
        return this.keyword;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public SpecialFieldAction getAction(JabRefFrame frame) {
        if (this.action == null) {
            this.action = new SpecialFieldAction(frame, this.field, this.getFieldValue(), this.field.getValues().size() == 1, this.getMenuString(), this.field.TEXT_DONE_PATTERN);
        }
        return this.action;
    }

    public SpecialFieldMenuAction getMenuAction(JabRefFrame frame) {
        if (this.menuAction == null) {
            this.menuAction = new SpecialFieldMenuAction(this, frame);
        }
        return this.menuAction;
    }
}

