/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

public class DBImportExportDialog
implements MouseListener,
KeyListener {
    private JDialog diag;
    private JTable table;
    private String dialogTitle;
    private String dialogTopMessage;
    private int tableSelectionModel;
    public List<String> listOfDBs = new ArrayList<String>();
    public boolean moreThanOne = false;
    public String selectedDB = "";
    public boolean hasDBSelected = false;
    public boolean removeAction = false;
    public int selectedInt = -1;
    private DialogType dialogType;
    private JButton importButton = new JButton(Globals.lang("Import"));
    private JButton exportButton = new JButton(Globals.lang("Export"));
    private JButton cancelButton = new JButton(Globals.lang("Cancel"));
    private JButton removeButton = new JButton(Globals.lang("Remove Selected"));

    public DialogType getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(DialogType dialogType) {
        this.dialogType = dialogType;
    }

    public DBImportExportDialog(JabRefFrame frame, Vector<Vector<String>> rows, DialogType dialogType) {
        this.dialogType = dialogType;
        Vector<String> columns = new Vector<String>();
        columns.add("Databases");
        this.table = new JTable();
        DefaultTableModel model = new DefaultTableModel(rows, columns){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(model);
        if (dialogType.equals((Object)DialogType.EXPORTER)) {
            this.dialogTitle = Globals.lang("SQL Database Exporter");
            this.dialogTopMessage = Globals.lang("Select target SQL database:");
            this.tableSelectionModel = 0;
            this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "exportAction");
            this.table.getActionMap().put("exportAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBImportExportDialog.this.exportAction();
                }
            });
        } else {
            this.dialogType = dialogType;
            this.dialogTitle = Globals.lang("SQL Database Importer");
            this.dialogTopMessage = Globals.lang("Please select which JabRef databases do you want to import:");
            this.tableSelectionModel = 2;
            this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "importAction");
            this.table.getActionMap().put("importAction", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBImportExportDialog.this.importAction();
                }
            });
        }
        this.diag = new JDialog(frame, this.dialogTitle, false);
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        JLabel lab = new JLabel(this.dialogTopMessage);
        lab.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pan.add((Component)lab, "North");
        this.table.setSelectionMode(this.tableSelectionModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(100, 100));
        this.table.setTableHeader(null);
        this.table.setRowSelectionInterval(0, 0);
        pan.add((Component)new JScrollPane(this.table), "Center");
        this.diag.getContentPane().add((Component)pan, "North");
        pan = new JPanel();
        pan.setLayout(new BorderLayout());
        this.diag.getContentPane().add((Component)pan, "Center");
        ButtonBarBuilder b = new ButtonBarBuilder();
        b.addGlue();
        if (dialogType.equals((Object)DialogType.IMPORTER)) {
            b.addButton((JComponent)this.importButton);
        } else {
            b.addButton((JComponent)this.exportButton);
        }
        b.addRelatedGap();
        b.addButton((JComponent)this.cancelButton);
        b.addRelatedGap();
        b.addButton((JComponent)this.removeButton);
        b.addGlue();
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)b.getPanel(), "South");
        this.diag.pack();
        this.diag.setLocationRelativeTo(frame);
        this.table.addMouseListener(this);
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DBImportExportDialog.this.importAction();
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DBImportExportDialog.this.exportAction();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DBImportExportDialog.this.moreThanOne = false;
                DBImportExportDialog.this.hasDBSelected = false;
                DBImportExportDialog.this.diag.dispose();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DBImportExportDialog.this.moreThanOne = false;
                DBImportExportDialog.this.hasDBSelected = true;
                DBImportExportDialog.this.selectedInt = DBImportExportDialog.this.table.getSelectedRow();
                DBImportExportDialog.this.selectedDB = (String)DBImportExportDialog.this.table.getValueAt(DBImportExportDialog.this.selectedInt, 0);
                int areYouSure = JOptionPane.showConfirmDialog(DBImportExportDialog.this.diag, "Are you sure you want to remove the already\nexistent SQL DBs?");
                if (areYouSure == 0) {
                    DBImportExportDialog.this.removeAction = true;
                    DBImportExportDialog.this.diag.dispose();
                }
            }
        });
        this.diag.setModal(true);
        this.diag.setVisible(true);
    }

    public JDialog getDiag() {
        return this.diag;
    }

    private void exportAction() {
        this.selectedInt = this.table.getSelectedRow();
        this.selectedDB = (String)this.table.getValueAt(this.selectedInt, 0);
        this.hasDBSelected = true;
        this.diag.dispose();
    }

    private void importAction() {
        int[] selectedInt = this.table.getSelectedRows();
        for (int i = 0; i < selectedInt.length; ++i) {
            this.listOfDBs.add((String)this.table.getValueAt(selectedInt[i], 0));
            this.moreThanOne = true;
        }
        this.diag.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.dialogType.equals((Object)DialogType.EXPORTER)) {
            this.exportAction();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public static enum DialogType {
        IMPORTER("IMPORTER"),
        EXPORTER("EXPORTER");

        private String dialogType;

        private DialogType(String dialogType) {
            this.dialogType = dialogType;
        }

        public String getDialogType() {
            return this.dialogType;
        }
    }
}

