/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;

public class UndoablePreambleChange
extends AbstractUndoableEdit {
    private BibtexDatabase base;
    private String oldValue;
    private String newValue;
    private BasePanel panel;

    public UndoablePreambleChange(BibtexDatabase base, BasePanel panel, String oldValue, String newValue) {
        this.base = base;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.panel = panel;
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("change preamble");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("change preamble");
    }

    @Override
    public void undo() {
        super.undo();
        this.base.setPreamble(this.oldValue);
        this.panel.updatePreamble();
    }

    @Override
    public void redo() {
        super.redo();
        this.base.setPreamble(this.newValue);
        this.panel.updatePreamble();
    }
}

