/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameListNormalizer {
    static Pattern lastFF = Pattern.compile("(\\p{javaUpperCase}[\\p{javaLowerCase}]+) (\\p{javaUpperCase}+)");
    static Pattern lastFdotF = Pattern.compile("(\\p{javaUpperCase}[\\p{javaLowerCase}]+) ([\\. \\p{javaUpperCase}]+)");
    static Pattern FFlast = Pattern.compile("(\\p{javaUpperCase}+) (\\p{javaUpperCase}[\\p{javaLowerCase}]+)");
    static Pattern FdotFlast = Pattern.compile("([\\. \\p{javaUpperCase}]+) (\\p{javaUpperCase}[\\p{javaLowerCase}]+)");
    static Pattern singleName = Pattern.compile("(\\p{javaUpperCase}[\\p{javaLowerCase}]*)");

    public static String normalizeAuthorList(String in) {
        boolean andSep = false;
        boolean semicolonSep = false;
        boolean commaSep = false;
        String[] authors = in.split("( |,)and ", -1);
        if (authors.length > 1) {
            andSep = true;
        } else {
            String[] a2 = in.split("; ");
            if (a2.length > 1) {
                semicolonSep = true;
                authors = a2;
            } else {
                a2 = in.split(", ");
                if (a2.length > 3) {
                    commaSep = true;
                    authors = a2;
                } else if (a2.length == 3 && a2[1].length() > 3) {
                    authors = a2;
                }
            }
        }
        for (int i = 0; i < authors.length; ++i) {
            authors[i] = authors[i].trim();
        }
        if (andSep && authors.length == 2) {
            String[] semiSep = authors[0].split("; ");
            if (semiSep.length > 1) {
                String[] newAuthors = new String[1 + semiSep.length];
                for (int i = 0; i < semiSep.length; ++i) {
                    newAuthors[i] = semiSep[i].trim();
                }
                newAuthors[semiSep.length] = authors[1];
                authors = newAuthors;
            } else {
                String[] cmSep;
                boolean lnfn;
                boolean bl = lnfn = authors[1].indexOf(",") > 0;
                if (!lnfn && (cmSep = authors[0].split(", ")).length > 1) {
                    String[] newAuthors = new String[1 + cmSep.length];
                    for (int i = 0; i < cmSep.length; ++i) {
                        newAuthors[i] = cmSep[i].trim();
                    }
                    newAuthors[cmSep.length] = authors[1];
                    authors = newAuthors;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < authors.length; ++i) {
            String norm = NameListNormalizer.normalizeName(authors[i]);
            sb.append(norm);
            if (i >= authors.length - 1) continue;
            sb.append(" and ");
        }
        return sb.toString();
    }

    public static String normalizeName(String name) {
        Matcher m = lastFF.matcher(name);
        if (m.matches()) {
            String initials = m.group(2);
            StringBuilder sb = new StringBuilder(m.group(1));
            sb.append(", ");
            for (int i = 0; i < initials.length(); ++i) {
                sb.append(initials.charAt(i));
                sb.append('.');
                if (i >= initials.length() - 1) continue;
                sb.append(' ');
            }
            return sb.toString();
        }
        m = lastFdotF.matcher(name);
        if (m.matches()) {
            String initials = m.group(2).replaceAll("[\\. ]+", "");
            StringBuilder sb = new StringBuilder(m.group(1));
            sb.append(", ");
            for (int i = 0; i < initials.length(); ++i) {
                sb.append(initials.charAt(i));
                sb.append('.');
                if (i >= initials.length() - 1) continue;
                sb.append(' ');
            }
            return sb.toString();
        }
        m = FFlast.matcher(name);
        if (m.matches()) {
            String initials = m.group(1);
            StringBuilder sb = new StringBuilder(m.group(2));
            sb.append(", ");
            for (int i = 0; i < initials.length(); ++i) {
                sb.append(initials.charAt(i));
                sb.append('.');
                if (i >= initials.length() - 1) continue;
                sb.append(' ');
            }
            return sb.toString();
        }
        m = FdotFlast.matcher(name);
        if (m.matches()) {
            String initials = m.group(1).replaceAll("[\\. ]+", "");
            StringBuilder sb = new StringBuilder(m.group(2));
            sb.append(", ");
            for (int i = 0; i < initials.length(); ++i) {
                sb.append(initials.charAt(i));
                sb.append('.');
                if (i >= initials.length() - 1) continue;
                sb.append(' ');
            }
            return sb.toString();
        }
        if (name.indexOf(44) >= 0) {
            int index = name.lastIndexOf(44);
            if (index == name.length() - 1) {
                name = name.substring(0, name.length() - 1);
            }
            StringBuilder sb = new StringBuilder(name.substring(0, index));
            sb.append(", ");
            String fName = name.substring(index + 1).trim();
            String[] fParts = fName.split(" ");
            if (fParts.length > 1) {
                for (int i = 0; i < fParts.length; ++i) {
                    if (fParts[i].length() == 1) {
                        sb.append(fParts[i] + ".");
                    } else {
                        sb.append(fParts[i]);
                    }
                    if (i >= fParts.length - 1) continue;
                    sb.append(" ");
                }
            } else {
                Matcher m2 = singleName.matcher(fParts[0]);
                if (m2.matches()) {
                    sb.append(fParts[0]);
                } else {
                    String initials = fParts[0].replaceAll("[\\.]+", "");
                    for (int i = 0; i < initials.length(); ++i) {
                        sb.append(initials.charAt(i));
                        sb.append('.');
                        if (i >= initials.length() - 1) continue;
                        sb.append(' ');
                    }
                }
            }
            return sb.toString();
        }
        String[] parts = name.split(" +");
        boolean allNames = true;
        for (int i = 0; i < parts.length; ++i) {
            m = singleName.matcher(parts[i]);
            if (m.matches()) continue;
            allNames = false;
            break;
        }
        if (allNames) {
            StringBuilder sb = new StringBuilder(parts[parts.length - 1]);
            if (parts.length > 1) {
                sb.append(",");
                for (int i = 0; i < parts.length - 1; ++i) {
                    sb.append(" " + parts[i]);
                    if (parts[i].length() != 1) continue;
                    sb.append(".");
                }
            }
            return sb.toString();
        }
        return name;
    }
}

