/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.auximport;

import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.wizard.auximport.AuxSubGenerator;

public class AuxCommandLine {
    private String auxName;
    private BibtexDatabase bib;

    public AuxCommandLine(String auxFileName, BibtexDatabase refDBase) {
        this.auxName = Util.getCorrectFileName(auxFileName, "aux");
        this.bib = refDBase;
    }

    public BibtexDatabase perform() {
        BibtexDatabase back = null;
        if (this.auxName.length() > 0 && this.bib != null) {
            int nested;
            AuxSubGenerator auxParser = new AuxSubGenerator(this.bib);
            Vector<String> returnValue = auxParser.generate(this.auxName, this.bib);
            back = auxParser.getGeneratedDatabase();
            System.out.println(Globals.lang("keys_in_database") + " " + this.bib.getEntryCount());
            System.out.println(Globals.lang("found_in_aux_file") + " " + auxParser.getFoundKeysInAux());
            System.out.println(Globals.lang("resolved") + " " + auxParser.getResolvedKeysCount());
            if (auxParser.getNotResolvedKeysCount() > 0) {
                System.out.println(Globals.lang("not_found") + " " + auxParser.getNotResolvedKeysCount());
                System.out.println(returnValue);
            }
            if ((nested = auxParser.getNestedAuxCounter()) > 0) {
                System.out.println(Globals.lang("nested_aux_files") + " " + nested);
            }
        }
        return back;
    }
}

