/*
 * Decompiled with CFR 0.152.
 */
package org.java.ayatana;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.java.ayatana.AyatanaLibrary;
import org.java.ayatana.DefaultExtraMenuAction;
import org.java.ayatana.ExtraMenuAction;
import org.java.ayatana.GMainLoop;

public final class ApplicationMenu
implements WindowListener,
AWTEventListener,
ContainerListener,
ComponentListener,
PropertyChangeListener {
    private static final List<Window> windows = new ArrayList<Window>();
    private static boolean initialized = false;
    private Window window;
    private JMenuBar menubar;
    private boolean tryInstalled = false;
    private ExtraMenuAction extraMenuAction;
    private long windowxid = -1L;
    private boolean allowDynamicMenuBar;
    private long approveRebuild = -1L;

    public static JMenuBar getWindowMenuBar(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getJMenuBar();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getJMenuBar();
        }
        return null;
    }

    public static String getWindowTitle(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getTitle();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getTitle();
        }
        return null;
    }

    public static JRootPane getWindowRootPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getRootPane();
        }
        return null;
    }

    public static boolean tryInstall(Window window) {
        return ApplicationMenu.tryInstall(window, ApplicationMenu.getWindowMenuBar(window), new DefaultExtraMenuAction());
    }

    public static boolean tryInstall(Window window, JMenuBar jMenuBar) {
        return ApplicationMenu.tryInstall(window, ApplicationMenu.getWindowMenuBar(window), new DefaultExtraMenuAction());
    }

    public static boolean tryInstall(Window window, ExtraMenuAction extraMenuAction) {
        return ApplicationMenu.tryInstall(window, ApplicationMenu.getWindowMenuBar(window), extraMenuAction);
    }

    public static boolean tryInstall(Window window, JMenuBar jMenuBar, ExtraMenuAction extraMenuAction) {
        if (window == null || extraMenuAction == null) {
            throw new NullPointerException();
        }
        if (jMenuBar == null) {
            return false;
        }
        if (windows.contains(window)) {
            return false;
        }
        if (!"libappmenu.so".equals(System.getenv("UBUNTU_MENUPROXY"))) {
            return false;
        }
        if (AyatanaLibrary.load()) {
            new ApplicationMenu(window, jMenuBar, extraMenuAction);
            return true;
        }
        return false;
    }

    private static native void nativeInitialize();

    private static native void nativeUninitialize();

    private static synchronized void initialize() {
        if (!initialized) {
            GMainLoop.run();
            ApplicationMenu.nativeInitialize();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ApplicationMenu.nativeUninitialize();
                }
            });
            initialized = true;
        }
    }

    private native void setCurrent(long var1);

    private native long getWindowXID(Window var1);

    private native void registerWatcher(long var1);

    private native void unregisterWatcher(long var1);

    private void addMenu(JMenu jMenu) {
        if (jMenu.getText() == null || "".equals(jMenu.getText())) {
            return;
        }
        this.addMenu(jMenu.hashCode(), jMenu.getText(), jMenu.isEnabled());
    }

    private native void addMenu(int var1, String var2, boolean var3);

    private synchronized void removeAllMenus() {
        this.removeAll();
    }

    private native void removeAll();

    private void addMenuItem(JMenuItem jMenuItem) {
        if (jMenuItem.getText() == null || "".equals(jMenuItem.getText())) {
            return;
        }
        int n = -1;
        int n2 = -1;
        if (jMenuItem.getAccelerator() != null) {
            n = jMenuItem.getAccelerator().getModifiers();
            n2 = jMenuItem.getAccelerator().getKeyCode();
        }
        if (jMenuItem instanceof JMenu) {
            this.addMenu((JMenu)jMenuItem);
        } else if (jMenuItem instanceof JRadioButtonMenuItem) {
            this.addMenuItemRadio(jMenuItem.hashCode(), jMenuItem.getText(), jMenuItem.isEnabled(), n, n2, jMenuItem.isSelected());
        } else if (jMenuItem instanceof JCheckBoxMenuItem) {
            this.addMenuItemCheck(jMenuItem.hashCode(), jMenuItem.getText(), jMenuItem.isEnabled(), n, n2, jMenuItem.isSelected());
        } else {
            this.addMenuItem(jMenuItem.hashCode(), jMenuItem.getText(), jMenuItem.isEnabled(), n, n2);
        }
    }

    private native void addMenuItem(int var1, String var2, boolean var3, int var4, int var5);

    private native void addMenuItemRadio(int var1, String var2, boolean var3, int var4, int var5, boolean var6);

    private native void addMenuItemCheck(int var1, String var2, boolean var3, int var4, int var5, boolean var6);

    private void addSeparator() {
        this.addMenuItemSeparator();
    }

    private native void addMenuItemSeparator();

    private ApplicationMenu(Window window, JMenuBar jMenuBar, ExtraMenuAction extraMenuAction) {
        windows.add(window);
        this.window = window;
        this.menubar = jMenuBar;
        this.extraMenuAction = extraMenuAction;
        this.allowDynamicMenuBar = this.extraMenuAction.allowDynamicMenuBar();
        window.addWindowListener(this);
        if (window.isDisplayable()) {
            this.tryInstall();
        }
    }

    private synchronized void tryInstall() {
        if (this.tryInstalled && this.windowxid > -1L) {
            this.setCurrent(this.windowxid);
        } else if (!this.tryInstalled) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.initialize();
                    ApplicationMenu.this.windowxid = ApplicationMenu.this.getWindowXID(ApplicationMenu.this.window);
                    ApplicationMenu.this.registerWatcher(ApplicationMenu.this.windowxid);
                }
            });
            this.tryInstalled = true;
        }
    }

    private synchronized void tryUninstall() {
        if (this.tryInstalled) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.this.unregisterWatcher(ApplicationMenu.this.windowxid);
                    ApplicationMenu.this.window.removeWindowListener(ApplicationMenu.this);
                    windows.remove(ApplicationMenu.this.window);
                }
            });
            this.tryInstalled = false;
        }
    }

    private synchronized void buildMenuBar() {
        this.buildMenuBar(false);
    }

    private synchronized void buildMenuBar(boolean bl) {
        for (Component component : this.menubar.getComponents()) {
            if (!(component instanceof JMenu)) continue;
            if (component.isVisible()) {
                this.addMenu((JMenu)component);
            }
            if (!bl || !this.allowDynamicMenuBar) continue;
            ((JMenu)component).addComponentListener(this);
            ((JMenu)component).addPropertyChangeListener(this);
        }
    }

    private synchronized void install() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        this.buildMenuBar(true);
        if (this.allowDynamicMenuBar) {
            this.menubar.addContainerListener(this);
        }
        this.menubar.setVisible(false);
    }

    private synchronized void uninstall() {
        if (this.allowDynamicMenuBar) {
            for (Component component : this.menubar.getComponents()) {
                if (!(component instanceof JMenu)) continue;
                ((JMenu)component).removeComponentListener(this);
                ((JMenu)component).removePropertyChangeListener(this);
            }
            this.menubar.removeContainerListener(this);
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.menubar.setVisible(true);
    }

    private JMenuItem getJMenuItem(int n) {
        for (Component component : this.menubar.getComponents()) {
            JMenuItem jMenuItem;
            if (!(component instanceof JMenuItem) || (jMenuItem = this.getJMenuItem((JMenuItem)component, n)) == null) continue;
            return jMenuItem;
        }
        return null;
    }

    private JMenuItem getJMenuItem(JMenuItem jMenuItem, int n) {
        if (jMenuItem.hashCode() == n) {
            return jMenuItem;
        }
        if (jMenuItem instanceof JMenu) {
            for (Component component : ((JMenu)jMenuItem).getMenuComponents()) {
                JMenuItem jMenuItem2;
                if (!(component instanceof JMenuItem) || (jMenuItem2 = this.getJMenuItem((JMenuItem)component, n)) == null) continue;
                return jMenuItem2;
            }
        }
        return null;
    }

    private JMenuItem getJMenuItem(int n, int n2) {
        for (Component component : this.menubar.getComponents()) {
            JMenuItem jMenuItem;
            if (!(component instanceof JMenuItem) || (jMenuItem = this.getJMenuItem((JMenuItem)component, n, n2)) == null) continue;
            return jMenuItem;
        }
        return null;
    }

    private JMenuItem getJMenuItem(JMenuItem jMenuItem, int n, int n2) {
        if (jMenuItem instanceof JMenu) {
            for (Component component : ((JMenu)jMenuItem).getMenuComponents()) {
                JMenuItem jMenuItem2;
                if (!(component instanceof JMenuItem) || (jMenuItem2 = this.getJMenuItem((JMenuItem)component, n, n2)) == null) continue;
                return jMenuItem2;
            }
        } else {
            if (jMenuItem.getAccelerator() == null) {
                return null;
            }
            if (jMenuItem.getAccelerator().getKeyCode() == n && jMenuItem.getAccelerator().getModifiers() == n2) {
                return jMenuItem;
            }
        }
        return null;
    }

    private void itemActivated(int n) {
        this.invokeMenuItem(this.getJMenuItem(n), false);
    }

    private void itemAboutToShow(int n) {
        this.invokeSelectMenu((JMenu)this.getJMenuItem(n));
    }

    private void itemAfterShow(int n) {
        this.invokeDeselectMenu((JMenu)this.getJMenuItem(n));
    }

    private void invokeMenuItem(final JMenuItem jMenuItem, final boolean bl) {
        if (jMenuItem != null && jMenuItem.isEnabled() && jMenuItem.isVisible()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ApplicationMenu.this.extraMenuAction.allowMenuAction(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenuItem, true, bl)) {
                        jMenuItem.getModel().setArmed(true);
                        jMenuItem.getModel().setPressed(true);
                        ApplicationMenu.this.extraMenuAction.invokeMenu(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenuItem, true, bl);
                        jMenuItem.getModel().setPressed(false);
                        jMenuItem.getModel().setArmed(false);
                    }
                }
            });
        }
    }

    private void invokeSelectMenu(final JMenu jMenu) {
        if (jMenu != null && jMenu.isEnabled() && jMenu.isVisible()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (ApplicationMenu.this.extraMenuAction.allowMenuAction(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenu, true, false)) {
                            ApplicationMenu.this.extraMenuAction.beforInvokeMenu(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenu, true, false);
                            jMenu.getModel().setSelected(true);
                            JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                            PopupMenuEvent popupMenuEvent = new PopupMenuEvent(jPopupMenu);
                            for (PopupMenuListener object : jMenu.getPopupMenu().getPopupMenuListeners()) {
                                if (object == null) continue;
                                object.popupMenuWillBecomeVisible(popupMenuEvent);
                            }
                            ApplicationMenu.this.extraMenuAction.invokeMenu(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenu, true, false);
                            for (Component component : jPopupMenu.getComponents()) {
                                if (!component.isVisible()) continue;
                                if (component instanceof JMenu) {
                                    ApplicationMenu.this.addMenu((JMenu)component);
                                    continue;
                                }
                                if (component instanceof JMenuItem) {
                                    ApplicationMenu.this.addMenuItem((JMenuItem)component);
                                    continue;
                                }
                                if (!(component instanceof JSeparator)) continue;
                                ApplicationMenu.this.addSeparator();
                            }
                            ApplicationMenu.this.extraMenuAction.afterInvokeMenu(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenu, true, false);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
    }

    private void invokeDeselectMenu(final JMenu jMenu) {
        if (jMenu != null && jMenu.isEnabled() && jMenu.isVisible()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (ApplicationMenu.this.extraMenuAction.allowMenuAction(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenu, false, false)) {
                            ApplicationMenu.this.extraMenuAction.beforInvokeMenu(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenu, false, false);
                            ApplicationMenu.this.extraMenuAction.invokeMenu(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenu, false, false);
                            PopupMenuEvent popupMenuEvent = new PopupMenuEvent(jMenu.getPopupMenu());
                            for (PopupMenuListener popupMenuListener : jMenu.getPopupMenu().getPopupMenuListeners()) {
                                if (popupMenuListener == null) continue;
                                popupMenuListener.popupMenuWillBecomeInvisible(popupMenuEvent);
                            }
                            jMenu.getModel().setSelected(false);
                            ApplicationMenu.this.extraMenuAction.afterInvokeMenu(ApplicationMenu.this.window, ApplicationMenu.this.menubar, jMenu, false, false);
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
    }

    private void invokeAccelerator(int n, int n2) {
        this.invokeMenuItem(this.getJMenuItem(n, n2), true);
    }

    private Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JFrame) {
            return (Window)component;
        }
        if (component instanceof JDialog) {
            return (Window)component;
        }
        return this.getWindow(component.getParent());
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        Window window;
        KeyEvent keyEvent;
        if (aWTEvent.getID() == 402 && (keyEvent = (KeyEvent)aWTEvent).getKeyCode() != 18 && keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 157 && keyEvent.getKeyCode() != 65406 && this.window.isActive() && this.window.equals(window = aWTEvent.getSource() instanceof Component ? this.getWindow((Component)aWTEvent.getSource()) : (aWTEvent.getSource() instanceof JFrame ? (Window)aWTEvent.getSource() : (aWTEvent.getSource() instanceof JDialog ? (Window)aWTEvent.getSource() : null)))) {
            this.invokeAccelerator(keyEvent.getKeyCode(), keyEvent.getModifiersEx() | keyEvent.getModifiers());
        }
    }

    private void rebuildMenuBar() {
        if (this.approveRebuild == -1L) {
            this.approveRebuild = System.currentTimeMillis() + 500L;
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (System.currentTimeMillis() < ApplicationMenu.this.approveRebuild) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.getLogger(ApplicationMenu.class.getName()).log(Level.WARNING, "Can't wait approve rebuild", interruptedException);
                    }
                    finally {
                        ApplicationMenu.this.removeAllMenus();
                        ApplicationMenu.this.buildMenuBar();
                        ApplicationMenu.this.approveRebuild = -1L;
                    }
                }
            }.start();
        } else {
            this.approveRebuild = System.currentTimeMillis() + 500L;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("enabled".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof JMenu) {
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof JMenu) {
            ((JMenu)containerEvent.getChild()).addComponentListener(this);
            ((JMenu)containerEvent.getChild()).addPropertyChangeListener(this);
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof JMenu) {
            ((JMenu)containerEvent.getChild()).removeComponentListener(this);
            ((JMenu)containerEvent.getChild()).removePropertyChangeListener(this);
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getSource() instanceof JMenu) {
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getSource() instanceof JMenu) {
            this.rebuildMenuBar();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.tryInstall();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.tryUninstall();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.tryInstall();
    }
}

