/*
 * Decompiled with CFR 0.152.
 */
package org.java.ayatana;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.ImageIcon;

public final class AyatanaDesktop {
    private static String toHexadecimal(byte[] byArray) {
        String string = "";
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (Integer.toHexString(n).length() == 1) {
                string = string + "0";
            }
            string = string + Integer.toHexString(n);
        }
        return string;
    }

    public static String getMD5Checksum(InputStream inputStream) {
        try {
            int n;
            byte[] byArray = new byte[1024];
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            while ((n = inputStream.read(byArray)) > 0) {
                messageDigest.update(byArray, 0, n);
            }
            return AyatanaDesktop.toHexadecimal(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static boolean isSupported() {
        if (!"true".equals(System.getProperty("jayatana.force")) && !"true".equals(System.getenv("JAYATANA_FORCE"))) {
            if (!System.getProperty("os.name").contains("Linux")) {
                return false;
            }
            if (!"Unity".equals(System.getenv("XDG_CURRENT_DESKTOP"))) {
                return false;
            }
            String string = System.getProperty("java.version");
            string = string.substring(0, string.indexOf(".", string.indexOf(".") + 1));
            try {
                float f = Float.parseFloat(string);
                if (System.getProperty("java.vm.name").contains("OpenJDK") && f < 1.7f) {
                    return false;
                }
                if (f < 1.6f) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public static boolean tryInstallIcon(String string, URL uRL) {
        return AyatanaDesktop.tryInstallIcon(string, "hicolor", uRL);
    }

    public static boolean tryInstallIcon(String string, String string2, URL uRL) {
        if (!AyatanaDesktop.isSupported()) {
            return false;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (imageIcon.getIconHeight() != imageIcon.getIconWidth()) {
            throw new RuntimeException("the icon is not 1:1");
        }
        switch (imageIcon.getIconWidth()) {
            case 16: 
            case 24: 
            case 32: 
            case 48: 
            case 128: 
            case 256: {
                break;
            }
            default: {
                throw new RuntimeException("invalid size icon, only support 16x16 24x24 32x32 48x48 128x128 256x256");
            }
        }
        String string3 = uRL.toString();
        String string4 = string3.substring(string3.lastIndexOf(".") + 1);
        File file = new File(System.getProperty("user.home"), ".local/share/icons/" + string2 + "/" + imageIcon.getIconWidth() + "x" + imageIcon.getIconWidth() + "/apps/" + string + "." + string4);
        if (file.exists() && file.isFile()) {
            InputStream inputStream;
            String string5;
            Object object;
            try {
                object = new FileInputStream(file);
                string5 = AyatanaDesktop.getMD5Checksum((InputStream)object);
                ((FileInputStream)object).close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            try {
                inputStream = uRL.openStream();
                object = AyatanaDesktop.getMD5Checksum(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (!((String)object).equals(string5)) {
                file.getParentFile().mkdirs();
                try {
                    int n;
                    inputStream = uRL.openStream();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[1024];
                    while ((n = inputStream.read(byArray)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                try {
                    Runtime.getRuntime().exec("xdg-icon-resource forceupdate");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
        file.getParentFile().mkdirs();
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        try {
            Runtime.getRuntime().exec("xdg-icon-resource forceupdate");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

