/*
 * Decompiled with CFR 0.152.
 */
package spl.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import net.sf.jabref.Globals;
import spl.listener.LabelLinkListener;
import spl.localization.LocalizationSupport;

public class ImportDialog
extends JDialog {
    public static final int NOMETA = 0;
    public static final int XMP = 1;
    public static final int CONTENT = 2;
    public static final int MRDLIB = 3;
    public static final int ONLYATTACH = 4;
    public static final int UPDATEEMPTYFIELDS = 5;
    private JPanel contentPane;
    private JLabel labelSubHeadline;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JCheckBox checkBoxDoNotShowAgain;
    private JCheckBox useDefaultPDFImportStyle;
    private JRadioButton radioButtonXmp;
    private JRadioButton radioButtonPDFcontent;
    private JRadioButton radioButtonMrDlib;
    private JRadioButton radioButtonNoMeta;
    private JLabel labelHeadline;
    private JLabel labelFileName;
    private JRadioButton radioButtononlyAttachPDF;
    private JRadioButton radioButtonUpdateEmptyFields;
    private JLabel labelMrDlib1;
    private JLabel labelMrDlib2;
    private int result;
    private int dropRow;
    private String fileName;

    public ImportDialog(int dropRow, String fileName) {
        this.dropRow = dropRow;
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.setContentPane(this.contentPane);
        JPanel panel3 = new JPanel();
        panel3.setBackground(new Color(-1643275));
        this.labelHeadline = new JLabel(Globals.lang("Import_Metadata_from:"));
        this.labelHeadline.setFont(new Font(this.labelHeadline.getFont().getName(), 1, 14));
        this.labelSubHeadline = new JLabel(Globals.lang("Choose_the_source_for_the_metadata_import"));
        this.labelSubHeadline.setFont(new Font(this.labelSubHeadline.getFont().getName(), this.labelSubHeadline.getFont().getStyle(), 13));
        this.labelFileName = new JLabel();
        this.labelFileName.setFont(new Font(this.labelHeadline.getFont().getName(), 1, 14));
        JPanel headLinePanel = new JPanel();
        headLinePanel.add(this.labelHeadline);
        headLinePanel.add(this.labelFileName);
        headLinePanel.setBackground(new Color(-1643275));
        GridLayout gl = new GridLayout(2, 1);
        gl.setVgap(10);
        gl.setHgap(10);
        panel3.setLayout(gl);
        panel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel3.add(headLinePanel);
        panel3.add(this.labelSubHeadline);
        this.radioButtonNoMeta = new JRadioButton(Globals.lang("Create_blank_entry_linking_the_PDF"));
        this.radioButtonXmp = new JRadioButton(Globals.lang("Create_entry_based_on_XMP_data"));
        this.radioButtonPDFcontent = new JRadioButton(Globals.lang("Create_entry_based_on_content"));
        this.radioButtonMrDlib = new JRadioButton(Globals.lang("Create_entry_based_on_data_fetched_from"));
        this.radioButtononlyAttachPDF = new JRadioButton(Globals.lang("Only_attach_PDF"));
        this.radioButtonUpdateEmptyFields = new JRadioButton(Globals.lang("Update_empty_fields_with_data_fetched_from"));
        this.labelMrDlib1 = new JLabel("Mr._dLib");
        this.labelMrDlib1.setFont(new Font(this.labelMrDlib1.getFont().getName(), 1, 13));
        this.labelMrDlib1.setForeground(new Color(-16776961));
        this.labelMrDlib2 = new JLabel("Mr._dLib");
        this.labelMrDlib2.setFont(new Font(this.labelMrDlib1.getFont().getName(), 1, 13));
        this.labelMrDlib2.setForeground(new Color(-16776961));
        this.buttonOK = new JButton(Globals.lang("Ok"));
        this.buttonCancel = new JButton(Globals.lang("Cancel"));
        this.checkBoxDoNotShowAgain = new JCheckBox(Globals.lang("Do not show this box again for this import"));
        this.useDefaultPDFImportStyle = new JCheckBox(Globals.lang("Always use this PDF import style (and do not ask for each import)"));
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:pref, 5dlu, left:pref:grow", ""));
        b.appendSeparator(Globals.lang("Create New Entry"));
        b.append((Component)this.radioButtonNoMeta, 3);
        b.append((Component)this.radioButtonXmp, 3);
        b.append((Component)this.radioButtonPDFcontent, 3);
        b.append(this.radioButtonMrDlib);
        b.append(this.labelMrDlib1);
        b.appendSeparator(Globals.lang("Update_Existing_Entry"));
        b.append((Component)this.radioButtononlyAttachPDF, 3);
        b.append(this.radioButtonUpdateEmptyFields);
        b.append(this.labelMrDlib2);
        b.nextLine();
        b.append(this.checkBoxDoNotShowAgain);
        b.append(this.useDefaultPDFImportStyle);
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.buttonOK);
        bb.addButton((JComponent)this.buttonCancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPane.add((Component)panel3, "North");
        this.contentPane.add((Component)b.getPanel(), "Center");
        this.contentPane.add((Component)bb.getPanel(), "South");
        if (this.dropRow < 0) {
            this.radioButtononlyAttachPDF.setEnabled(false);
            this.radioButtonUpdateEmptyFields.setEnabled(false);
            this.labelMrDlib2.setEnabled(false);
        }
        this.fileName = fileName;
        String name = new File(this.fileName).getName();
        if (name.length() < 34) {
            this.labelFileName.setText(name);
        } else {
            this.labelFileName.setText(new File(this.fileName).getName().substring(0, 33) + "...");
        }
        this.labelMrDlib1.addMouseListener(new LabelLinkListener(this.labelMrDlib1, "www.mr-dlib.org/docs/pdf_metadata_extraction.php"));
        this.labelMrDlib2.addMouseListener(new LabelLinkListener(this.labelMrDlib2, "www.mr-dlib.org/docs/pdf_metadata_extraction.php"));
        this.setTitle(LocalizationSupport.message("Import_Metadata_From_PDF"));
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioButtonNoMeta);
        bg.add(this.radioButtonXmp);
        bg.add(this.radioButtonPDFcontent);
        bg.add(this.radioButtonMrDlib);
        bg.add(this.radioButtononlyAttachPDF);
        bg.add(this.radioButtonUpdateEmptyFields);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImportDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        switch (Globals.prefs.getInt("importDefaultPDFimportStyle")) {
            case 0: {
                this.radioButtonNoMeta.setSelected(true);
                break;
            }
            case 1: {
                this.radioButtonXmp.setSelected(true);
                break;
            }
            case 2: {
                this.radioButtonPDFcontent.setSelected(true);
                break;
            }
            case 3: {
                this.radioButtonMrDlib.setSelected(true);
                break;
            }
            case 4: {
                this.radioButtononlyAttachPDF.setSelected(true);
                break;
            }
            case 5: {
                this.radioButtonUpdateEmptyFields.setSelected(true);
                break;
            }
            default: {
                this.radioButtonPDFcontent.setSelected(true);
            }
        }
        this.setSize(555, 371);
    }

    private void onOK() {
        this.result = 0;
        Globals.prefs.putInt("importDefaultPDFimportStyle", this.getChoice());
        if (this.useDefaultPDFImportStyle.isSelected()) {
            Globals.prefs.putBoolean("importAlwaysUsePDFImportStyle", true);
        }
        this.dispose();
    }

    private void onCancel() {
        this.result = 2;
        this.dispose();
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
    }

    public int getChoice() {
        if (this.radioButtonXmp.isSelected()) {
            return 1;
        }
        if (this.radioButtonPDFcontent.isSelected()) {
            return 2;
        }
        if (this.radioButtonMrDlib.isSelected()) {
            return 3;
        }
        if (this.radioButtonNoMeta.isSelected()) {
            return 0;
        }
        if (this.radioButtononlyAttachPDF.isSelected()) {
            return 4;
        }
        if (this.radioButtonUpdateEmptyFields.isSelected()) {
            return 5;
        }
        throw new IllegalStateException();
    }

    public boolean getDoNotShowAgain() {
        return this.checkBoxDoNotShowAgain.isSelected();
    }

    public int getResult() {
        return this.result;
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public void disableXMPChoice() {
        this.radioButtonXmp.setEnabled(false);
    }
}

