/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;

public class ActivationElliottSymmetric
implements ActivationFunction {
    private final double[] params = new double[1];

    public ActivationElliottSymmetric() {
        this.params[0] = 1.0;
    }

    @Override
    public final void activationFunction(double[] x, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            double s = this.params[0];
            x[i] = x[i] * s / (1.0 + Math.abs(x[i] * s));
        }
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationElliottSymmetric();
    }

    @Override
    public final double derivativeFunction(double b, double a) {
        double s = this.params[0];
        double d = 1.0 + Math.abs(b * s);
        return s * 1.0 / (d * d);
    }

    @Override
    public final String[] getParamNames() {
        String[] result = new String[]{"Slope"};
        return result;
    }

    @Override
    public final double[] getParams() {
        return this.params;
    }

    @Override
    public final boolean hasDerivative() {
        return true;
    }

    @Override
    public final void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getFactoryCode() {
        return null;
    }
}

