/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.data.factories;

import java.util.Random;
import org.encog.ensemble.data.EnsembleDataSet;
import org.encog.ensemble.data.factories.EnsembleDataSetFactory;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;

public class WeightedResamplingDataSetFactory
extends EnsembleDataSetFactory {
    MLDataSet originalData;

    public WeightedResamplingDataSetFactory(int dataSetSize) {
        super(dataSetSize);
    }

    MLDataPair getCandidate(double weight) {
        double weightSoFar = 0.0;
        for (int i = 0; i < this.dataSource.size(); ++i) {
            if (!((weightSoFar += this.dataSource.get(i).getSignificance()) > weight)) continue;
            return this.dataSource.get(i);
        }
        return this.dataSource.get(this.dataSource.size());
    }

    @Override
    public EnsembleDataSet getNewDataSet() {
        double weightSum = 0.0;
        for (int i = 0; i < this.dataSource.size(); ++i) {
            weightSum += this.dataSource.get(i).getSignificance();
        }
        Random generator = new Random();
        EnsembleDataSet ds = new EnsembleDataSet(this.dataSource.getInputSize(), this.dataSource.getIdealSize());
        for (int i = 0; i < this.dataSetSize; ++i) {
            double candidate = generator.nextDouble() * weightSum;
            ds.add(this.getCandidate(candidate));
        }
        return ds;
    }
}

