/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.anneal;

public abstract class SimulatedAnnealing<UNIT_TYPE> {
    private double startTemperature;
    private double stopTemperature;
    private int cycles;
    private double score;
    private double temperature;
    private boolean shouldMinimize = true;

    public abstract double calculateScore();

    public abstract UNIT_TYPE[] getArray();

    public abstract UNIT_TYPE[] getArrayCopy();

    public int getCycles() {
        return this.cycles;
    }

    public double getScore() {
        return this.score;
    }

    public double getStartTemperature() {
        return this.startTemperature;
    }

    public double getStopTemperature() {
        return this.stopTemperature;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public boolean isShouldMinimize() {
        return this.shouldMinimize;
    }

    public void iteration() {
        this.setScore(this.calculateScore());
        UNIT_TYPE[] bestArray = this.getArrayCopy();
        this.temperature = this.getStartTemperature();
        for (int i = 0; i < this.cycles; ++i) {
            this.randomize();
            double curScore = this.calculateScore();
            if (this.shouldMinimize) {
                if (curScore < this.getScore()) {
                    bestArray = this.getArrayCopy();
                    this.setScore(curScore);
                }
            } else if (curScore > this.getScore()) {
                bestArray = this.getArrayCopy();
                this.setScore(curScore);
            }
            this.putArray(bestArray);
            double ratio = Math.exp(Math.log(this.getStopTemperature() / this.getStartTemperature()) / (double)(this.getCycles() - 1));
            this.temperature *= ratio;
        }
    }

    public abstract void putArray(UNIT_TYPE[] var1);

    public abstract void randomize();

    public void setCycles(int theCycles) {
        this.cycles = theCycles;
    }

    public void setScore(double theScore) {
        this.score = theScore;
    }

    public void setShouldMinimize(boolean theShouldMinimize) {
        this.shouldMinimize = theShouldMinimize;
    }

    public void setStartTemperature(double theStartTemperature) {
        this.startTemperature = theStartTemperature;
    }

    public void setStopTemperature(double theStopTemperature) {
        this.stopTemperature = theStopTemperature;
    }

    public void setTemperature(double theTemperature) {
        this.temperature = theTemperature;
    }
}

