/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.PyString;
import org.python.core.PySystemState;

public class SyspathArchive
extends PyString {
    private ZipFile zipFile;

    public SyspathArchive(String string2) throws IOException {
        super(string2);
        string2 = SyspathArchive.getArchiveName(string2);
        if (string2 == null) {
            throw new IOException("path '" + string2 + "' not an archive");
        }
        this.zipFile = new ZipFile(new File(string2));
        if (PySystemState.isPackageCacheEnabled()) {
            PySystemState.packageManager.addJar(string2, true);
        }
    }

    SyspathArchive(ZipFile zipFile, String string2) {
        super(string2);
        this.zipFile = zipFile;
    }

    static String getArchiveName(String string2) {
        String string3 = string2.toLowerCase();
        int n = string3.indexOf(".zip");
        if (n < 0) {
            n = string3.indexOf(".jar");
        }
        if (n < 0) {
            return null;
        }
        if (n == string2.length() - 4) {
            return string2;
        }
        char c = string2.charAt(n + 4);
        if (c == File.separatorChar || c == '/') {
            return string2.substring(0, n + 4);
        }
        return null;
    }

    public SyspathArchive makeSubfolder(String string2) {
        return new SyspathArchive(this.zipFile, super.toString() + "/" + string2);
    }

    private String makeEntry(String string2) {
        String string3 = super.toString();
        String string4 = SyspathArchive.getArchiveName(super.toString());
        if (string3.length() == string4.length()) {
            return string2;
        }
        return string3.substring(string4.length() + 1) + "/" + string2;
    }

    ZipEntry getEntry(String string2) {
        return this.zipFile.getEntry(this.makeEntry(string2));
    }

    InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        int n;
        int n2;
        InputStream inputStream = this.zipFile.getInputStream(zipEntry);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n2 = (int)zipEntry.getSize(); n2 > 0; n2 -= n) {
            n = inputStream.read(byArray, n3, byArray.length - n3);
            if (n < 0) {
                return null;
            }
            n3 += n;
        }
        inputStream.close();
        return new ByteArrayInputStream(byArray);
    }
}

