/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import java.awt.BasicStroke;

public class SimpleStrokeDefs {
    private static final float[][] dash;
    private static final int NUMBER_OF_STYLES = 5;
    public static final BasicStroke SOLID;
    private static final String SOLID_NAME = "Solid Line";
    public static final BasicStroke DOT;
    private static final String DOT_NAME = "Dotted Line";
    public static final BasicStroke LARGE_DASH;
    private static final String LARGE_DASH_NAME = "Large-Dashed Line";
    public static final BasicStroke SMALL_DASH;
    private static final String SMALL_DASH_NAME = "Small-Dashed Line";
    public static final BasicStroke DASH_DOT;
    private static final String DASH_DOT_NAME = "Dash-Dot Line";

    static {
        float[][] fArrayArray = new float[5][];
        fArrayArray[1] = new float[]{2.0f, 2.0f};
        fArrayArray[2] = new float[]{7.0f, 7.0f};
        fArrayArray[3] = new float[]{4.0f, 4.0f};
        fArrayArray[4] = new float[]{4.0f, 4.0f, 2.0f, 4.0f};
        dash = fArrayArray;
        SOLID = new BasicStroke(1.0f, 0, 0, 10.0f, dash[0], 0.0f);
        DOT = new BasicStroke(1.0f, 0, 0, 10.0f, dash[1], 0.0f);
        LARGE_DASH = new BasicStroke(1.0f, 0, 0, 10.0f, dash[2], 0.0f);
        SMALL_DASH = new BasicStroke(1.0f, 0, 0, 10.0f, dash[3], 0.0f);
        DASH_DOT = new BasicStroke(1.0f, 0, 0, 10.0f, dash[3], 0.0f);
    }

    public static String getStrokeDescription(BasicStroke value) {
        if (value == SOLID) {
            return SOLID_NAME;
        }
        if (value == DOT) {
            return DOT_NAME;
        }
        if (value == LARGE_DASH) {
            return LARGE_DASH_NAME;
        }
        if (value == SMALL_DASH) {
            return SMALL_DASH_NAME;
        }
        if (value == DASH_DOT) {
            return DASH_DOT_NAME;
        }
        return "Unknown";
    }

    public static BasicStroke getStroke(String description) {
        if (description == SOLID_NAME) {
            return SOLID;
        }
        if (description == DOT_NAME) {
            return DOT;
        }
        if (description == LARGE_DASH_NAME) {
            return LARGE_DASH;
        }
        if (description == SMALL_DASH_NAME) {
            return SMALL_DASH;
        }
        if (description == DASH_DOT_NAME) {
            return DASH_DOT;
        }
        return SOLID;
    }

    public static String getDefaultStrokeDescription() {
        return SOLID_NAME;
    }

    public static String[] getAvailableStyles() {
        String[] return_val = new String[]{SOLID_NAME, DOT_NAME, LARGE_DASH_NAME, SMALL_DASH_NAME, DASH_DOT_NAME};
        return return_val;
    }
}

