/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class dom_dup {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "dom_dup";
    private static final String PRG_DESC = "";
    private static final String PRG_VERSION = "0.90";
    private static final String PRG_DATE = "2013.03.12";
    private static final String E_MAIL = "phylosoft@gmail.com";
    private static final String WWW = "sites.google.com/site/cmzmasek/home/software/forester";

    public static void main(String[] stringArray) {
        try {
            CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray);
            if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || commandLineArguments.getNumberOfNames() != 3) {
                dom_dup.printHelp();
                System.exit(0);
            }
            String string = commandLineArguments.getName(0);
            File file = commandLineArguments.getFile(2);
            File file2 = commandLineArguments.getFile(1);
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny phylogeny = phylogenyFactory.create(file, PhyloXmlParser.createPhyloXmlParserXsdValidating())[0];
            ForesterUtil.programMessage(PRG_NAME, "Pattern string: " + string);
            Pattern pattern = Pattern.compile(string);
            ForesterUtil.programMessage(PRG_NAME, "Pattern is: " + pattern);
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            dom_dup.read(file2, treeSet, treeSet2);
            dom_dup.print_set(treeSet, "Set a:");
            dom_dup.print_set(treeSet2, "Set b:");
            SortedSet<String> sortedSet = dom_dup.obtainMatchingNames(phylogeny, pattern);
            ForesterUtil.programMessage(PRG_NAME, "Found names: ");
            SortedMap<String, List<String>> sortedMap = dom_dup.obtainPairs(sortedSet);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (Map.Entry<String, List<String>> entry : sortedMap.entrySet()) {
                ++n4;
                if (entry.getValue().size() == 2) {
                    String string2 = entry.getValue().get(0);
                    String string3 = entry.getValue().get(1);
                    System.out.print(string2 + " - " + string3);
                    PhylogenyNode phylogenyNode = PhylogenyMethods.calculateLCA(phylogeny.getNode(string2), phylogeny.getNode(string3));
                    List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
                    boolean bl = false;
                    boolean bl2 = false;
                    for (PhylogenyNode phylogenyNode2 : list) {
                        String string4 = phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode();
                        if (treeSet.contains(string4)) {
                            bl = true;
                        }
                        if (!treeSet2.contains(string4)) continue;
                        bl2 = true;
                    }
                    if (bl && bl2) {
                        System.out.print(" => LCA ");
                        ++n;
                    } else {
                        ++n2;
                    }
                    System.out.println();
                    continue;
                }
                if (entry.getValue().size() == 1) {
                    System.out.println(entry.getValue().get(0) + " => no partner in current tree!");
                    ++n3;
                    continue;
                }
                System.out.println("error");
                System.exit(-1);
            }
            System.out.println("Total       : " + n4);
            System.out.println("LCA         : " + n);
            System.out.println("Non-LCA     : " + n2);
            System.out.println("With missing: " + n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
    }

    private static SortedMap<String, List<String>> obtainPairs(SortedSet<String> sortedSet) {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        for (String string : sortedSet) {
            String string2 = string.substring(0, string.indexOf(126));
            if (!treeMap.containsKey(string2)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                treeMap.put(string2, arrayList);
                continue;
            }
            ((List)treeMap.get(string2)).add(string);
        }
        return treeMap;
    }

    private static SortedSet<String> obtainMatchingNames(Phylogeny phylogeny, Pattern pattern) {
        TreeSet<String> treeSet = new TreeSet<String>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            Matcher matcher = pattern.matcher(phylogenyNode.getName());
            if (!matcher.find()) continue;
            treeSet.add(phylogenyNode.getName());
        }
        return treeSet;
    }

    private static void print_set(Set<String> set, String string) {
        ForesterUtil.programMessage(PRG_NAME, string);
        for (String string2 : set) {
            System.out.print(string2 + " ");
        }
        System.out.println();
    }

    private static void read(File file, Set<String> set, Set<String> set2) throws IOException {
        String string;
        BufferedReader bufferedReader = ForesterUtil.obtainReader(file);
        boolean bl = true;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if (ForesterUtil.isEmpty(string = string.trim())) continue;
            for (String string2 : stringArray = string.split(" ")) {
                if (bl) {
                    set.add(string2);
                    continue;
                }
                set2.add(string2);
            }
            if (!bl) continue;
            bl = false;
        }
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
        System.out.println("Usage:");
        System.out.println();
        System.out.println(PRG_NAME);
        System.out.println();
        System.out.println(" example: ");
        System.out.println();
        System.out.println("dom_dup \"HUMAN~[12]-2\" groups.txt RRMa_ALL_plus_RRMa_ee3_50_hmmalign_05_40_fme_gsdi.phylo.xml");
        System.out.println();
        System.out.println();
    }
}

