/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;

public class phylostrip {
    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("\nstrip: Wrong number of arguments.\n");
            System.out.println("Usage: \"phylostrip <in-tree> <out-tree> <options> [name1] [name2] ... OR [ref-tree]\"\n");
            System.out.println(" Options: -knn to keep listed nodes");
            System.out.println("          -rnn to remove listed nodes");
            System.out.println("          -knnp to keep nodes found in [ref-tree]");
            System.out.println("          -rnnp to remove nodes found in [ref-tree]");
            System.out.println("          -ktc to keep only nodes from listed taxonomy codes\n");
            System.exit(-1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        String string = stringArray[2];
        Phylogeny phylogeny = null;
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
        }
        catch (Exception exception) {
            System.out.println("\nCould not read \"" + file + "\" [" + exception.getMessage() + "]\n");
            System.exit(-1);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.trim().toLowerCase().equals("-knn")) {
            bl = true;
        } else if (string.trim().toLowerCase().equals("-knnp")) {
            bl = true;
            bl2 = true;
        } else if (string.trim().toLowerCase().equals("-rnnp")) {
            bl2 = true;
        } else if (string.trim().toLowerCase().equals("-ktc")) {
            bl3 = true;
        } else if (!string.trim().toLowerCase().equals("-rnn")) {
            System.out.println("\nUnknown option \"" + string + "\"\n");
            System.exit(-1);
        }
        String[] stringArray2 = null;
        if (bl2) {
            stringArray2 = phylostrip.readInNamesFromPhylogeny(stringArray[3]);
        } else {
            stringArray2 = new String[stringArray.length - 3];
            for (int i = 0; i < stringArray.length - 3; ++i) {
                stringArray2[i] = stringArray[i + 3];
            }
        }
        if (bl3) {
            ArrayList<Taxonomy> arrayList = new ArrayList<Taxonomy>();
            for (String string2 : stringArray2) {
                Taxonomy taxonomy = new Taxonomy();
                try {
                    taxonomy.setTaxonomyCode(string2);
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    System.out.println(phyloXmlDataFormatException.getMessage());
                    System.exit(-1);
                }
                arrayList.add(taxonomy);
            }
            PhylogenyMethods.deleteExternalNodesPositiveSelectionT(arrayList, phylogeny);
        } else if (bl) {
            PhylogenyMethods.deleteExternalNodesPositiveSelection(stringArray2, phylogeny);
        } else {
            PhylogenyMethods.deleteExternalNodesNegativeSelection(stringArray2, phylogeny);
        }
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(file2, phylogeny, 0);
        }
        catch (IOException iOException) {
            System.out.println("\nFailure to write output [" + iOException.getMessage() + "]\n");
            System.exit(-1);
        }
    }

    private static String[] readInNamesFromPhylogeny(String string) {
        Phylogeny phylogeny = null;
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            File file = new File(string);
            PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
            phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
        }
        catch (Exception exception) {
            System.out.println("\nCould not read \"" + string + "\" [" + exception.getMessage() + "]\n");
            System.exit(-1);
        }
        return phylogeny.getAllExternalNodeNames();
    }
}

