/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.tools.PhylogeneticInferenceOptions;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;

public class PhyloInferenceDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 8337543508238133614L;
    private final JPanel _pnl;
    private final JButton _launch_btn;
    private final JButton _cancel_btn;
    private final JFormattedTextField _bootstrap_tf;
    private final JCheckBox _bootstrap_cb;
    private final PhylogeneticInferenceOptions _opts;
    private JTextField _input_msa_file_tf;
    private JButton _select_input_msa_btn;
    private final MainFrameApplication _parent_frame;
    private JTextField _msa_length_tf;
    private JTextField _msa_size_tf;
    private JTextField _msa_type_tf;
    private final JRadioButton _distance_calc_kimura_rb;
    private final JRadioButton _distance_calc_poisson_rb;
    private final JRadioButton _distance_calc_fract_dissimilarity_rb;
    private int _value = 2;
    private JTextField _input_seqs_tf;
    private JButton _select_input_seqs_btn;
    private JTextField _input_seqs_number_tf;
    private JTextField _input_seqs_median_length_tf;
    private JTextField _input_seqs_min_length_tf;
    private JTextField _input_seqs_max_length_tf;
    private JTextField _input_seqs_type_tf;
    private JTextField _mafft_paramenters_tf;
    private JTextField _msa_processing_max_allowed_gap_ratio_tf;
    private JTextField _msa_processing_min_allowed_length_tf;
    private JTextField _random_seed_tf;
    private JCheckBox _execute_msa_processing_cb;
    private JCheckBox _msa_processing_remove_all_gap_columns_cb;
    private JCheckBox _mafft_cb;
    private JCheckBox _save_pwd_file_cb;
    private JCheckBox _save_processed_msa_cb;
    private JCheckBox _save_original_msa_cb;
    private JTextField _pwd_outfile_tf;
    private JTextField _processed_msa_outfile_tf;
    private JTextField _original_msa_outfile_tf;

    public PhyloInferenceDialog(MainFrameApplication mainFrameApplication, PhylogeneticInferenceOptions phylogeneticInferenceOptions, boolean bl) {
        super((Frame)mainFrameApplication, true);
        Serializable serializable;
        JPanel jPanel;
        Serializable serializable2;
        JPanel jPanel2;
        this.setVisible(false);
        this._parent_frame = mainFrameApplication;
        this._opts = phylogeneticInferenceOptions;
        this._pnl = new JPanel();
        this.getContentPane().add(this._pnl);
        BoxLayout boxLayout = new BoxLayout(this._pnl, 3);
        this._pnl.setLayout(boxLayout);
        if (bl) {
            this.setTitle("Phylogenetic Inference (including multiple sequence alignment)");
            jPanel2 = new JPanel();
            serializable2 = new JPanel();
            jPanel = new JPanel();
            serializable = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            serializable2.setLayout(new FlowLayout());
            jPanel.setLayout(new FlowLayout());
            ((Container)serializable).setLayout(new FlowLayout());
            jPanel2.add(new JLabel("Input Sequence File:"));
            this._input_seqs_tf = new JTextField();
            jPanel2.add(this._input_seqs_tf);
            this._select_input_seqs_btn = new JButton("Select Input File");
            jPanel2.add(this._select_input_seqs_btn);
            serializable2.add(new JLabel("Sequences: "));
            serializable2.add(new JLabel("Number of Sequences:"));
            this._input_seqs_number_tf = new JTextField();
            serializable2.add(this._input_seqs_number_tf);
            serializable2.add(new JLabel("Length: median:"));
            this._input_seqs_median_length_tf = new JTextField();
            serializable2.add(this._input_seqs_median_length_tf);
            serializable2.add(new JLabel("min:"));
            this._input_seqs_min_length_tf = new JTextField();
            serializable2.add(this._input_seqs_min_length_tf);
            serializable2.add(new JLabel("max:"));
            this._input_seqs_max_length_tf = new JTextField();
            serializable2.add(this._input_seqs_max_length_tf);
            serializable2.add(new JLabel("Type:"));
            this._input_seqs_type_tf = new JTextField();
            serializable2.add(this._input_seqs_type_tf);
            this._mafft_cb = new JCheckBox("MAFFT");
            jPanel.add(this._mafft_cb);
            jPanel.add(new JLabel("Parameters: "));
            this._mafft_paramenters_tf = new JTextField();
            jPanel.add(this._mafft_paramenters_tf);
            this._input_seqs_median_length_tf.setColumns(4);
            this._input_seqs_min_length_tf.setColumns(4);
            this._input_seqs_max_length_tf.setColumns(4);
            this._input_seqs_number_tf.setColumns(4);
            this._input_seqs_type_tf.setColumns(2);
            this._input_seqs_tf.setColumns(20);
            this._input_seqs_tf.setEditable(false);
            this._input_seqs_median_length_tf.setEditable(false);
            this._input_seqs_min_length_tf.setEditable(false);
            this._input_seqs_max_length_tf.setEditable(false);
            this._input_seqs_number_tf.setEditable(false);
            this._input_seqs_type_tf.setEditable(false);
            this._mafft_paramenters_tf.setColumns(26);
            this._mafft_paramenters_tf.setText("--maxiterate 1000 --localpair");
            this._select_input_seqs_btn.addActionListener(this);
            this._pnl.add(jPanel2);
            this._pnl.add((Component)serializable2);
            this._pnl.add(jPanel);
            this._pnl.add((Component)serializable);
        } else {
            this.setTitle("Phylogenetic Inference (from already aligned sequences) ");
            jPanel2 = new JPanel();
            serializable2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            serializable2.setLayout(new FlowLayout());
            jPanel2.add(new JLabel("Input MSA File:"));
            this._input_msa_file_tf = new JTextField();
            jPanel2.add(this._input_msa_file_tf);
            this._select_input_msa_btn = new JButton("Select Input File");
            jPanel2.add(this._select_input_msa_btn);
            serializable2.add(new JLabel("MSA: "));
            serializable2.add(new JLabel("Number of Sequences:"));
            this._msa_size_tf = new JTextField();
            serializable2.add(this._msa_size_tf);
            serializable2.add(new JLabel("Length:"));
            this._msa_length_tf = new JTextField();
            serializable2.add(this._msa_length_tf);
            serializable2.add(new JLabel("Type:"));
            this._msa_type_tf = new JTextField();
            serializable2.add(this._msa_type_tf);
            this._msa_length_tf.setColumns(4);
            this._msa_size_tf.setColumns(4);
            this._msa_type_tf.setColumns(2);
            this._input_msa_file_tf.setColumns(20);
            this._input_msa_file_tf.setEditable(false);
            this._msa_length_tf.setEditable(false);
            this._msa_size_tf.setEditable(false);
            this._msa_type_tf.setEditable(false);
            this._select_input_msa_btn.addActionListener(this);
            this._pnl.add(jPanel2);
            this._pnl.add((Component)serializable2);
        }
        jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(new JLabel("MSA Processing: "));
        this._execute_msa_processing_cb = new JCheckBox("Process MSA");
        jPanel2.add(this._execute_msa_processing_cb);
        this._msa_processing_remove_all_gap_columns_cb = new JCheckBox("Remove all gap columns");
        jPanel2.add(this._msa_processing_remove_all_gap_columns_cb);
        jPanel2.add(new JLabel("Max allowed gap ratio: "));
        this._msa_processing_max_allowed_gap_ratio_tf = new JTextField();
        jPanel2.add(this._msa_processing_max_allowed_gap_ratio_tf);
        jPanel2.add(new JLabel("Min allowed non-gap sequence length: "));
        this._msa_processing_min_allowed_length_tf = new JTextField();
        jPanel2.add(this._msa_processing_min_allowed_length_tf);
        this._msa_processing_max_allowed_gap_ratio_tf.setColumns(4);
        this._msa_processing_min_allowed_length_tf.setColumns(4);
        serializable2 = new LineBorder(Color.DARK_GRAY);
        jPanel2.setBorder((Border)((Object)serializable2));
        this._pnl.add(jPanel2);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JLabel("Distance calculation:"));
        this._distance_calc_kimura_rb = new JRadioButton("Kimura correction");
        jPanel.add(this._distance_calc_kimura_rb);
        this._distance_calc_poisson_rb = new JRadioButton("Poisson");
        jPanel.add(this._distance_calc_poisson_rb);
        this._distance_calc_fract_dissimilarity_rb = new JRadioButton("Fractional dissimilarity");
        jPanel.add(this._distance_calc_fract_dissimilarity_rb);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._distance_calc_kimura_rb);
        ((ButtonGroup)serializable).add(this._distance_calc_poisson_rb);
        ((ButtonGroup)serializable).add(this._distance_calc_fract_dissimilarity_rb);
        this._pnl.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        this._bootstrap_cb = new JCheckBox("Perform Bootstrap Resampling");
        jPanel3.add(this._bootstrap_cb);
        jPanel3.add(new JLabel("Number of Bootstrap Samples:"));
        this._bootstrap_tf = new JFormattedTextField(AptxUtil.createMaskFormatter("###"));
        jPanel3.add(this._bootstrap_tf);
        this._bootstrap_tf.setColumns(4);
        jPanel3.add(new JLabel("Random Seed:"));
        this._random_seed_tf = new JTextField();
        jPanel3.add(this._random_seed_tf);
        this._random_seed_tf.setColumns(4);
        this._pnl.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        this._launch_btn = new JButton("Go!");
        this._launch_btn.addActionListener(this);
        jPanel4.add(this._launch_btn);
        this._cancel_btn = new JButton("Cancel");
        this._cancel_btn.addActionListener(this);
        jPanel4.add(this._cancel_btn);
        this._pnl.add(jPanel4);
        this.initializeValues(bl);
        this.pack();
        this.setLocationRelativeTo(this.getParentFrame());
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._select_input_msa_btn) {
            this.readInputFile();
        } else if (actionEvent.getSource() == this._select_input_seqs_btn) {
            this.readInputSeqsFile();
        } else if (actionEvent.getSource() == this._launch_btn) {
            this.launch();
        } else if (actionEvent.getSource() == this._cancel_btn) {
            this.cancel();
        }
    }

    public void activate() {
        this.setVisible(true);
    }

    private MainFrameApplication getParentFrame() {
        return this._parent_frame;
    }

    public PhylogeneticInferenceOptions getPhylogeneticInferenceOptions() {
        return this._opts;
    }

    public int getValue() {
        return this._value;
    }

    private void initializeValues(boolean bl) {
        this._value = 2;
        if (bl) {
            this.updateSeqsItems();
        } else {
            this.updateMsaItems();
        }
        this.updateMsaProcessingItem();
        this.updateDistanceCalcMethod();
        this._bootstrap_tf.setText(this.getPhylogeneticInferenceOptions().getBootstrapSamples() + "");
        this._random_seed_tf.setText(this.getPhylogeneticInferenceOptions().getRandomNumberGeneratorSeed() + "");
    }

    private void launch() {
        this.processPerformBootstrapResampling();
        if (this._bootstrap_cb.isSelected()) {
            this.processBootstrapSamplesNumber();
            this.processRandomNumberGeneratorSeed();
        }
        this.processMsaProcessing();
        this.processDistanceCalcMethod();
        this.processMsaPrgParameters();
        this.setVisible(false);
        this._value = 0;
    }

    private void cancel() {
        this.setVisible(false);
        this._value = 2;
    }

    private void processBootstrapSamplesNumber() {
        int n = 0;
        try {
            n = Integer.parseInt(this._bootstrap_tf.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n >= 0) {
            this.getPhylogeneticInferenceOptions().setBootstrapSamples(n);
        }
    }

    private void processRandomNumberGeneratorSeed() {
        long l = 42L;
        try {
            l = Long.parseLong(this._random_seed_tf.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.getPhylogeneticInferenceOptions().setRandomNumberGeneratorSeed(l);
    }

    private void processMsaProcessing() {
        this.getPhylogeneticInferenceOptions().setExecuteMsaProcessing(this._execute_msa_processing_cb.isSelected());
        this.getPhylogeneticInferenceOptions().setMsaProcessingRemoveAllGapColumns(this._msa_processing_remove_all_gap_columns_cb.isSelected());
        int n = -1;
        try {
            n = Integer.parseInt(this._msa_processing_min_allowed_length_tf.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n > 0) {
            this.getPhylogeneticInferenceOptions().setMsaProcessingMinAllowedLength(n);
        }
        double d = -1.0;
        try {
            d = Double.parseDouble(this._msa_processing_max_allowed_gap_ratio_tf.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            d = -1.0;
        }
        if (d >= 0.0 && d <= 1.0) {
            this.getPhylogeneticInferenceOptions().setMsaProcessingMaxAllowedGapRatio(d);
        }
    }

    private void processDistanceCalcMethod() {
        if (this._distance_calc_kimura_rb != null && this._distance_calc_kimura_rb.isSelected()) {
            this.getPhylogeneticInferenceOptions().setPwdDistanceMethod(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.KIMURA_DISTANCE);
        } else if (this._distance_calc_poisson_rb != null && this._distance_calc_poisson_rb.isSelected()) {
            this.getPhylogeneticInferenceOptions().setPwdDistanceMethod(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.POISSON_DISTANCE);
        } else if (this._distance_calc_fract_dissimilarity_rb != null && this._distance_calc_fract_dissimilarity_rb.isSelected()) {
            this.getPhylogeneticInferenceOptions().setPwdDistanceMethod(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.FRACTIONAL_DISSIMILARITY);
        }
    }

    private void processPerformBootstrapResampling() {
        this.getPhylogeneticInferenceOptions().setPerformBootstrapResampling(this._bootstrap_cb.isSelected());
    }

    private void processMsaPrgParameters() {
        if (this._mafft_paramenters_tf != null) {
            this.getPhylogeneticInferenceOptions().setMsaPrgParameters(this._mafft_paramenters_tf.getText());
        }
    }

    private void readInputFile() {
        this.getParentFrame().readMsaFromFile();
        this.updateMsaItems();
    }

    private void readInputSeqsFile() {
        this.getParentFrame().readSeqsFromFileforPI();
        this.updateSeqsItems();
    }

    private void updateDistanceCalcMethod() {
        switch (this.getPhylogeneticInferenceOptions().getPwdDistanceMethod()) {
            case KIMURA_DISTANCE: {
                this._distance_calc_kimura_rb.setSelected(true);
                break;
            }
            case POISSON_DISTANCE: {
                this._distance_calc_poisson_rb.setSelected(true);
                break;
            }
            case FRACTIONAL_DISSIMILARITY: {
                this._distance_calc_fract_dissimilarity_rb.setSelected(true);
                break;
            }
            default: {
                throw new RuntimeException("invalid distance calc method");
            }
        }
    }

    private void updateMsaProcessingItem() {
        this._execute_msa_processing_cb.setSelected(this.getPhylogeneticInferenceOptions().isExecuteMsaProcessing());
        this._msa_processing_remove_all_gap_columns_cb.setSelected(this.getPhylogeneticInferenceOptions().isMsaProcessingRemoveAllGapColumns());
        if (this._opts.getMsaProcessingMaxAllowedGapRatio() > 0.0) {
            this._msa_processing_max_allowed_gap_ratio_tf.setText(this._opts.getMsaProcessingMaxAllowedGapRatio() + "");
        }
        if (this._opts.getMsaProcessingMinAllowedLength() > 0) {
            this._msa_processing_min_allowed_length_tf.setText(this._opts.getMsaProcessingMinAllowedLength() + "");
        }
    }

    private void updateMsaItems() {
        if (this.getParentFrame().getMsa() != null) {
            this._input_msa_file_tf.setText(this.getParentFrame().getMsaFile().toString());
            this._msa_length_tf.setText(this.getParentFrame().getMsa().getLength() + "");
            this._msa_size_tf.setText(this.getParentFrame().getMsa().getNumberOfSequences() + "");
            this._msa_type_tf.setText((Object)((Object)this.getParentFrame().getMsa().getType()) + "");
            this._input_msa_file_tf.setEnabled(true);
            this._msa_length_tf.setEnabled(true);
            this._msa_size_tf.setEnabled(true);
            this._msa_type_tf.setEnabled(true);
            this._launch_btn.setEnabled(true);
        } else {
            this._input_msa_file_tf.setText("");
            this._msa_length_tf.setText("");
            this._msa_size_tf.setText("");
            this._msa_type_tf.setText("");
            this._input_msa_file_tf.setEnabled(false);
            this._msa_length_tf.setEnabled(false);
            this._msa_size_tf.setEnabled(false);
            this._msa_type_tf.setEnabled(false);
            this._launch_btn.setEnabled(false);
        }
    }

    private void updateSeqsItems() {
        if (this.getParentFrame().getSeqs() != null) {
            DescriptiveStatistics descriptiveStatistics = this.calcSequenceStats(this.getParentFrame().getSeqs());
            this._input_seqs_tf.setText(this.getParentFrame().getSeqsFile().toString());
            this._input_seqs_median_length_tf.setText((int)descriptiveStatistics.median() + "");
            this._input_seqs_min_length_tf.setText((int)descriptiveStatistics.getMin() + "");
            this._input_seqs_max_length_tf.setText((int)descriptiveStatistics.getMax() + "");
            this._input_seqs_number_tf.setText(this.getParentFrame().getSeqs().size() + "");
            this._input_seqs_type_tf.setText((Object)((Object)this.getParentFrame().getSeqs().get(0).getType()) + "");
            this._input_seqs_tf.setEnabled(true);
            this._input_seqs_median_length_tf.setEnabled(true);
            this._input_seqs_min_length_tf.setEnabled(true);
            this._input_seqs_max_length_tf.setEnabled(true);
            this._input_seqs_number_tf.setEnabled(true);
            this._input_seqs_type_tf.setEnabled(true);
            this._launch_btn.setEnabled(true);
        } else {
            this._input_seqs_tf.setText("");
            this._input_seqs_median_length_tf.setText("");
            this._input_seqs_min_length_tf.setText("");
            this._input_seqs_max_length_tf.setText("");
            this._input_seqs_number_tf.setText("");
            this._input_seqs_type_tf.setText("");
            this._input_seqs_tf.setEnabled(false);
            this._input_seqs_median_length_tf.setEnabled(false);
            this._input_seqs_min_length_tf.setEnabled(false);
            this._input_seqs_max_length_tf.setEnabled(false);
            this._input_seqs_number_tf.setEnabled(false);
            this._input_seqs_type_tf.setEnabled(false);
            this._launch_btn.setEnabled(false);
        }
    }

    DescriptiveStatistics calcSequenceStats(List<MolecularSequence> list) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (MolecularSequence molecularSequence : list) {
            basicDescriptiveStatistics.addValue(molecularSequence.getLength());
        }
        return basicDescriptiveStatistics;
    }
}

