/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import org.forester.go.GoXRef;

public class BasicGoXRef
implements GoXRef {
    private final String _xref;
    private final GoXRef.Type _type;

    public BasicGoXRef(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("unexpected format for GO xref: " + string);
        }
        String string2 = stringArray[0].trim();
        this._type = string2.equals("EC") ? GoXRef.Type.EC : (string2.equals("MetaCyc") ? GoXRef.Type.META_CYC : (string2.equals("Reactome") ? GoXRef.Type.REACTOME : (string2.equals("RESID") ? GoXRef.Type.RESID : (string2.equals("UM-BBD_enzymeID") ? GoXRef.Type.UM_BBD_ENZYME_ID : (string2.equals("UM-BBD_pathwayID") ? GoXRef.Type.UM_BBD_PATHWAY_ID : (string2.equals("UM-BBD_reactionID") ? GoXRef.Type.UM_BBD_REACTIONID : (string2.equals("TC") ? GoXRef.Type.TC : (string2.equals("AraCyc") ? GoXRef.Type.ARACYC : (string2.equals("XX") ? GoXRef.Type.XX : (string2.equals("PMID") ? GoXRef.Type.PMID : (string2.equals("IMG") ? GoXRef.Type.IMG : (string2.equals("GOC") ? GoXRef.Type.GOC : (string2.equals("KEGG") ? GoXRef.Type.KEGG : (string2.equals("Wikipedia") ? GoXRef.Type.WIKIPEDIA : (string2.equals("RHEA") ? GoXRef.Type.RHEA : (string2.equals("NIF_Subcellular") ? GoXRef.Type.NIF_SUBCELLULAR : (string2.equals("CORUM") ? GoXRef.Type.CORUM : (string2.equals("UniPathway") ? GoXRef.Type.UNIPATHWAY : (string2.equals("PO") ? GoXRef.Type.PO : (string2.equals("SABIO-RK") ? GoXRef.Type.SABIO_RK : GoXRef.Type.OTHER))))))))))))))))))));
        this._xref = stringArray[1].trim();
    }

    public BasicGoXRef(GoXRef.Type type, String string) {
        this._type = type;
        this._xref = string;
    }

    @Override
    public int compareTo(GoXRef goXRef) {
        return this.getXRef().compareTo(goXRef.getXRef());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check go xref equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go xref equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getXRef().equals(((GoXRef)object).getXRef()) && this.getType().equals((Object)((GoXRef)object).getType());
    }

    @Override
    public GoXRef.Type getType() {
        return this._type;
    }

    @Override
    public String getXRef() {
        return this._xref;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getType()) {
            case EC: {
                stringBuffer.append("EC");
                break;
            }
            case META_CYC: {
                stringBuffer.append("MetaCyc");
                break;
            }
            case REACTOME: {
                stringBuffer.append("Reactome");
                break;
            }
            case RESID: {
                stringBuffer.append("RESID");
                break;
            }
            case UM_BBD_ENZYME_ID: {
                stringBuffer.append("UM-BBD_enzymeID");
                break;
            }
            case UM_BBD_PATHWAY_ID: {
                stringBuffer.append("UM-BBD_pathwayID");
                break;
            }
            case UM_BBD_REACTIONID: {
                stringBuffer.append("UM-BBD_reactionID");
                break;
            }
            case TC: {
                stringBuffer.append("TC");
                break;
            }
            case ARACYC: {
                stringBuffer.append("AraCyc");
                break;
            }
            case XX: {
                stringBuffer.append("XX");
                break;
            }
            case GOC: {
                stringBuffer.append("GOC");
                break;
            }
            case IMG: {
                stringBuffer.append("IMG");
                break;
            }
            case PMID: {
                stringBuffer.append("PMID");
                break;
            }
            case WIKIPEDIA: {
                stringBuffer.append("Wikipedia");
                break;
            }
            case OTHER: {
                stringBuffer.append("other");
                break;
            }
            default: {
                new AssertionError((Object)("unknown type: " + (Object)((Object)this.getType())));
            }
        }
        stringBuffer.append(":");
        stringBuffer.append(this.getXRef());
        return stringBuffer.toString();
    }
}

