/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.forester.go.BasicGoRelationship;
import org.forester.go.BasicGoSubset;
import org.forester.go.BasicGoTerm;
import org.forester.go.BasicGoXRef;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoRelationship;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.GoXRef;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.util.ForesterUtil;

public class TestGo {
    private static final double ZERO_DIFF = 1.0E-9;

    public static boolean isEqual(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-9;
    }

    public static boolean test(File file) {
        System.out.print("  GO ID: ");
        if (!TestGo.testGoId()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Namespace: ");
        if (!TestGo.testNamespace()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic GO term: ");
        if (!TestGo.testBasicGoTerm()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  OBO parser: ");
        if (!TestGo.testOBOparser(file)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Pfam to GO mapping: ");
        if (!TestGo.testPfamToGoMapping()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Pfam to GO parser: ");
        if (!TestGo.testPfamToGoParser(file)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Super terms: ");
        if (!TestGo.testSuperTermGetting(file)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Super term counting: ");
        if (!TestGo.testSuperTermCounting(file)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        return true;
    }

    private static boolean testBasicGoTerm() {
        try {
            BasicGoTerm basicGoTerm = new BasicGoTerm("GO:0047579", "4-hydroxymandelate oxidase activity", "molecular_function", false);
            BasicGoTerm basicGoTerm2 = new BasicGoTerm("GO:0047579", "4-hydroxymandelate oxidase activity", "molecular_function", false);
            BasicGoTerm basicGoTerm3 = new BasicGoTerm("GO:0047579", "?", "molecular_function", true);
            BasicGoTerm basicGoTerm4 = new BasicGoTerm("GO:0047579", "4-hydroxymandelate oxidase activity", "biological_process", false);
            BasicGoTerm basicGoTerm5 = new BasicGoTerm("GO:0047578", "4-hydroxymandelate oxidase activity", "molecular_function", false);
            if (!((Object)basicGoTerm).equals(basicGoTerm2)) {
                return false;
            }
            if (!((Object)basicGoTerm).equals(basicGoTerm3)) {
                return false;
            }
            if (((Object)basicGoTerm).equals(basicGoTerm4)) {
                return false;
            }
            if (((Object)basicGoTerm).hashCode() != ((Object)basicGoTerm4).hashCode()) {
                return false;
            }
            if (((Object)basicGoTerm).equals(basicGoTerm5)) {
                return false;
            }
            GoTerm goTerm = (GoTerm)basicGoTerm5.copy();
            if (!goTerm.equals(basicGoTerm5)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testGoId() {
        try {
            GoId goId = new GoId("GO:0042617");
            GoId goId2 = new GoId("GO:0042630");
            GoId goId3 = new GoId("GO:0042630");
            if (goId.equals(goId2)) {
                return false;
            }
            if (!goId2.equals(goId3)) {
                return false;
            }
            if (!goId.toString().equals("GO:0042617")) {
                return false;
            }
            if (goId2.hashCode() != goId3.hashCode()) {
                return false;
            }
            if (goId.hashCode() == goId2.hashCode()) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testNamespace() {
        try {
            GoNameSpace goNameSpace = new GoNameSpace("Biological_process");
            GoNameSpace goNameSpace2 = new GoNameSpace("Cellular_Component");
            GoNameSpace goNameSpace3 = new GoNameSpace("molecular_function");
            GoNameSpace goNameSpace4 = new GoNameSpace(GoNameSpace.GoNamespaceType.MOLECULAR_FUNCTION);
            if (goNameSpace.equals(goNameSpace2)) {
                return false;
            }
            if (!goNameSpace3.equals(goNameSpace4)) {
                return false;
            }
            if (!goNameSpace.toString().equals("biological_process")) {
                return false;
            }
            if (!goNameSpace2.toString().equals("cellular_component")) {
                return false;
            }
            if (!goNameSpace3.toString().equals("molecular_function")) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testOBOparser(File file) {
        try {
            OBOparser oBOparser = new OBOparser(new File(file + ForesterUtil.getFileSeparator() + "obo_test"), OBOparser.ReturnType.BASIC_GO_TERM);
            List<GoTerm> list = oBOparser.parse();
            if (oBOparser.getGoTermCount() != 26) {
                return false;
            }
            GoTerm goTerm = list.get(0);
            GoTerm goTerm2 = list.get(1);
            GoTerm goTerm3 = list.get(2);
            GoTerm goTerm4 = list.get(25);
            if (!goTerm.getComment().equals("")) {
                return false;
            }
            if (!goTerm.getDefinition().equals("\"The distribution of mitochondria, including the mitochondrial genome, into daughter cells after mitosis or meiosis, mediated by interactions between mitochondria and the cytoskeleton.\" [GOC:mcc, PMID:10873824, PMID:11389764]")) {
                return false;
            }
            if (!goTerm.getGoId().getId().equals("GO:0000001")) {
                return false;
            }
            if (goTerm.getGoNameSpace().equals((Object)GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) {
                return false;
            }
            if (goTerm.getGoNameSpace().getType() != GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS) {
                return false;
            }
            if (goTerm.getGoRelationships().size() != 0) {
                return false;
            }
            if (goTerm.getGoXRefs().size() != 0) {
                return false;
            }
            if (!goTerm.getName().equals("mitochondrion inheritance")) {
                return false;
            }
            if (goTerm.getSuperGoIds().size() != 2) {
                return false;
            }
            if (!goTerm.isObsolete()) {
                return false;
            }
            if (!goTerm2.getComment().equals("comment")) {
                return false;
            }
            if (!goTerm2.getDefinition().equals("\"The maintenance of the structure and integrity of the mitochondrial genome.\" [GOC:ai]")) {
                return false;
            }
            if (!goTerm2.getGoId().getId().equals("GO:0000002")) {
                return false;
            }
            if (goTerm2.getGoNameSpace().equals((Object)GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) {
                return false;
            }
            if (goTerm2.getGoNameSpace().getType() != GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS) {
                return false;
            }
            if (goTerm2.getGoRelationships().size() != 1) {
                return false;
            }
            if (goTerm2.getGoXRefs().size() != 5) {
                return false;
            }
            if (!goTerm2.getName().equals("mitochondrial genome maintenance")) {
                return false;
            }
            if (goTerm2.getSuperGoIds().size() != 1) {
                return false;
            }
            if (goTerm2.isObsolete()) {
                return false;
            }
            if (!goTerm2.getGoXRefs().get(0).equals(new BasicGoXRef("EC:2.4.1.-"))) {
                return false;
            }
            if (!goTerm2.getGoXRefs().get(0).getXRef().equals("2.4.1.-")) {
                return false;
            }
            if (goTerm2.getGoXRefs().get(0).getType() != GoXRef.Type.EC) {
                return false;
            }
            if (goTerm2.getGoXRefs().get(0).equals(new BasicGoXRef("EC:2.4.1.1"))) {
                return false;
            }
            if (goTerm2.getGoXRefs().get(0).equals(new BasicGoXRef("Reactome:2.4.1.-"))) {
                return false;
            }
            if (!goTerm2.getGoXRefs().get(1).equals(new BasicGoXRef("Reactome:7672"))) {
                return false;
            }
            if (!goTerm2.getGoXRefs().get(2).equals(new BasicGoXRef("MetaCyc:SIROHEME-FERROCHELAT-RXN"))) {
                return false;
            }
            if (!goTerm2.getGoXRefs().get(3).equals(new BasicGoXRef("RESID:AA02376"))) {
                return false;
            }
            if (!goTerm2.getGoXRefs().get(4).equals(new BasicGoXRef("UM-BBD_enzymeID:e0271"))) {
                return false;
            }
            if (!goTerm2.getGoRelationships().get(0).equals(new BasicGoRelationship("part_of GO:0007052"))) {
                return false;
            }
            if (!goTerm2.getGoRelationships().get(0).getGoId().equals(new GoId("GO:0007052"))) {
                return false;
            }
            if (!goTerm2.getGoRelationships().get(0).getGoId().getId().equals("GO:0007052")) {
                return false;
            }
            if (goTerm2.getGoRelationships().get(0).getType() != GoRelationship.Type.PART_OF) {
                return false;
            }
            if (goTerm2.getGoRelationships().get(0).equals(new BasicGoRelationship("part_of GO:1007052"))) {
                return false;
            }
            if (!goTerm2.getSuperGoIds().get(0).equals(new GoId("GO:0007005"))) {
                return false;
            }
            if (goTerm2.getSuperGoIds().get(0).equals(new GoId("GO:1007005"))) {
                return false;
            }
            if (!goTerm4.getGoId().getId().equals("GO:0000030")) {
                return false;
            }
            if (!goTerm4.getGoId().equals(new GoId("GO:0000030"))) {
                return false;
            }
            if (goTerm4.getGoId().getId().equals("GO:0000031")) {
                return false;
            }
            if (goTerm4.getGoId().equals(new GoId("GO:0000031"))) {
                return false;
            }
            if (goTerm3.getGoSubsets().size() != 3) {
                return false;
            }
            if (!goTerm3.getGoSubsets().contains(new BasicGoSubset("goslim_generic"))) {
                return false;
            }
            if (!goTerm3.getGoSubsets().contains(new BasicGoSubset("goslim_plant"))) {
                return false;
            }
            if (!goTerm3.getGoSubsets().contains(new BasicGoSubset("gosubset_prok"))) {
                return false;
            }
            if (goTerm3.getGoSubsets().contains(new BasicGoSubset("goslim_candida"))) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testPfamToGoMapping() {
        try {
            PfamToGoMapping pfamToGoMapping = new PfamToGoMapping("A", new GoId("GO:0000001"));
            PfamToGoMapping pfamToGoMapping2 = new PfamToGoMapping("A", new GoId("GO:0000001"));
            PfamToGoMapping pfamToGoMapping3 = new PfamToGoMapping("B", new GoId("GO:0000001"));
            PfamToGoMapping pfamToGoMapping4 = new PfamToGoMapping("A", new GoId("GO:0000002"));
            PfamToGoMapping pfamToGoMapping5 = new PfamToGoMapping("B", new GoId("GO:0000002"));
            if (!pfamToGoMapping.equals(pfamToGoMapping)) {
                return false;
            }
            if (!pfamToGoMapping.equals(pfamToGoMapping2)) {
                return false;
            }
            if (pfamToGoMapping.equals(pfamToGoMapping3)) {
                return false;
            }
            if (pfamToGoMapping.equals(pfamToGoMapping4)) {
                return false;
            }
            if (pfamToGoMapping.equals(pfamToGoMapping5)) {
                return false;
            }
            if (pfamToGoMapping.compareTo(pfamToGoMapping4) != 0) {
                return false;
            }
            if (pfamToGoMapping.compareTo(pfamToGoMapping3) >= 0) {
                return false;
            }
            if (pfamToGoMapping3.compareTo(pfamToGoMapping) <= 0) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testPfamToGoParser(File file) {
        try {
            PfamToGoParser pfamToGoParser = new PfamToGoParser(new File(file + ForesterUtil.getFileSeparator() + "pfam_to_go_test"));
            List<PfamToGoMapping> list = pfamToGoParser.parse();
            if (pfamToGoParser.getMappingCount() != 426) {
                return false;
            }
            if (list.size() != 426) {
                return false;
            }
            PfamToGoMapping pfamToGoMapping = list.get(0);
            PfamToGoMapping pfamToGoMapping2 = list.get(1);
            PfamToGoMapping pfamToGoMapping3 = list.get(2);
            PfamToGoMapping pfamToGoMapping4 = list.get(3);
            PfamToGoMapping pfamToGoMapping5 = list.get(4);
            PfamToGoMapping pfamToGoMapping6 = list.get(5);
            PfamToGoMapping pfamToGoMapping7 = list.get(424);
            PfamToGoMapping pfamToGoMapping8 = list.get(425);
            if (!pfamToGoMapping.getKey().equals("7tm_1")) {
                return false;
            }
            if (!pfamToGoMapping.getValue().equals(new GoId("GO:0001584"))) {
                return false;
            }
            if (pfamToGoMapping.getKey().equals("7tm_x")) {
                return false;
            }
            if (pfamToGoMapping.getValue().equals(new GoId("GO:0001585"))) {
                return false;
            }
            if (!pfamToGoMapping2.getKey().equals("7tm_1")) {
                return false;
            }
            if (!pfamToGoMapping2.getValue().equals(new GoId("GO:0007186"))) {
                return false;
            }
            if (!pfamToGoMapping3.getKey().equals("7tm_1")) {
                return false;
            }
            if (!pfamToGoMapping3.getValue().equals(new GoId("GO:0016021"))) {
                return false;
            }
            if (!pfamToGoMapping4.getKey().equals("7tm_2")) {
                return false;
            }
            if (!pfamToGoMapping4.getValue().equals(new GoId("GO:0004930"))) {
                return false;
            }
            if (!pfamToGoMapping5.getKey().equals("7tm_2")) {
                return false;
            }
            if (!pfamToGoMapping5.getValue().equals(new GoId("GO:0016020"))) {
                return false;
            }
            if (!pfamToGoMapping6.getKey().equals("7tm_3")) {
                return false;
            }
            if (!pfamToGoMapping6.getValue().equals(new GoId("GO:0008067"))) {
                return false;
            }
            if (!pfamToGoMapping7.getKey().equals("OMPdecase")) {
                return false;
            }
            if (!pfamToGoMapping7.getValue().equals(new GoId("GO:0006207"))) {
                return false;
            }
            if (!pfamToGoMapping8.getKey().equals("Bac_DNA_binding")) {
                return false;
            }
            if (!pfamToGoMapping8.getValue().equals(new GoId("GO:0003677"))) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testSuperTermCounting(File file) {
        try {
            OBOparser oBOparser = new OBOparser(new File(file + ForesterUtil.getFileSeparator() + "gene_ontology_edit.obo"), OBOparser.ReturnType.BASIC_GO_TERM);
            List<GoTerm> list = oBOparser.parse();
            if (oBOparser.getGoTermCount() != 27748) {
                return false;
            }
            Map<GoId, GoTerm> map = GoUtils.createGoIdToGoTermMap(list);
            ArrayList<GoTerm> arrayList = new ArrayList<GoTerm>();
            ArrayList<GoTerm> arrayList2 = new ArrayList<GoTerm>();
            arrayList2.add(new BasicGoTerm(new GoId("GO:0005690"), "snRNP U4atac", GoNameSpace.createUnassigned(), false));
            arrayList2.add(new BasicGoTerm(new GoId("GO:0009698"), "phenylpropanoid metabolic process", GoNameSpace.createUnassigned(), false));
            arrayList2.add(new BasicGoTerm(new GoId("GO:0008150"), "biological_process", GoNameSpace.createUnassigned(), false));
            arrayList2.add(new BasicGoTerm(new GoId("GO:0006915"), "apoptosis", GoNameSpace.createUnassigned(), false));
            arrayList2.add(new BasicGoTerm(new GoId("GO:0001783"), "B cell apoptosis", GoNameSpace.createUnassigned(), false));
            arrayList2.add(new BasicGoTerm(new GoId("GO:0010657"), "muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            arrayList2.add(new BasicGoTerm(new GoId("GO:0010657"), "muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            arrayList2.add(new BasicGoTerm(new GoId("GO:0010658"), "striated muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            arrayList2.add(new BasicGoTerm(new GoId("GO:0043065"), "positive regulation of apoptosis", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0016265"), "death", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0006915"), "apoptosis", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0008150"), "biological_process", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0010657"), "muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0010658"), "striated muscle cell apoptosis", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0046242"), "o-xylene biosynthetic process", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0016326"), "kinesin motor activity", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0005575"), "cellular_component", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0032502"), "developmental process", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0051094"), "positive regulation of developmental process", GoNameSpace.createUnassigned(), false));
            arrayList.add(new BasicGoTerm(new GoId("GO:0048522"), "positive regulation of cellular process", GoNameSpace.createUnassigned(), false));
            LinkedHashMap<GoId, Integer> linkedHashMap = GoUtils.countCategories(arrayList, arrayList2, map);
            if ((Integer)linkedHashMap.get(new GoId("GO:0016265")) != 5) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0006915")) != 5) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0008150")) != 8) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0010657")) != 3) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0010658")) != 1) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0046242")) != 0) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0016326")) != 0) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0005575")) != 1) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0032502")) != 5) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0051094")) != 1) {
                return false;
            }
            if ((Integer)linkedHashMap.get(new GoId("GO:0048522")) != 1) {
                return false;
            }
            ArrayList<GoId> arrayList3 = new ArrayList<GoId>();
            ArrayList<GoId> arrayList4 = new ArrayList<GoId>();
            arrayList4.add(new GoId("GO:0005690"));
            arrayList4.add(new GoId("GO:0009698"));
            arrayList4.add(new GoId("GO:0008150"));
            arrayList4.add(new GoId("GO:0006915"));
            arrayList4.add(new GoId("GO:0001783"));
            arrayList4.add(new GoId("GO:0010657"));
            arrayList4.add(new GoId("GO:0010657"));
            arrayList4.add(new GoId("GO:0010658"));
            arrayList3.add(new GoId("GO:0016265"));
            arrayList3.add(new GoId("GO:0006915"));
            arrayList3.add(new GoId("GO:0008150"));
            arrayList3.add(new GoId("GO:0010657"));
            arrayList3.add(new GoId("GO:0010658"));
            arrayList3.add(new GoId("GO:0046242"));
            arrayList3.add(new GoId("GO:0016326"));
            arrayList3.add(new GoId("GO:0005575"));
            LinkedHashMap<GoId, Integer> linkedHashMap2 = GoUtils.countCategoriesId(arrayList3, arrayList4, map);
            if ((Integer)linkedHashMap2.get(new GoId("GO:0016265")) != 5) {
                return false;
            }
            if ((Integer)linkedHashMap2.get(new GoId("GO:0006915")) != 5) {
                return false;
            }
            if ((Integer)linkedHashMap2.get(new GoId("GO:0008150")) != 7) {
                return false;
            }
            if ((Integer)linkedHashMap2.get(new GoId("GO:0010657")) != 3) {
                return false;
            }
            if ((Integer)linkedHashMap2.get(new GoId("GO:0010658")) != 1) {
                return false;
            }
            if ((Integer)linkedHashMap2.get(new GoId("GO:0046242")) != 0) {
                return false;
            }
            if ((Integer)linkedHashMap2.get(new GoId("GO:0016326")) != 0) {
                return false;
            }
            if ((Integer)linkedHashMap2.get(new GoId("GO:0005575")) != 1) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testSuperTermGetting(File file) {
        try {
            OBOparser oBOparser = new OBOparser(new File(file + ForesterUtil.getFileSeparator() + "gene_ontology_edit.obo"), OBOparser.ReturnType.BASIC_GO_TERM);
            List<GoTerm> list = oBOparser.parse();
            if (oBOparser.getGoTermCount() != 27748) {
                return false;
            }
            Map<GoId, GoTerm> map = GoUtils.createGoIdToGoTermMap(list);
            SortedSet<GoTerm> sortedSet = GoUtils.getAllSuperGoTerms(new GoId("GO:0002339"), map);
            if (sortedSet.size() != 2) {
                return false;
            }
            if (!sortedSet.contains(new BasicGoTerm(new GoId("GO:0002376"), "immune system process", GoNameSpace.createBiologicalProcess(), false))) {
                return false;
            }
            if (!sortedSet.contains(new BasicGoTerm(new GoId("GO:0008150"), "biological process", GoNameSpace.createBiologicalProcess(), false))) {
                return false;
            }
            SortedSet<GoTerm> sortedSet2 = GoUtils.getAllSuperGoTerms(new GoId("GO:0030183"), map);
            if (sortedSet2.size() != 12) {
                return false;
            }
            SortedSet<GoTerm> sortedSet3 = GoUtils.getAllSuperGoTerms(new GoId("GO:0008150"), map);
            if (sortedSet3.size() != 0) {
                return false;
            }
            SortedSet<GoTerm> sortedSet4 = GoUtils.getAllSuperGoTerms(new GoId("GO:0006468"), map);
            if (sortedSet4.size() != 16) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

