/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;

public final class ParserUtils {
    private static final String SN_BN = "[A-Z][a-z]{2,30}[_ ][a-z]{3,30}";
    public static final String TAX_CODE = "(?:[A-Z0-9]{3,5})";
    public static final String TAX_CODE_LO = "(?:[A-Z]{5})|RAT|PIG|PEA";
    public static final Pattern TAXOMONY_CODE_PATTERN_A = Pattern.compile("(?:\\b|_)((?:[A-Z0-9]{3,5}))(?:\\b|_)");
    public static final Pattern TAXOMONY_CODE_PATTERN_A_LO = Pattern.compile("_((?:[A-Z]{5})|RAT|PIG|PEA)(?:\\b|_)");
    public static final Pattern TAXOMONY_CODE_PATTERN_BRACKETED = Pattern.compile("\\[((?:[A-Z0-9]{3,5}))\\]");
    public static final Pattern TAXOMONY_CODE_PATTERN_PFR = Pattern.compile("(?:\\b|_)[a-zA-Z0-9]{3,}_((?:[A-Z0-9]{3,5}))\\b");
    public static final Pattern TAXOMONY_SN_PATTERN_GENUS = Pattern.compile("([A-Z][a-z]{2,30})");
    public static final Pattern TAXOMONY_SN_PATTERN_SN = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30})(?:(\\s*$)|([_ ][a-z]*[A-Z0-9]))");
    public static final Pattern TAXOMONY_SN_PATTERN_SNS = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ][a-z]{3,30})[_ ][a-z]*[A-Z0-9]");
    public static final Pattern TAXOMONY_SN_PATTERN_SNS2 = Pattern.compile("[A-Z0-9][a-z]*[_ ]([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ][a-z]{3,30})\\s*$");
    public static final Pattern TAXOMONY_SN_PATTERN_SP = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ]sp\\.?)(?:\\b|_)?");
    public static final Pattern TAXOMONY_SN_PATTERN_STRAIN_1 = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ](?:str|subsp|ssp|var)[a-z]{0,5}\\.?[_ ]\\S{1,60})(?:\\b|_)");
    public static final Pattern TAXOMONY_SN_PATTERN_STRAIN_2 = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ]\\((?:str|subsp|ssp|var)[a-z]{0,5}\\.?[_ ]\\S{1,60}\\))");
    public static final Pattern TAXOMONY_SN_PATTERN_STRAIN_SUBSTRAIN = Pattern.compile("(?:\\b|_)([A-Z][a-z]{2,30}[_ ][a-z]{3,30}[_ ]str[a-z]{0,3}\\.?[_ ]\\S{1,60}[_ ]substr[a-z]{0,3}\\.?[_ ]\\S{1,60})(?:\\b|_)");
    private static final Pattern TAXOMONY_CODE_PATTERN_PFS = Pattern.compile("(?:\\b|_)[A-Z0-9]{4,}_((?:[A-Z0-9]{3,5}))/\\d+-\\d+\\b");
    private static final Pattern TAXOMONY_UNIPROT_ID_PATTERN_PFR = Pattern.compile("(?:\\b|_)[A-Z0-9]{1,}_(\\d{1,7})\\b");
    private static final Pattern TAXOMONY_UNIPROT_ID_PATTERN_PFS = Pattern.compile("(?:\\b|_)[A-Z0-9]{4,}_(\\d{1,7})/\\d+-\\d+\\b");

    public static final PhylogenyParser createParserDependingFileContents(File file, boolean bl) throws FileNotFoundException, IOException {
        PhylogenyParser phylogenyParser = null;
        String string = ForesterUtil.getFirstLine(file).trim().toLowerCase();
        if (string.startsWith("<")) {
            ClassLoader classLoader;
            URL uRL;
            phylogenyParser = PhyloXmlParser.createPhyloXmlParser();
            if (bl && (uRL = (classLoader = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)phylogenyParser).setValidateAgainstSchema(uRL.toString());
            }
        } else {
            phylogenyParser = string.startsWith("nexus") || string.startsWith("#nexus") || string.startsWith("# nexus") || string.startsWith("begin") ? new NexusPhylogeniesParser() : new NHXParser();
        }
        return phylogenyParser;
    }

    public static final PhylogenyParser createParserDependingOnFileType(File file, boolean bl) throws FileNotFoundException, IOException {
        PhylogenyParser phylogenyParser = null;
        phylogenyParser = ParserUtils.createParserDependingOnSuffix(file.getName(), bl);
        if (phylogenyParser == null) {
            phylogenyParser = ParserUtils.createParserDependingFileContents(file, bl);
        }
        if (phylogenyParser != null && file.toString().toLowerCase().endsWith(".zip")) {
            if (phylogenyParser instanceof PhyloXmlParser) {
                ((PhyloXmlParser)phylogenyParser).setZippedInputstream(true);
            } else if (phylogenyParser instanceof TolParser) {
                ((TolParser)phylogenyParser).setZippedInputstream(true);
            }
        }
        return phylogenyParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PhylogenyParser createParserDependingOnUrlContents(URL uRL, boolean bl) throws FileNotFoundException, IOException {
        String string = uRL.getFile().toString().toLowerCase();
        PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnSuffix(string, bl);
        if (phylogenyParser == null) {
            String string2 = ForesterUtil.getFirstLine(uRL).trim().toLowerCase();
            if (string2.startsWith("<")) {
                phylogenyParser = PhyloXmlParser.createPhyloXmlParser();
                if (bl) {
                    ClassLoader classLoader = PhyloXmlParser.class.getClassLoader();
                    URL uRL2 = classLoader.getResource("resources/phyloxml.xsd");
                    if (uRL2 == null) throw new RuntimeException("failed to get URL for phyloXML XSD from jar file from [resources/phyloxml.xsd]");
                    ((PhyloXmlParser)phylogenyParser).setValidateAgainstSchema(uRL2.toString());
                }
            } else {
                phylogenyParser = string2.startsWith("nexus") || string2.startsWith("#nexus") || string2.startsWith("# nexus") || string2.startsWith("begin") ? new NexusPhylogeniesParser() : new NHXParser();
            }
        }
        if (phylogenyParser == null || !string.endsWith(".zip")) return phylogenyParser;
        if (phylogenyParser instanceof PhyloXmlParser) {
            ((PhyloXmlParser)phylogenyParser).setZippedInputstream(true);
            return phylogenyParser;
        } else {
            if (!(phylogenyParser instanceof TolParser)) return phylogenyParser;
            ((TolParser)phylogenyParser).setZippedInputstream(true);
        }
        return phylogenyParser;
    }

    public static BufferedReader createReader(Object object, String string) throws IOException, FileNotFoundException {
        BufferedReader bufferedReader = null;
        if (object instanceof File || object instanceof String) {
            File file = null;
            file = object instanceof File ? (File)object : new File((String)object);
            if (!file.exists()) {
                throw new IOException("[" + file.getAbsolutePath() + "] does not exist");
            }
            if (!file.isFile()) {
                throw new IOException("[" + file.getAbsolutePath() + "] is not a file");
            }
            if (!file.canRead()) {
                throw new IOException("[" + file.getAbsolutePath() + "] is not a readable");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            bufferedReader = new BufferedReader(inputStreamReader);
        } else if (object instanceof InputStream) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, string));
        } else if (object instanceof StringBuffer || object instanceof StringBuilder) {
            bufferedReader = new BufferedReader(new StringReader(object.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + object.getClass() + "] (can only parse objects of type File/String, InputStream, StringBuffer, or StringBuilder)");
        }
        return bufferedReader;
    }

    public static final String extractScientificNameFromNodeName(String string) {
        Matcher matcher = TAXOMONY_SN_PATTERN_STRAIN_SUBSTRAIN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1).replace('_', ' ');
            if (string2.indexOf(" str ") > 4) {
                string2 = string2.replaceFirst(" str ", " str. ");
            }
            if (string2.indexOf(" substr ") > 4) {
                string2 = string2.replaceFirst(" substr ", " substr. ");
            }
            return string2;
        }
        Matcher matcher2 = TAXOMONY_SN_PATTERN_STRAIN_1.matcher(string);
        if (matcher2.find()) {
            String string3 = matcher2.group(1).replace('_', ' ');
            if (string3.indexOf(" str ") > 4) {
                string3 = string3.replaceFirst(" str ", " str. ");
            } else if (string3.indexOf(" subsp ") > 4) {
                string3 = string3.replaceFirst(" subsp ", " subsp. ");
            } else if (string3.indexOf(" ssp ") > 4) {
                string3 = string3.replaceFirst(" ssp ", " subsp. ");
            } else if (string3.indexOf(" ssp. ") > 4) {
                string3 = string3.replaceFirst(" ssp. ", " subsp. ");
            } else if (string3.indexOf(" var ") > 4) {
                string3 = string3.replaceFirst(" var ", " var. ");
            }
            return string3;
        }
        Matcher matcher3 = TAXOMONY_SN_PATTERN_STRAIN_2.matcher(string);
        if (matcher3.find()) {
            String string4 = matcher3.group(1).replace('_', ' ');
            if (string4.indexOf(" (str ") > 4) {
                string4 = string4.replaceFirst(" \\(str ", " (str. ");
            } else if (string4.indexOf(" (subsp ") > 4) {
                string4 = string4.replaceFirst(" \\(subsp ", " (subsp. ");
            } else if (string4.indexOf(" (ssp ") > 4) {
                string4 = string4.replaceFirst(" \\(ssp ", " (subsp. ");
            } else if (string4.indexOf(" (ssp. ") > 4) {
                string4 = string4.replaceFirst(" \\(ssp. ", " (subsp. ");
            } else if (string4.indexOf(" (var ") > 4) {
                string4 = string4.replaceFirst(" \\(var ", " (var. ");
            }
            return string4;
        }
        Matcher matcher4 = TAXOMONY_SN_PATTERN_SNS.matcher(string);
        if (matcher4.find()) {
            return matcher4.group(1).replace('_', ' ');
        }
        Matcher matcher5 = TAXOMONY_SN_PATTERN_SNS2.matcher(string);
        if (matcher5.find()) {
            return matcher5.group(1).replace('_', ' ');
        }
        Matcher matcher6 = TAXOMONY_SN_PATTERN_SN.matcher(string);
        if (matcher6.find()) {
            return matcher6.group(1).replace('_', ' ');
        }
        Matcher matcher7 = TAXOMONY_SN_PATTERN_SP.matcher(string);
        if (matcher7.find()) {
            String string5 = matcher7.group(1).replace('_', ' ');
            if (string5.endsWith(" sp")) {
                string5 = string5 + ".";
            }
            return string5;
        }
        return null;
    }

    public static final String extractTaxonomyCodeFromNodeName(String string, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) {
        Matcher matcher = TAXOMONY_CODE_PATTERN_PFS.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        if (tAXONOMY_EXTRACTION == NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED || tAXONOMY_EXTRACTION == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE) {
            matcher = TAXOMONY_CODE_PATTERN_PFR.matcher(string);
            if (matcher.find()) {
                return matcher.group(1);
            }
            if (tAXONOMY_EXTRACTION == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE && (matcher = TAXOMONY_CODE_PATTERN_A.matcher(string)).find()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    public static final String extractTaxonomyDataFromNodeName(PhylogenyNode phylogenyNode, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) throws PhyloXmlDataFormatException {
        String string;
        if (tAXONOMY_EXTRACTION == NHXParser.TAXONOMY_EXTRACTION.NO) {
            throw new IllegalArgumentException();
        }
        String string2 = ParserUtils.extractUniprotTaxonomyIdFromNodeName(phylogenyNode.getName(), tAXONOMY_EXTRACTION);
        if (!ForesterUtil.isEmpty(string2)) {
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
            }
            phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string2, "uniprot"));
            return string2;
        }
        String string3 = null;
        if (tAXONOMY_EXTRACTION == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE && ForesterUtil.isEmpty(string3 = ParserUtils.extractTaxonomyCodeFromNodeNameLettersOnly(phylogenyNode.getName())) && !ForesterUtil.isEmpty(string = ParserUtils.extractScientificNameFromNodeName(phylogenyNode.getName()))) {
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
            }
            phylogenyNode.getNodeData().getTaxonomy().setScientificName(string);
            return string;
        }
        if (ForesterUtil.isEmpty(string3)) {
            string3 = ParserUtils.extractTaxonomyCodeFromNodeName(phylogenyNode.getName(), tAXONOMY_EXTRACTION);
        }
        if (!ForesterUtil.isEmpty(string3)) {
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
            }
            phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(string3);
            return string3;
        }
        return null;
    }

    public static final String extractUniprotTaxonomyIdFromNodeName(String string, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) {
        Matcher matcher = TAXOMONY_UNIPROT_ID_PATTERN_PFS.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        if ((tAXONOMY_EXTRACTION == NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_RELAXED || tAXONOMY_EXTRACTION == NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE) && (matcher = TAXOMONY_UNIPROT_ID_PATTERN_PFR.matcher(string)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final Phylogeny[] readPhylogenies(File file) throws FileNotFoundException, IOException {
        return PhylogenyMethods.readPhylogenies(ParserUtils.createParserDependingOnFileType(file, true), file);
    }

    public static final Phylogeny[] readPhylogenies(String string) throws FileNotFoundException, IOException {
        return ParserUtils.readPhylogenies(new File(string));
    }

    private static final PhylogenyParser createParserDependingOnSuffix(String string, boolean bl) {
        PhylogenyParser phylogenyParser = null;
        String string2 = string.toLowerCase();
        if (string2.endsWith(".tol") || string2.endsWith(".tolxml") || string2.endsWith(".tol.zip")) {
            phylogenyParser = new TolParser();
        } else if (string2.endsWith(".xml") || string2.endsWith("phyloxml") || string2.endsWith(".zip")) {
            ClassLoader classLoader;
            URL uRL;
            phylogenyParser = PhyloXmlParser.createPhyloXmlParser();
            if (bl && (uRL = (classLoader = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)phylogenyParser).setValidateAgainstSchema(uRL.toString());
            }
        } else if (string2.endsWith(".nexus") || string2.endsWith(".nex") || string2.endsWith(".nx")) {
            phylogenyParser = new NexusPhylogeniesParser();
        } else if (string2.endsWith(".nhx") || string2.endsWith(".nh") || string2.endsWith(".newick") || string2.endsWith(".nwk")) {
            phylogenyParser = new NHXParser();
        }
        return phylogenyParser;
    }

    private static final String extractTaxonomyCodeFromNodeNameLettersOnly(String string) {
        Matcher matcher = TAXOMONY_CODE_PATTERN_A_LO.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

