/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Confidence
implements PhylogenyData,
Comparable<Confidence> {
    public static final int CONFIDENCE_DEFAULT_VALUE = -2147483647;
    private double _value;
    private double _sd;
    private String _type;
    public static final NumberFormat FORMATTER;

    public Confidence() {
        this.init();
    }

    public Confidence(double d, String string) {
        this.setValue(d);
        this.setType(string);
        this.setStandardDeviation(-2.147483647E9);
    }

    public Confidence(double d, String string, double d2) {
        this.setValue(d);
        this.setType(string);
        this.setStandardDeviation(d2);
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer().append(ForesterUtil.FORMATTER_6.format(this.getValue()));
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getType())) {
            stringBuffer.append("[");
            stringBuffer.append(this.getType());
            stringBuffer.append("] ");
        }
        stringBuffer.append(ForesterUtil.FORMATTER_6.format(this.getValue()));
        if (this.getStandardDeviation() != -2.147483647E9) {
            stringBuffer.append(" (sd=");
            stringBuffer.append(this.getStandardDeviation());
            stringBuffer.append(")");
        }
        return stringBuffer;
    }

    @Override
    public int compareTo(Confidence confidence) {
        if (this == confidence) {
            return 0;
        }
        return this.getType().compareToIgnoreCase(confidence.getType());
    }

    @Override
    public PhylogenyData copy() {
        return new Confidence(this.getValue(), this.getType(), this.getStandardDeviation());
    }

    public String getType() {
        return this._type;
    }

    public double getValue() {
        return this._value;
    }

    public double getStandardDeviation() {
        return this._sd;
    }

    public void init() {
        this.setValue(-2.147483647E9);
        this.setType("");
        this.setStandardDeviation(-2.147483647E9);
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (phylogenyData == null) {
            return false;
        }
        if (!(phylogenyData instanceof Confidence)) {
            return false;
        }
        Confidence confidence = (Confidence)phylogenyData;
        if (confidence.getValue() != this.getValue()) {
            return false;
        }
        return confidence.getType().equals(this.getType());
    }

    public void setType(String string) {
        this._type = string;
    }

    public void setValue(double d) {
        this._value = d;
    }

    public void setStandardDeviation(double d) {
        this._sd = d;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("B=");
        stringBuffer.append(FORMATTER.format(ForesterUtil.round(this.getValue(), 9)));
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.getValue() == -2.147483647E9 || this.getValue() < -1.0) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        if (this.getStandardDeviation() != -2.147483647E9) {
            PhylogenyDataUtil.appendElement(writer, "confidence", FORMATTER.format(ForesterUtil.round(this.getValue(), 9)), "type", ForesterUtil.isEmpty(this.getType()) ? "unknown" : this.getType(), "stddev", String.valueOf(ForesterUtil.round(this.getStandardDeviation(), 9)));
        } else {
            PhylogenyDataUtil.appendElement(writer, "confidence", FORMATTER.format(ForesterUtil.round(this.getValue(), 9)), "type", ForesterUtil.isEmpty(this.getType()) ? "unknown" : this.getType());
        }
    }

    public String toString() {
        return this.asText().toString();
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        FORMATTER = new DecimalFormat("#.#########", decimalFormatSymbols);
        FORMATTER.setMaximumFractionDigits(9);
    }
}

