/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.Point;
import org.forester.phylogeny.data.Polygon;
import org.forester.util.ForesterUtil;

public class Distribution
implements PhylogenyData {
    private final String _desc;
    private final List<Point> _points;
    private final List<Polygon> _polygons;

    public Distribution(String string) {
        this._desc = string;
        this._points = null;
        this._polygons = null;
    }

    public Distribution(String string, List<Point> list) {
        this._desc = null;
        this._points = list;
        this._polygons = null;
    }

    public Distribution(String string, List<Point> list, List<Polygon> list2) {
        this._desc = string;
        this._points = list;
        this._polygons = list2;
    }

    public boolean isEmpty() {
        if (ForesterUtil.isEmpty(this._desc) && this.getPoints() != null && this.getPoints().size() == 1 && ForesterUtil.isEmpty(this._polygons) && Point.isSeemsEmpty(this.getPoints().get(0))) {
            return true;
        }
        return ForesterUtil.isEmpty(this._desc) && ForesterUtil.isEmpty(this._points) && ForesterUtil.isEmpty(this._polygons);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEmpty()) {
            return stringBuffer;
        }
        stringBuffer.append("Distribution: ");
        if (!ForesterUtil.isEmpty(this.getDesc())) {
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
            stringBuffer.append(" Description: ");
            stringBuffer.append(this.getDesc());
        }
        int n = 0;
        if (this.getPoints() != null) {
            for (Point phylogenyData : this.getPoints()) {
                if (phylogenyData == null || Point.isSeemsEmpty(phylogenyData)) continue;
                stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
                stringBuffer.append(" Point " + n + ": ");
                stringBuffer.append(phylogenyData.asSimpleText());
                ++n;
            }
        }
        n = 0;
        if (this.getPolygons() != null) {
            for (Polygon polygon : this.getPolygons()) {
                if (polygon == null) continue;
                stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
                stringBuffer.append(" Polygon " + n + ":");
                stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
                stringBuffer.append(polygon.asSimpleText());
                ++n;
            }
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        ArrayList<Point> arrayList = null;
        ArrayList<Polygon> arrayList2 = null;
        if (this.getPoints() != null) {
            arrayList = new ArrayList<Point>();
            for (Point phylogenyData : this.getPoints()) {
                arrayList.add((Point)phylogenyData.copy());
            }
        }
        if (this.getPolygons() != null) {
            arrayList2 = new ArrayList<Polygon>();
            for (Polygon polygon : this.getPolygons()) {
                arrayList2.add((Polygon)polygon.copy());
            }
        }
        return new Distribution(this.getDesc(), arrayList, arrayList2);
    }

    public String getDesc() {
        return this._desc;
    }

    public List<Point> getPoints() {
        return this._points;
    }

    public List<Polygon> getPolygons() {
        return this._polygons;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "distribution");
        if (!ForesterUtil.isEmpty(this.getDesc())) {
            PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), string);
        }
        String string2 = string + "  ";
        if (this.getPoints() != null) {
            for (Point phylogenyData : this.getPoints()) {
                if (phylogenyData == null || Point.isSeemsEmpty(phylogenyData)) continue;
                phylogenyData.toPhyloXML(writer, n, string2);
            }
        }
        if (this.getPolygons() != null) {
            for (Polygon polygon : this.getPolygons()) {
                if (polygon == null) continue;
                polygon.toPhyloXML(writer, n, string2);
            }
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "distribution");
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

