/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.factories;

import java.io.IOException;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

public class ParserBasedPhylogenyFactory
implements PhylogenyFactory {
    private static final PhylogenyFactory _instance;

    private ParserBasedPhylogenyFactory() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public synchronized Phylogeny[] create(Object object, Object object2) throws IOException {
        if (!(object2 instanceof PhylogenyParser)) {
            throw new IllegalArgumentException("attempt to use object of type other than PhylogenyParser as creator for ParserBasedPhylogenyFactory");
        }
        PhylogenyParser phylogenyParser = (PhylogenyParser)object2;
        phylogenyParser.setSource(object);
        return phylogenyParser.parse();
    }

    public synchronized Phylogeny[] create(Object object, Object object2, String string) throws IOException {
        if (!(object2 instanceof PhylogenyParser)) {
            throw new IllegalArgumentException("attempt to use object of type other than PhylogenyParser as creator for ParserBasedPhylogenyFactory.");
        }
        if (!(object2 instanceof PhyloXmlParser)) {
            throw new IllegalArgumentException("attempt to use schema location with other than phyloXML parser");
        }
        PhyloXmlParser phyloXmlParser = (PhyloXmlParser)object2;
        if (!ForesterUtil.isEmpty(string)) {
            phyloXmlParser.setValidateAgainstSchema(string);
        }
        phyloXmlParser.setSource(object);
        return phyloXmlParser.parse();
    }

    public static PhylogenyFactory getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new ParserBasedPhylogenyFactory();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

