/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import java.util.Stack;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PostOrderStackObject;

public final class PostorderTreeIterator
implements PhylogenyNodeIterator {
    private final Phylogeny _tree;
    private final PhylogenyNode _root;
    private boolean _has_next;
    private final Stack<PostOrderStackObject> _stack;

    public PostorderTreeIterator(Phylogeny phylogeny) throws IllegalArgumentException {
        if (phylogeny.isEmpty()) {
            throw new IllegalArgumentException("Attempt to use PostorderTreeIterator on an empty phylogeny.");
        }
        this._tree = phylogeny;
        this._root = this.getTree().getRoot();
        this._stack = new Stack();
        this.reset();
    }

    private final PhylogenyNode getRoot() {
        return this._root;
    }

    private final Stack<PostOrderStackObject> getStack() {
        return this._stack;
    }

    private final Phylogeny getTree() {
        return this._tree;
    }

    @Override
    public final boolean hasNext() {
        return this._has_next;
    }

    @Override
    public final PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        while (true) {
            PostOrderStackObject postOrderStackObject = this.getStack().pop();
            PhylogenyNode phylogenyNode = postOrderStackObject.getNode();
            int n = postOrderStackObject.getPhase();
            if (n > phylogenyNode.getNumberOfDescendants()) {
                this.setHasNext(phylogenyNode != this.getRoot());
                return phylogenyNode;
            }
            this.getStack().push(new PostOrderStackObject(phylogenyNode, n + 1));
            if (!phylogenyNode.isInternal()) continue;
            this.getStack().push(new PostOrderStackObject(phylogenyNode.getChildNode(n - 1), 1));
        }
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void reset() {
        this.setHasNext(true);
        this.getStack().clear();
        this.getStack().push(new PostOrderStackObject(this.getTree().getRoot(), 1));
    }

    private final void setHasNext(boolean bl) {
        this._has_next = bl;
    }
}

