/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.HashMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.ForesterUtil;

public class SDI {
    final Phylogeny _gene_tree;
    final Phylogeny _species_tree;
    int _duplications_sum;
    int _mapping_cost;

    public SDI(Phylogeny phylogeny, Phylogeny phylogeny2) throws SDIException {
        if (phylogeny2.isEmpty() || phylogeny.isEmpty()) {
            throw new IllegalArgumentException("attempt to infer duplications using empty tree(s)");
        }
        if (!phylogeny2.isRooted()) {
            throw new IllegalArgumentException("attempt to infer duplications on unrooted species tree");
        }
        this._gene_tree = phylogeny;
        this._species_tree = phylogeny2;
        this._mapping_cost = -1;
        this._duplications_sum = 0;
        PhylogenyMethods.preOrderReId(this.getSpeciesTree());
        this.linkNodesOfG();
        this.geneTreePostOrderTraversal(this.getGeneTree().getRoot());
    }

    public int computeMappingCostL() {
        this._species_tree.levelOrderReID();
        this._mapping_cost = 0;
        this.computeMappingCostHelper(this._gene_tree.getRoot());
        return this._mapping_cost;
    }

    public int getDuplicationsSum() {
        return this._duplications_sum;
    }

    public Phylogeny getGeneTree() {
        return this._gene_tree;
    }

    public Phylogeny getSpeciesTree() {
        return this._species_tree;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass());
        stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("Duplications sum                   : " + this.getDuplicationsSum());
        stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("mapping cost L                     : " + this.computeMappingCostL());
        return stringBuffer.toString();
    }

    void geneTreePostOrderTraversal(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.isExternal()) {
            this.geneTreePostOrderTraversal(phylogenyNode.getChildNode(0));
            this.geneTreePostOrderTraversal(phylogenyNode.getChildNode(1));
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(0).getLink();
            PhylogenyNode phylogenyNode3 = phylogenyNode.getChildNode(1).getLink();
            while (phylogenyNode2 != phylogenyNode3) {
                if (phylogenyNode2.getId() > phylogenyNode3.getId()) {
                    phylogenyNode2 = phylogenyNode2.getParent();
                    continue;
                }
                phylogenyNode3 = phylogenyNode3.getParent();
            }
            phylogenyNode.setLink(phylogenyNode2);
            Event event = null;
            if (phylogenyNode2 == phylogenyNode.getChildNode(0).getLink() || phylogenyNode2 == phylogenyNode.getChildNode(1).getLink()) {
                event = Event.createSingleDuplicationEvent();
                ++this._duplications_sum;
            } else {
                event = Event.createSingleSpeciationEvent();
            }
            phylogenyNode.getNodeData().setEvent(event);
        }
    }

    final void linkNodesOfG() throws SDIException {
        String string;
        PhylogenyNode phylogenyNode;
        HashMap<String, PhylogenyNode> hashMap = new HashMap<String, PhylogenyNode>();
        SDIutil.TaxonomyComparisonBase taxonomyComparisonBase = this.determineTaxonomyComparisonBase();
        PhylogenyNodeIterator phylogenyNodeIterator = this._species_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            string = SDIutil.taxonomyToString(phylogenyNode, taxonomyComparisonBase);
            if (hashMap.containsKey(string)) {
                throw new IllegalArgumentException("taxonomy [" + phylogenyNode.getNodeData().getTaxonomy() + "] is not unique in species phylogeny");
            }
            hashMap.put(string, phylogenyNode);
        }
        phylogenyNodeIterator = this._gene_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            string = SDIutil.taxonomyToString(phylogenyNode, taxonomyComparisonBase);
            PhylogenyNode phylogenyNode2 = (PhylogenyNode)hashMap.get(string);
            if (phylogenyNode2 == null) {
                throw new IllegalArgumentException("taxonomy [" + phylogenyNode.getNodeData().getTaxonomy() + "] not present in species tree");
            }
            phylogenyNode.setLink(phylogenyNode2);
        }
    }

    int updateM(boolean bl, PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        PhylogenyNode phylogenyNode3 = this.getGeneTree().getRoot();
        if (phylogenyNode3.getChildNode1() == phylogenyNode || phylogenyNode3.getChildNode2() == phylogenyNode) {
            this.calculateMforNode(phylogenyNode);
        } else {
            this.calculateMforNode(phylogenyNode2);
        }
        Event event = null;
        event = bl ? Event.createSingleDuplicationEvent() : Event.createSingleSpeciationEvent();
        phylogenyNode3.getNodeData().setEvent(event);
        this.calculateMforNode(phylogenyNode3);
        return this.getDuplicationsSum();
    }

    private void calculateMforNode(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.isExternal()) {
            boolean bl = phylogenyNode.isDuplication();
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode1().getLink();
            PhylogenyNode phylogenyNode3 = phylogenyNode.getChildNode2().getLink();
            while (phylogenyNode2 != phylogenyNode3) {
                if (phylogenyNode2.getId() > phylogenyNode3.getId()) {
                    phylogenyNode2 = phylogenyNode2.getParent();
                    continue;
                }
                phylogenyNode3 = phylogenyNode3.getParent();
            }
            phylogenyNode.setLink(phylogenyNode2);
            Event event = null;
            if (phylogenyNode2 == phylogenyNode.getChildNode1().getLink() || phylogenyNode2 == phylogenyNode.getChildNode2().getLink()) {
                event = Event.createSingleDuplicationEvent();
                if (!bl) {
                    ++this._duplications_sum;
                }
            } else {
                event = Event.createSingleSpeciationEvent();
                if (bl) {
                    --this._duplications_sum;
                }
            }
            phylogenyNode.getNodeData().setEvent(event);
        }
    }

    private void computeMappingCostHelper(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.isExternal()) {
            this.computeMappingCostHelper(phylogenyNode.getChildNode1());
            this.computeMappingCostHelper(phylogenyNode.getChildNode2());
            this._mapping_cost = phylogenyNode.getLink() != phylogenyNode.getChildNode1().getLink() && phylogenyNode.getLink() != phylogenyNode.getChildNode2().getLink() ? (int)((long)this._mapping_cost + (phylogenyNode.getChildNode1().getLink().getId() + phylogenyNode.getChildNode2().getLink().getId() - 2L * phylogenyNode.getLink().getId() - 2L)) : (phylogenyNode.getLink() != phylogenyNode.getChildNode1().getLink() && phylogenyNode.getLink() == phylogenyNode.getChildNode2().getLink() ? (int)((long)this._mapping_cost + (phylogenyNode.getChildNode1().getLink().getId() - phylogenyNode.getLink().getId() + 1L)) : (phylogenyNode.getLink() == phylogenyNode.getChildNode1().getLink() && phylogenyNode.getLink() != phylogenyNode.getChildNode2().getLink() ? (int)((long)this._mapping_cost + (phylogenyNode.getChildNode2().getLink().getId() - phylogenyNode.getLink().getId() + 1L)) : ++this._mapping_cost));
        }
    }

    private SDIutil.TaxonomyComparisonBase determineTaxonomyComparisonBase() {
        Taxonomy taxonomy;
        PhylogenyNode phylogenyNode;
        SDIutil.TaxonomyComparisonBase taxonomyComparisonBase = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        PhylogenyNodeIterator phylogenyNodeIterator = this._species_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                taxonomy = phylogenyNode.getNodeData().getTaxonomy();
                if (taxonomy.getIdentifier() == null || ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue())) {
                    bl = false;
                }
                if (ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                    bl2 = false;
                }
                if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) continue;
                bl3 = false;
                continue;
            }
            throw new IllegalArgumentException("species tree node [" + phylogenyNode + "] has no taxonomic data");
        }
        phylogenyNodeIterator = this._gene_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                taxonomy = phylogenyNode.getNodeData().getTaxonomy();
                if (taxonomy.getIdentifier() == null || ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue())) {
                    bl = false;
                }
                if (ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                    bl2 = false;
                }
                if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) continue;
                bl3 = false;
                continue;
            }
            throw new IllegalArgumentException("gene tree node [" + phylogenyNode + "] has no taxonomic data");
        }
        if (bl) {
            taxonomyComparisonBase = SDIutil.TaxonomyComparisonBase.ID;
        } else if (bl2) {
            taxonomyComparisonBase = SDIutil.TaxonomyComparisonBase.CODE;
        } else if (bl3) {
            taxonomyComparisonBase = SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME;
        } else {
            throw new IllegalArgumentException("gene tree and species tree have incomparable taxonomies");
        }
        return taxonomyComparisonBase;
    }

    private final void linkNodesOfGByTaxonomyIdentifier() {
        PhylogenyNode phylogenyNode;
        PhylogenyNodeIterator phylogenyNodeIterator;
        HashMap<String, PhylogenyNode> hashMap = new HashMap<String, PhylogenyNode>();
        if (this._species_tree.getFirstExternalNode().isRoot()) {
            hashMap.put(this._species_tree.getFirstExternalNode().getNodeData().getTaxonomy().getIdentifier().getValue(), this._species_tree.getFirstExternalNode());
        } else {
            phylogenyNodeIterator = this._species_tree.iteratorExternalForward();
            while (phylogenyNodeIterator.hasNext()) {
                phylogenyNode = phylogenyNodeIterator.next();
                hashMap.put(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue(), phylogenyNode);
            }
        }
        phylogenyNodeIterator = this._gene_tree.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            PhylogenyNode phylogenyNode2 = (PhylogenyNode)hashMap.get(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue());
            if (phylogenyNode2 == null) {
                String string = "species [" + phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue();
                string = string + "] not present in species tree";
                throw new IllegalArgumentException(string);
            }
            phylogenyNode.setLink(phylogenyNode2);
        }
    }
}

