/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.protein.BinaryDomainCombination;
import org.forester.species.Species;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.util.ForesterUtil;

public class BasicCombinableDomains
implements CombinableDomains {
    private final TreeMap<String, Integer> _combining_domains;
    private final String _key_domain;
    private int _key_domain_count;
    private final Set<String> _proteins_with_key_domain;
    private final Species _species;

    public BasicCombinableDomains(String string, Species species) {
        this._key_domain = string;
        this._species = species;
        this._combining_domains = new TreeMap();
        this._proteins_with_key_domain = new HashSet<String>();
        this._key_domain_count = 0;
    }

    @Override
    public void addCombinableDomain(String string) {
        if (this.getCombiningDomains().containsKey(string)) {
            this.getCombiningDomains().put(string, this.getCombiningDomains().get(string) + 1);
        } else {
            this.getCombiningDomains().put(string, 1);
        }
    }

    @Override
    public void addKeyDomainProtein(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("attempt to add null or empty protein");
        }
        this.getKeyDomainProteins().add(string);
    }

    @Override
    public List<String> getAllDomains() {
        List<String> list = this.getCombinableDomains();
        if (!list.contains(this.getKeyDomain())) {
            list.add(this.getKeyDomain());
        }
        return list;
    }

    @Override
    public List<String> getCombinableDomains() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getNumberOfCombinableDomains());
        for (String string : this.getCombiningDomains().keySet()) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public SortedMap<String, Integer> getCombinableDomainsIds() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        Iterator<String> iterator = this.getCombiningDomains().keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            treeMap.put(string2, this.getCombiningDomains().get(string2));
        }
        return treeMap;
    }

    @Override
    public StringBuilder getCombiningDomainIdsAsStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.getCombiningDomains().keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append(string.toString());
            stringBuilder.append(" [");
            int n = this.getCombiningDomains().get(string);
            stringBuilder.append(n);
            stringBuilder.append("]");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }

    @Override
    public String getKeyDomain() {
        return this._key_domain;
    }

    @Override
    public int getKeyDomainCount() {
        return this._key_domain_count;
    }

    @Override
    public Set<String> getKeyDomainProteins() {
        return this._proteins_with_key_domain;
    }

    @Override
    public int getKeyDomainProteinsCount() {
        return this.getKeyDomainProteins().size();
    }

    @Override
    public int getNumberOfCombinableDomains() {
        return this._combining_domains.size();
    }

    @Override
    public int getNumberOfProteinsExhibitingCombination(String string) {
        if (this.getCombiningDomains().containsKey(string)) {
            return this.getCombiningDomains().get(string);
        }
        return 0;
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    @Override
    public boolean isCombinable(String string) {
        return this.getCombiningDomains().containsKey(string);
    }

    @Override
    public void setKeyDomainCount(int n) {
        this._key_domain_count = n;
    }

    @Override
    public List<BinaryDomainCombination> toBinaryDomainCombinations() {
        ArrayList<BinaryDomainCombination> arrayList = new ArrayList<BinaryDomainCombination>(this.getNumberOfCombinableDomains());
        for (String string : this.getCombiningDomains().keySet()) {
            arrayList.add(BasicBinaryDomainCombination.obtainInstance(this.getKeyDomain(), string));
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getKeyDomain());
        stringBuilder.append(" [");
        stringBuilder.append(this.getKeyDomainCount());
        stringBuilder.append(", ");
        stringBuilder.append(this.getKeyDomainProteinsCount());
        stringBuilder.append(", ");
        stringBuilder.append(this.getNumberOfCombinableDomains());
        stringBuilder.append("]: ");
        stringBuilder.append((CharSequence)this.getCombiningDomainIdsAsStringBuilder());
        return stringBuilder.toString();
    }

    protected TreeMap<String, Integer> getCombiningDomains() {
        return this._combining_domains;
    }
}

