/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

public class WindowsUtils {
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String DESKTOP_FOLDER_CMD = "reg query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v DESKTOP";

    private WindowsUtils() {
    }

    public static String getCurrentUserDesktopPath() {
        try {
            Process process = Runtime.getRuntime().exec(DESKTOP_FOLDER_CMD);
            StreamReader streamReader = new StreamReader(process.getInputStream());
            streamReader.start();
            process.waitFor();
            streamReader.join();
            String string = streamReader.getResult();
            int n = string.indexOf(REGSTR_TOKEN);
            if (n == -1) {
                return null;
            }
            return string.substring(n + REGSTR_TOKEN.length()).trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class StreamReader
    extends Thread {
        private final InputStream is;
        private final StringWriter sw;

        StreamReader(InputStream inputStream) {
            this.is = inputStream;
            this.sw = new StringWriter();
        }

        String getResult() {
            return this.sw.toString();
        }

        @Override
        public void run() {
            try {
                int n;
                while ((n = this.is.read()) != -1) {
                    this.sw.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

