/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.seqdb;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.BasicGoTerm;
import org.forester.go.GoTerm;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.SequenceDatabaseEntry;
import org.forester.ws.seqdb.SequenceDbWsTools;

public final class UniProtEntry
implements SequenceDatabaseEntry {
    public static final Pattern BindingDB_PATTERN = Pattern.compile("BindingDB;\\s+([0-9A-Z]+);");
    public static final Pattern CTD_PATTERN = Pattern.compile("CTD;\\s+(\\d+);");
    public static final Pattern DrugBank_PATTERN = Pattern.compile("DrugBank;\\s+([0-9A-Z]+);\\s+([^\\.]+)");
    public static final Pattern GO_PATTERN = Pattern.compile("GO;\\s+(GO:\\d+);\\s+([PFC]):([^;]+);");
    public static final Pattern KEGG_PATTERN = Pattern.compile("KEGG;\\s+([a-z]+:[0-9]+);");
    public static final Pattern MIM_PATTERN = Pattern.compile("MIM;\\s+(\\d+);");
    public static final Pattern NextBio_PATTERN = Pattern.compile("NextBio;\\s+(\\d+);");
    public static final Pattern Orphanet_PATTERN = Pattern.compile("Orphanet;\\s+(\\d+);\\s+([^\\.]+)");
    public static final Pattern PDB_PATTERN = Pattern.compile("PDB;\\s+([0-9A-Z]{4});\\s+([^;]+)");
    public static final Pattern PharmGKB_PATTERN = Pattern.compile("PharmGKB;\\s+([0-9A-Z]+);");
    public static final Pattern Reactome_PATTERN = Pattern.compile("Reactome;\\s+([0-9A-Z]+);\\s+([^\\.]+)");
    public static final Pattern HGNC_PATTERN = Pattern.compile("HGNC;\\s+HGNC:(\\d+);");
    public static final Pattern NCBI_TAXID_PATTERN = Pattern.compile("NCBI_TaxID=(\\d+)");
    private String _ac;
    private SortedSet<Accession> _cross_references;
    private String _gene_name;
    private SortedSet<GoTerm> _go_terms;
    private String _name;
    private String _os_scientific_name;
    private String _symbol;
    private String _tax_id;
    private MolecularSequence _mol_seq;

    private UniProtEntry() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public String getAccession() {
        return this._ac;
    }

    @Override
    public SortedSet<Accession> getCrossReferences() {
        return this._cross_references;
    }

    @Override
    public String getGeneName() {
        return this._gene_name;
    }

    @Override
    public SortedSet<GoTerm> getGoTerms() {
        return this._go_terms;
    }

    @Override
    public String getProvider() {
        return "uniprot";
    }

    @Override
    public String getSequenceName() {
        return this._name;
    }

    @Override
    public String getSequenceSymbol() {
        return this._symbol;
    }

    @Override
    public String getTaxonomyIdentifier() {
        return this._tax_id;
    }

    @Override
    public String getTaxonomyScientificName() {
        return this._os_scientific_name;
    }

    @Override
    public boolean isEmpty() {
        return !(!ForesterUtil.isEmpty(this.getAccession()) || !ForesterUtil.isEmpty(this.getSequenceName()) || !ForesterUtil.isEmpty(this.getTaxonomyScientificName()) || !ForesterUtil.isEmpty(this.getSequenceSymbol()) || !ForesterUtil.isEmpty(this.getGeneName()) || !ForesterUtil.isEmpty(this.getTaxonomyIdentifier()) || !ForesterUtil.isEmpty(this.getSequenceSymbol()) || this.getGoTerms() != null && !this.getGoTerms().isEmpty() || this.getCrossReferences() != null && !this.getCrossReferences().isEmpty());
    }

    @Override
    public String getMap() {
        return null;
    }

    @Override
    public String getChromosome() {
        return null;
    }

    @Override
    public MolecularSequence getMolecularSequence() {
        return this._mol_seq;
    }

    private void addCrossReference(Accession accession) {
        if (this._cross_references == null) {
            this._cross_references = new TreeSet<Accession>();
        }
        this._cross_references.add(accession);
    }

    private void addGoTerm(BasicGoTerm basicGoTerm) {
        if (this._go_terms == null) {
            this._go_terms = new TreeSet<GoTerm>();
        }
        this._go_terms.add(basicGoTerm);
    }

    private void setAc(String string) {
        if (this._ac == null) {
            this._ac = string;
        }
    }

    private void setMolecularSequence(MolecularSequence molecularSequence) {
        this._mol_seq = molecularSequence;
    }

    private void setGeneName(String string) {
        if (this._gene_name == null) {
            this._gene_name = string;
        }
    }

    private void setOsScientificName(String string) {
        if (this._os_scientific_name == null) {
            this._os_scientific_name = string;
        }
    }

    private void setSequenceName(String string) {
        if (this._name == null) {
            this._name = string;
        }
    }

    private void setSequenceSymbol(String string) {
        this._symbol = string;
    }

    private void setTaxId(String string) {
        if (this._tax_id == null) {
            this._tax_id = string;
        }
    }

    @Override
    public SortedSet<Annotation> getAnnotations() {
        return null;
    }

    public static final SequenceDatabaseEntry createInstance(List<String> list) {
        UniProtEntry uniProtEntry = new UniProtEntry();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (String string : list) {
            Matcher matcher;
            if (string.startsWith("AC")) {
                uniProtEntry.setAc(SequenceDbWsTools.extractFromTo(string, "AC", ";"));
                continue;
            }
            if (string.startsWith("DE") && ForesterUtil.isEmpty(uniProtEntry.getSequenceName())) {
                if (string.indexOf("RecName:") > 0 && string.indexOf("Full=") > 0) {
                    if (string.indexOf("{") > 0) {
                        uniProtEntry.setSequenceName(SequenceDbWsTools.extractFromTo(string, "Full=", "{"));
                        continue;
                    }
                    uniProtEntry.setSequenceName(SequenceDbWsTools.extractFromTo(string, "Full=", ";"));
                    continue;
                }
                if (string.indexOf("SubName:") <= 0 || string.indexOf("Full=") <= 0) continue;
                if (string.indexOf("{") > 0) {
                    uniProtEntry.setSequenceName(SequenceDbWsTools.extractFromTo(string, "Full=", "{"));
                    continue;
                }
                uniProtEntry.setSequenceName(SequenceDbWsTools.extractFromTo(string, "Full=", ";"));
                continue;
            }
            if (string.startsWith("DE") && ForesterUtil.isEmpty(uniProtEntry.getSequenceSymbol())) {
                if (string.indexOf("Short=") <= 0) continue;
                if (string.indexOf("{") > 0) {
                    uniProtEntry.setSequenceSymbol(SequenceDbWsTools.extractFromTo(string, "Short=", "{"));
                    continue;
                }
                uniProtEntry.setSequenceSymbol(SequenceDbWsTools.extractFromTo(string, "Short=", ";"));
                continue;
            }
            if (string.startsWith("GN") && ForesterUtil.isEmpty(uniProtEntry.getGeneName())) {
                if (string.indexOf("Name=") <= 0) continue;
                if (string.indexOf("{") > 0) {
                    uniProtEntry.setGeneName(SequenceDbWsTools.extractFromTo(string, "Name=", "{"));
                    continue;
                }
                uniProtEntry.setGeneName(SequenceDbWsTools.extractFromTo(string, "Name=", ";"));
                continue;
            }
            if (string.startsWith("DR")) {
                if (string.indexOf("GO;") > 0) {
                    matcher = GO_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    String string4 = matcher.group(3);
                    String string5 = "biological_process";
                    if (string3.equals("F")) {
                        string5 = "molecular_function";
                    } else if (string3.equals("C")) {
                        string5 = "cellular_component";
                    }
                    uniProtEntry.addGoTerm(new BasicGoTerm(string2, string4, string5, false));
                    continue;
                }
                if (string.indexOf("PDB;") > 0) {
                    matcher = PDB_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "PDB", matcher.group(2)));
                    continue;
                }
                if (string.indexOf("KEGG;") > 0) {
                    matcher = KEGG_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "KEGG"));
                    continue;
                }
                if (string.indexOf("CTD;") > 0) {
                    matcher = CTD_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "CTD"));
                    continue;
                }
                if (string.indexOf("MIM;") > 0) {
                    matcher = MIM_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "MIM"));
                    continue;
                }
                if (string.indexOf("Orphanet;") > 0) {
                    matcher = Orphanet_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "Orphanet", matcher.group(2)));
                    continue;
                }
                if (string.indexOf("PharmGKB;") > 0) {
                    matcher = PharmGKB_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "PharmGKB"));
                    continue;
                }
                if (string.indexOf("BindingDB;") > 0) {
                    matcher = BindingDB_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "BindingDB"));
                    continue;
                }
                if (string.indexOf("DrugBank;") > 0) {
                    matcher = DrugBank_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "DrugBank", matcher.group(2)));
                    continue;
                }
                if (string.indexOf("NextBio;") > 0) {
                    matcher = NextBio_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "NextBio"));
                    continue;
                }
                if (string.indexOf("Reactome;") > 0) {
                    matcher = Reactome_PATTERN.matcher(string);
                    if (!matcher.find()) continue;
                    uniProtEntry.addCrossReference(new Accession(matcher.group(1), "Reactome", matcher.group(2)));
                    continue;
                }
                if (string.indexOf("HGNC;") <= 0 || !(matcher = HGNC_PATTERN.matcher(string)).find()) continue;
                uniProtEntry.addCrossReference(new Accession(matcher.group(1), "HGNC"));
                continue;
            }
            if (string.startsWith("OS")) {
                if (string.indexOf("(") > 0) {
                    uniProtEntry.setOsScientificName(SequenceDbWsTools.extractFromTo(string, "OS", "("));
                    continue;
                }
                uniProtEntry.setOsScientificName(SequenceDbWsTools.extractFromTo(string, "OS", "."));
                continue;
            }
            if (string.startsWith("OX")) {
                if (string.indexOf("NCBI_TaxID=") <= 0 || !(matcher = NCBI_TAXID_PATTERN.matcher(string)).find()) continue;
                uniProtEntry.setTaxId(matcher.group(1));
                continue;
            }
            if (string.startsWith("SQ")) {
                bl = true;
                if (!string.contains("AA;")) continue;
                bl2 = true;
                continue;
            }
            if (!bl || !string.startsWith(" ")) continue;
            stringBuffer.append(string.replaceAll("\\s+", ""));
        }
        if (stringBuffer.length() > 0) {
            if (bl2) {
                uniProtEntry.setMolecularSequence(BasicSequence.createAaSequence(uniProtEntry.getAccession(), stringBuffer.toString()));
            } else {
                uniProtEntry.setMolecularSequence(BasicSequence.createDnaSequence(uniProtEntry.getAccession(), stringBuffer.toString()));
            }
        }
        return uniProtEntry;
    }
}

