/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

final class Calcoo
implements CommandListener {
    private final Body body;
    private Cpu cpu;
    private final LinkedList<Cpu> undoStack;
    private final LinkedList<Cpu> redoStack;

    Calcoo() {
        Settings settings = Settings.load(10);
        this.cpu = new Cpu(settings.mode, Settings.loadAngleUnits(), 10, 2, 10, 2, settings.enterMode, settings.stackMode);
        this.undoStack = new LinkedList();
        this.redoStack = new LinkedList();
        this.body = new Body(this, 10, 2, 10);
        this.body.setArcAutorelease(settings.arcAutorelease);
        this.body.setHypAutorelease(settings.hypAutorelease);
        this.body.setRound(settings.round);
        this.body.setRoundLength(settings.roundLength);
        this.body.setTruncateZeros(settings.truncateZeros);
        this.body.displayOnlyActiveButtonsForMode(settings.mode);
        this.body.buttons.get((Object)Command.UNDO).setEnabled(false);
        this.body.buttons.get((Object)Command.REDO).setEnabled(false);
        this.body.setDisplayFormat(Settings.loadDisplayFormat());
        this.body.setPasteParsingAlgorithm(settings.pasteParsingAlgorithm);
        this.body.setCustomButtonCommand(settings.customButtonCommand);
        this.body.refresh(this.cpu);
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                throwable.printStackTrace();
            }
        });
    }

    @Override
    public synchronized void processCommand(Command command) {
        if ((command == Command.STACK_DOWN || command == Command.STACK_UP) && this.cpu.getMode() == Settings.Mode.ALG) {
            return;
        }
        if ((command == Command.LEFT_PAREN || command == Command.RIGHT_PAREN) && this.cpu.getMode() == Settings.Mode.RPN) {
            return;
        }
        switch (command) {
            case ARC: 
            case HYP: {
                break;
            }
            case INFO: {
                InfoDialog infoDialog = new InfoDialog();
                infoDialog.run(this.body.frame);
                break;
            }
            case SETTINGS: {
                Settings settings = new Settings(this.cpu.getStackMode(), this.cpu.getMode(), this.cpu.getEnterMode(), this.body.isRound(), this.body.getRoundLength(), this.body.isTruncateZeros(), this.body.isArcAutorelease(), this.body.isHypAutorelease(), this.body.getPasteParsingAlgorithm(), this.body.getCustomButtonCommand());
                SettingsDialog settingsDialog = new SettingsDialog();
                if (!settingsDialog.run(settings, this.body.frame, 10)) break;
                if (settings.enterMode != this.cpu.getEnterMode()) {
                    this.cpu.setEnterMode(settings.enterMode);
                }
                if (settings.stackMode != this.cpu.getStackMode()) {
                    this.cpu.setStackMode(settings.stackMode);
                }
                if (settings.mode != this.cpu.getMode()) {
                    this.cpu.setMode(settings.mode);
                    this.body.displayOnlyActiveButtonsForMode(settings.mode);
                }
                this.body.setRound(settings.round);
                this.body.setRoundLength(settings.roundLength);
                this.body.setTruncateZeros(settings.truncateZeros);
                this.body.setArcAutorelease(settings.arcAutorelease);
                this.body.setHypAutorelease(settings.hypAutorelease);
                this.body.setCustomButtonCommand(settings.customButtonCommand);
                settings.save();
                break;
            }
            case COPY: {
                JTextField jTextField = new JTextField(this.body.getMainDisplayString());
                jTextField.selectAll();
                jTextField.copy();
                break;
            }
            case PASTE: {
                JTextField jTextField = new JTextField();
                jTextField.paste();
                Double d = TextUtil.textToDouble(jTextField.getText(), this.body.getPasteParsingAlgorithm() == Settings.PasteParsingAlgorithm.LOCALE_BASED);
                if (Double.isNaN(d)) break;
                this.redoStack.clear();
                this.undoStack.push(this.cpu.clone());
                this.body.buttons.get((Object)Command.UNDO).setEnabled(true);
                this.body.buttons.get((Object)Command.REDO).setEnabled(false);
                if (this.undoStack.size() > 200) {
                    this.undoStack.removeLast();
                }
                this.cpu.executePaste(d);
                break;
            }
            case EXIT: {
                this.body.close();
                break;
            }
            case FORMAT: {
                this.body.switchDisplayFormat();
                Settings.saveDisplayFormat(this.body.getDisplayFormat());
                break;
            }
            case UNDO: {
                if (this.undoStack.isEmpty()) break;
                this.redoStack.push(this.cpu);
                this.cpu = this.undoStack.pop();
                this.body.buttons.get((Object)Command.REDO).setEnabled(true);
                if (!this.undoStack.isEmpty()) break;
                this.body.buttons.get((Object)Command.UNDO).setEnabled(false);
                break;
            }
            case REDO: {
                if (this.redoStack.isEmpty()) break;
                this.undoStack.push(this.cpu);
                this.cpu = this.redoStack.pop();
                this.body.buttons.get((Object)Command.UNDO).setEnabled(true);
                if (!this.redoStack.isEmpty()) break;
                this.body.buttons.get((Object)Command.REDO).setEnabled(false);
                break;
            }
            case CUSTOM: {
                String[] stringArray = this.body.getCustomButtonCommandAsArray();
                if (stringArray.length == 0) break;
                this.redoStack.clear();
                this.undoStack.push(this.cpu.clone());
                this.body.buttons.get((Object)Command.UNDO).setEnabled(true);
                this.body.buttons.get((Object)Command.REDO).setEnabled(false);
                for (int i = 0; i < stringArray.length; ++i) {
                    Command command2 = Command.valueOf(stringArray[i]);
                    if (!Command.isValidButton(command2, this.cpu.getMode())) continue;
                    this.cpu.execute(command2);
                }
                this.body.refresh(this.cpu);
                break;
            }
            default: {
                this.redoStack.clear();
                this.undoStack.push(this.cpu.clone());
                this.body.buttons.get((Object)Command.UNDO).setEnabled(true);
                this.body.buttons.get((Object)Command.REDO).setEnabled(false);
                if (this.undoStack.size() > 200) {
                    this.undoStack.removeLast();
                }
                if (Command.trigAll.contains((Object)command)) {
                    if (Command.trigBare.contains((Object)command)) {
                        Command command3 = Command.trigBareToDressed(command, this.body.buttons.get((Object)Command.ARC).isSelected(), this.body.buttons.get((Object)Command.HYP).isSelected());
                        this.cpu.execute(command3);
                    } else {
                        this.cpu.execute(command);
                    }
                    if (this.body.isArcAutorelease()) {
                        this.body.buttons.get((Object)Command.ARC).setSelected(false);
                    }
                    if (this.body.isHypAutorelease()) {
                        this.body.buttons.get((Object)Command.HYP).setSelected(false);
                    }
                } else if (command == Command.ENTER && this.cpu.getMode() == Settings.Mode.ALG) {
                    this.cpu.execute(Command.EQ);
                } else {
                    this.cpu.execute(command);
                }
                if (command != Command.DEG_RAD) break;
                Settings.saveAngleUnits(this.cpu.getAngleUnits());
            }
        }
        this.body.refresh(this.cpu);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Calcoo();
            }
        });
    }

    private final class Fundamentals {
        public static final int EXP_INPUT_LENGTH = 2;
        public static final int BASE = 10;
        public static final int N_MEM = 2;
        public static final int INPUT_LENGTH = 10;
        public static final int UNDO_STACK_SIZE = 200;

        private Fundamentals() {
            throw new AssertionError((Object)"Fundamentals is a utility class.");
        }
    }
}

