/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import java.util.ListIterator;

public final class CpuStack
implements Cloneable,
CpuStackGetters {
    private Settings.StackMode stackMode;
    private Settings.Mode mode;
    private LinkedList<StackElement> stack;

    private CpuStack() {
        throw new AssertionError((Object)"Instantiating CpuStack without specifying the mode - RPN or Alg");
    }

    CpuStack(Settings.Mode mode) {
        if (mode != Settings.Mode.ALG) {
            throw new RuntimeException("stack mode must be specified in non-ALG mode stack construction " + mode.toString());
        }
        this.stack = new LinkedList();
        this.mode = mode;
    }

    CpuStack(Settings.Mode mode, Settings.StackMode stackMode) {
        this.stack = new LinkedList();
        this.mode = mode;
        this.stackMode = stackMode;
    }

    public CpuStack clone() {
        CpuStack cpuStack = new CpuStack(this.mode, this.stackMode);
        ListIterator listIterator = this.stack.listIterator();
        while (listIterator.hasNext()) {
            cpuStack.stack.addLast(((StackElement)listIterator.next()).clone());
        }
        return cpuStack;
    }

    Settings.StackMode getStackMode() {
        return this.stackMode;
    }

    void setStackMode(Settings.StackMode stackMode) {
        this.stackMode = stackMode;
    }

    public void push(double d, Cpu.BinaryOp binaryOp) {
        if (this.mode != Settings.Mode.ALG) {
            throw new RuntimeException("ALG stack push called in non-ALG mode " + this.mode.toString());
        }
        this.stack.push(new StackElement(d, binaryOp, 0));
    }

    public void push(double d) {
        if (this.mode != Settings.Mode.RPN) {
            throw new RuntimeException("RPN stack push called in non-RPN mode");
        }
        this.stack.addFirst(new StackElement(d));
        if (this.stackMode == Settings.StackMode.XYZT && this.stack.size() > 3) {
            this.stack.removeLast();
        }
    }

    public double pop() {
        return this.stack.isEmpty() ? 0.0 : this.stack.removeFirst().z;
    }

    public void clear() {
        this.stack.clear();
    }

    public boolean existOpenParen() {
        if (this.mode != Settings.Mode.ALG) {
            throw new RuntimeException("ALG stack existOpenParen called in non-ALG mode");
        }
        for (StackElement stackElement : this.stack) {
            if (stackElement.numberOfParens <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public Cpu.BinaryOp getOp() {
        if (this.mode != Settings.Mode.ALG) {
            throw new RuntimeException("ALG stack getOp called in non-ALG mode");
        }
        return this.stack.peekFirst().op;
    }

    @Override
    public double peekValue(int n) {
        if (n < 0) {
            throw new RuntimeException("trying to peek value at negative depth " + n);
        }
        if (this.stack.size() > n) {
            return this.stack.get((int)n).z;
        }
        return 0.0;
    }

    @Override
    public Cpu.BinaryOp peekOp(int n) {
        if (n < 0) {
            throw new RuntimeException("trying to peek op at negative depth " + n);
        }
        if (this.stack.size() > n && this.mode == Settings.Mode.ALG) {
            return this.stack.get((int)n).op;
        }
        return null;
    }

    @Override
    public boolean peekParenExists(int n) {
        if (n < 0) {
            throw new RuntimeException("trying to peek paren at negative depth " + n);
        }
        if (this.stack.size() > n && this.mode == Settings.Mode.ALG) {
            return this.stack.get((int)n).numberOfParens > 0;
        }
        return false;
    }

    double getValue() {
        return this.stack.peekFirst().z;
    }

    boolean headParenExists() {
        if (this.mode != Settings.Mode.ALG) {
            throw new RuntimeException("ALG stack headParenExists called in non-ALG mode");
        }
        return this.stack.peekFirst().numberOfParens > 0;
    }

    void headParenAdd() {
        if (this.mode != Settings.Mode.ALG) {
            throw new RuntimeException("ALG stack headParenAdd called in non-ALG mode");
        }
        ++this.stack.peekFirst().numberOfParens;
    }

    void headParenRemove() {
        if (this.mode != Settings.Mode.ALG) {
            throw new RuntimeException("ALG stack headParenRemove called in non-ALG mode");
        }
        if (this.stack.peek().numberOfParens == 0) {
            throw new RuntimeException("headParenRemove when none exist");
        }
        --this.stack.peekFirst().numberOfParens;
    }

    double rollUp(double d) {
        switch (this.mode) {
            case ALG: {
                throw new RuntimeException("stack rollUp called in ALG mode");
            }
            case RPN: {
                switch (this.stackMode) {
                    case INFINITE: {
                        if (this.stack.isEmpty()) {
                            return d;
                        }
                        this.push(d);
                        return this.stack.removeLast().z;
                    }
                    case XYZT: {
                        double d2 = this.pop();
                        double d3 = this.pop();
                        double d4 = this.pop();
                        this.push(d3);
                        this.push(d2);
                        this.push(d);
                        return d4;
                    }
                }
                throw new RuntimeException("unknown stack mode " + this.stackMode.toString());
            }
        }
        throw new RuntimeException("unknown cpu mode " + this.mode.toString());
    }

    double rollDown(double d) {
        switch (this.mode) {
            case ALG: {
                throw new RuntimeException("stack rollDown called in ALG mode");
            }
            case RPN: {
                switch (this.stackMode) {
                    case INFINITE: {
                        if (this.stack.isEmpty()) {
                            return d;
                        }
                        this.stack.addLast(new StackElement(d));
                        return this.pop();
                    }
                    case XYZT: {
                        double d2 = this.pop();
                        double d3 = this.pop();
                        double d4 = this.pop();
                        this.push(d);
                        this.push(d4);
                        this.push(d3);
                        return d2;
                    }
                }
                throw new RuntimeException("unknown stack mode " + this.stackMode.toString());
            }
        }
        throw new RuntimeException("unknown cpu mode " + this.mode.toString());
    }

    double swapHeadValue(double d) {
        switch (this.mode) {
            case RPN: {
                double d2 = this.pop();
                this.push(d);
                return d2;
            }
            case ALG: {
                if (this.stack.isEmpty()) {
                    return d;
                }
                double d3 = this.stack.peekFirst().z;
                this.stack.peek().z = d;
                return d3;
            }
        }
        throw new RuntimeException("unknown cpu mode " + this.mode.toString());
    }

    private class StackElement
    implements Cloneable {
        double z;
        Cpu.BinaryOp op;
        int numberOfParens;

        private StackElement() {
            throw new AssertionError((Object)"Instantiating empty StackElement");
        }

        StackElement(double d, Cpu.BinaryOp binaryOp, int n) {
            this.z = d;
            this.op = binaryOp;
            this.numberOfParens = n;
        }

        StackElement(double d) {
            this.z = d;
        }

        public StackElement clone() {
            return new StackElement(this.z, this.op, this.numberOfParens);
        }
    }
}

