/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.mov;

import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.instructions.mov.Mov;

public class MovBitCy
extends Mov {
    public MovBitCy() {
        this.mneumonic = "MOV bit,C";
        this.size = 2;
        this.isByteInstruction = false;
        this.cycles = 2;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        int carry = ram.getBit(215);
        if (carry == 1) {
            ram.setBit(this.operand0);
        } else {
            ram.clearBit(this.operand0);
        }
        return this.incrementPc(pc);
    }

    @Override
    public void extractOperand0String(String line) throws Exception {
        line = line.replaceFirst("MOV ", "");
        line = line.replaceFirst(",C", "").trim();
        this.setOperand0String(line);
    }

    @Override
    public String toString() {
        return "MOV " + Text.inHex(this.operand0, false) + "H,C";
    }

    @Override
    public int getOpcode() {
        return 146;
    }
}

