/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.orl;

import edsim51sh.Memory;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.orl.OrlAaddress;
import edsim51sh.instructions.orl.OrlAatReg;
import edsim51sh.instructions.orl.OrlAdata;
import edsim51sh.instructions.orl.OrlAddressA;
import edsim51sh.instructions.orl.OrlAddressData;
import edsim51sh.instructions.orl.OrlAreg;
import edsim51sh.instructions.orl.OrlCyBit;
import edsim51sh.instructions.orl.OrlCyNotBit;

public class Orl
extends Instruction {
    public Orl() {
        this.mneumonic = "ORL";
    }

    @Override
    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("ORL A,")) {
            int registerNumber;
            if (mneumonic.startsWith("ORL A,#")) {
                return new OrlAdata();
            }
            if (mneumonic.length() == 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("ORL A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new OrlAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("ORL A,@R0") || mneumonic.equals("ORL A,@R1")) {
                    return new OrlAatReg(registerNumber);
                }
            }
            return new OrlAaddress();
        }
        if (mneumonic.startsWith("ORL C,/")) {
            return new OrlCyNotBit();
        }
        if (mneumonic.startsWith("ORL C,")) {
            return new OrlCyBit();
        }
        if (mneumonic.endsWith(",A")) {
            return new OrlAddressA();
        }
        int hashIndex = mneumonic.indexOf(35);
        int commaIndex = mneumonic.indexOf(44);
        if (hashIndex > 5 && commaIndex > 4) {
            return new OrlAddressData();
        }
        return null;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        return 0;
    }

    @Override
    public int getOpcode() {
        return -1;
    }
}

