/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JPanel;

class MotorAnimation
extends JPanel {
    public static final int STOPPED = 0;
    public static final int ANTICLOCKWISE = 1;
    public static final int CLOCKWISE = -1;
    private boolean small;
    private int radius;
    private int panelSizeSmall = 50;
    private int panelSizeLarge = 75;
    private int panelSize;
    private int sensorLenghSmall = 9;
    private int sensorLenghLarge = 13;
    private int sensorLength;
    private int centerX;
    private int centerY;
    private int angle = 90;
    private int rotating = 0;
    private Color directionIndictorColor = new Color(153, 153, 255);
    private Font[] fonts = new Font[]{new Font("Arial", 1, 15), new Font("Arial", 1, 14), new Font("Arial", 1, 20), new Font("Arial", 1, 19)};

    MotorAnimation() {
    }

    void setSize(boolean small) {
        if (small) {
            this.panelSize = this.panelSizeSmall;
            this.sensorLength = this.sensorLenghSmall;
        } else {
            this.panelSize = this.panelSizeLarge;
            this.sensorLength = this.sensorLenghLarge;
        }
        this.small = small;
        this.radius = this.panelSize / 2 - 7;
        this.setMaximumSize(new Dimension(this.panelSize, this.panelSize));
        this.setMinimumSize(new Dimension(this.panelSize, this.panelSize));
        this.setPreferredSize(new Dimension(this.panelSize, this.panelSize));
    }

    void setRotating(int rotating) {
        this.rotating = rotating;
    }

    void setAngle(int angle) {
        this.angle = angle;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int directionIndicatorOuterRadius = (int)((double)this.radius * 0.8);
        int directionIndicatorInnerRadius = (int)((double)this.radius * 0.7);
        this.centerX = this.panelSize / 2;
        this.centerY = this.panelSize / 2 + 5;
        g.setColor(this.directionIndictorColor);
        int fontOffset = 0;
        if (!this.small) {
            fontOffset = 2;
        }
        if (this.rotating != 0) {
            g.setFont(this.fonts[0 + fontOffset]);
            if (this.rotating == 1) {
                g.drawString(">", this.centerX, this.centerY + (int)((double)directionIndicatorOuterRadius * 1.25));
            } else if (this.rotating == -1) {
                g.drawString(">", this.centerX, this.centerY - (int)((double)directionIndicatorOuterRadius * 0.55));
            }
            g.setFont(this.fonts[1 + fontOffset]);
            if (this.rotating == 1) {
                g.drawString(">", this.centerX, this.centerY + (int)((double)directionIndicatorOuterRadius * 1.25));
            } else if (this.rotating == -1) {
                g.drawString(">", this.centerX, this.centerY - (int)((double)directionIndicatorOuterRadius * 0.55));
            }
            g.fillArc(this.centerX - directionIndicatorOuterRadius, this.centerY - directionIndicatorOuterRadius, directionIndicatorOuterRadius * 2, directionIndicatorOuterRadius * 2, 0, 280 * this.rotating);
            g.setColor(Color.WHITE);
            g.fillArc(this.centerX - directionIndicatorInnerRadius, this.centerY - directionIndicatorInnerRadius, directionIndicatorInnerRadius * 2, directionIndicatorInnerRadius * 2, 0, 280 * this.rotating);
            g.setColor(this.directionIndictorColor);
        }
        g.setColor(Color.BLACK);
        g.drawOval(this.centerX - this.radius, this.centerY - this.radius, this.radius * 2, this.radius * 2);
        Point p = this.getShaftPosition(this.radius, this.angle);
        g.drawLine(this.centerX, this.centerY, p.x, p.y);
        if (this.angle == 0) {
            g.setColor(Color.RED);
        }
        g.drawLine(this.centerX, 0, this.centerX, this.sensorLength);
    }

    private Point getShaftPosition(int shaftLength, double degrees) {
        double y = (double)shaftLength * Math.cos(Math.toRadians(degrees));
        double x = (double)shaftLength * Math.sin(Math.toRadians(degrees));
        return new Point(this.centerX + (int)x, this.centerY - (int)y);
    }
}

