/*
 * Decompiled with CFR 0.152.
 */
package edsim51di.logicdiagram;

import edsim51di.Peripheral;
import edsim51di.logicdiagram.Coordinate;
import edsim51di.logicdiagram.Dots;
import edsim51di.logicdiagram.LogicDiagramFrame;
import edsim51di.logicdiagram.LogicDiagramGraphics;
import edsim51di.logicdiagram.LogicDiagramInterface;
import edsim51di.logicdiagram.Path;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class LogicDiagram {
    private static final int PORT_PIN_STEP = 15;
    private static final int HORIZONTAL_STEP = 6;
    private static final int VERTICAL_STEP = 20;
    private static final int FIRST_TOP = 278;
    private static final int FIRST_BOTTOM = 577;
    private BufferedImage logicDiagramImageLeft;
    private BufferedImage logicDiagramImageCentre;
    private BufferedImage logicDiagramImageRight;
    private int[] portsBaseY = new int[]{401, 536, 536, 401};
    private ArrayList allPaths = new ArrayList();
    private Dots dots = new Dots();
    private int numberOfTopPathsUsed = 0;
    private int numberOfLeftPathsUsed = 0;
    private int numberOfBottomPathsUsed = 0;
    private int numberOfRightPathsUsed = 0;
    private int centreImageOffset;
    private int rightImageOffset;
    private LogicDiagramFrame logicDiagramFrame;
    private Peripheral[] peripherals;
    private LogicDiagramGraphics graphics;

    public LogicDiagram(Peripheral[] peripherals) {
        this.peripherals = peripherals;
        try {
            URL imageURL = this.getClass().getClassLoader().getResource("edsim51di/logicdiagram/logicDiagramLeft.bmp");
            this.logicDiagramImageLeft = ImageIO.read(imageURL);
            imageURL = this.getClass().getClassLoader().getResource("edsim51di/logicdiagram/logicDiagramCentre.bmp");
            this.logicDiagramImageCentre = ImageIO.read(imageURL);
            imageURL = this.getClass().getClassLoader().getResource("edsim51di/logicdiagram/logicDiagramRight.bmp");
            this.logicDiagramImageRight = ImageIO.read(imageURL);
        }
        catch (Exception imageURL) {
            // empty catch block
        }
        for (int i = 0; i < peripherals.length; ++i) {
            this.allPaths.add(this.generateRelativePaths(peripherals[i], i));
        }
        this.generateAbsolutePaths();
        this.fixDots();
        this.graphics = new LogicDiagramGraphics(this.logicDiagramImageLeft, this.logicDiagramImageCentre, this.logicDiagramImageRight, this.centreImageOffset, this.rightImageOffset, this.allPaths, this.dots);
        this.logicDiagramFrame = new LogicDiagramFrame(this);
        this.logicDiagramFrame.setVisible(true);
    }

    public void show() {
        this.logicDiagramFrame.setVisible(true);
    }

    Peripheral[] getPeripherals() {
        return this.peripherals;
    }

    LogicDiagramGraphics getGraphics() {
        return this.graphics;
    }

    void refresh() {
        this.graphics.repaint();
    }

    void enable(boolean b, int id) {
        this.graphics.enable(b, id);
    }

    void enableAll(boolean b) {
        this.graphics.enableAll(b);
    }

    private void fixDots() {
        for (int port = 0; port <= 3; ++port) {
            for (int pin = 0; pin <= 7; ++pin) {
                int offset = port < 2 ? this.centreImageOffset : this.rightImageOffset;
                this.dots.fixDots(port, pin, offset, 6);
            }
        }
    }

    private void generateAbsolutePaths() {
        this.centreImageOffset = this.numberOfLeftPathsUsed * 6 + this.logicDiagramImageLeft.getWidth() + 5;
        this.rightImageOffset = this.numberOfRightPathsUsed * 6 + this.centreImageOffset + this.logicDiagramImageCentre.getWidth() + 5;
        for (int i = 0; i < this.allPaths.size(); ++i) {
            Path[] paths = (Path[])this.allPaths.get(i);
            for (int j = 0; j < paths.length; ++j) {
                Coordinate coordinate = paths[j].get(1);
                int index = 2;
                while (coordinate != null) {
                    if (coordinate.type == 6) {
                        coordinate.value = 577 + coordinate.value * 20;
                    } else if (coordinate.type == 4) {
                        coordinate.value = 278 - coordinate.value * 20;
                    } else if (coordinate.type == 5) {
                        coordinate.value = this.centreImageOffset - coordinate.value * 6;
                    } else if (coordinate.type == 7) {
                        coordinate.value = this.rightImageOffset - coordinate.value * 6;
                    }
                    coordinate = paths[j].get(index);
                    ++index;
                }
            }
        }
    }

    private Path[] generateRelativePaths(Peripheral peripheral, int id) {
        LogicDiagramInterface[] interfaces = peripheral.getLogicDiagramInterfaces();
        Path[] paths = new Path[interfaces.length];
        int peripheralLeftOrRight = peripheral.isOnLogicDiagramLeft() ? 1 : 0;
        for (int i = 0; i < interfaces.length; ++i) {
            int portLeftOrRight;
            paths[i] = new Path(id);
            paths[i].add(peripheralLeftOrRight, interfaces[i].peripheralPin);
            if (peripheral.isOnLogicDiagramLeft()) {
                if (interfaces[i].portNumber < 2) {
                    ++this.numberOfLeftPathsUsed;
                    paths[i].add(5, this.numberOfLeftPathsUsed);
                } else {
                    if (this.isInLineWith8051Symbol(interfaces[i].peripheralPin)) {
                        ++this.numberOfLeftPathsUsed;
                        paths[i].add(5, this.numberOfLeftPathsUsed);
                        if (this.isInTopHalf(interfaces[i].peripheralPin)) {
                            ++this.numberOfTopPathsUsed;
                            paths[i].add(4, this.numberOfTopPathsUsed);
                        } else {
                            ++this.numberOfBottomPathsUsed;
                            paths[i].add(6, this.numberOfBottomPathsUsed);
                        }
                    }
                    ++this.numberOfRightPathsUsed;
                    paths[i].add(7, this.numberOfRightPathsUsed);
                }
            } else if (interfaces[i].portNumber > 1) {
                ++this.numberOfRightPathsUsed;
                paths[i].add(7, this.numberOfRightPathsUsed);
            } else {
                if (this.isInLineWith8051Symbol(interfaces[i].peripheralPin)) {
                    ++this.numberOfRightPathsUsed;
                    paths[i].add(7, this.numberOfRightPathsUsed);
                    if (this.isInTopHalf(interfaces[i].peripheralPin)) {
                        ++this.numberOfTopPathsUsed;
                        paths[i].add(4, this.numberOfTopPathsUsed);
                    } else {
                        ++this.numberOfBottomPathsUsed;
                        paths[i].add(6, this.numberOfBottomPathsUsed);
                    }
                }
                ++this.numberOfLeftPathsUsed;
                paths[i].add(5, this.numberOfLeftPathsUsed);
            }
            int y = this.portsBaseY[interfaces[i].portNumber] - interfaces[i].pinNumber * 15;
            if (interfaces[i].portNumber > 1) {
                portLeftOrRight = 2;
                this.dots.addDot(id, interfaces[i].portNumber, interfaces[i].pinNumber, this.numberOfRightPathsUsed, y);
            } else {
                portLeftOrRight = 3;
                this.dots.addDot(id, interfaces[i].portNumber, interfaces[i].pinNumber, this.numberOfLeftPathsUsed, y);
            }
            paths[i].add(portLeftOrRight, y);
        }
        return paths;
    }

    private boolean isInLineWith8051Symbol(int y) {
        return y > 283 && y < 572;
    }

    private boolean isInTopHalf(int y) {
        return y < this.portsBaseY[0] + 10;
    }
}

