/*
 * Decompiled with CFR 0.152.
 */
package edsim51di.logicdiagram;

import edsim51di.Gui;
import edsim51di.logicdiagram.Coordinate;
import edsim51di.logicdiagram.Dots;
import edsim51di.logicdiagram.LineSegment;
import edsim51di.logicdiagram.Path;
import edsim51di.logicdiagram.Point;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;

class LogicDiagramGraphics
extends JPanel {
    private BufferedImage logicDiagramImageLeft;
    private BufferedImage logicDiagramImageCentre;
    private BufferedImage logicDiagramImageRight;
    private int leftPortPinsX;
    private int rightPortPinsX;
    private int leftPeripheralsX;
    private int rightPeripheralsX;
    private ArrayList lineSegments = new ArrayList();
    private Dots dots;

    LogicDiagramGraphics(BufferedImage logicDiagramImageLeft, BufferedImage logicDiagramImageCentre, BufferedImage logicDiagramImageRight, int leftPortPinsX, int rightPeripheralsX, ArrayList allPaths, Dots dots) {
        this.logicDiagramImageLeft = logicDiagramImageLeft;
        this.logicDiagramImageCentre = logicDiagramImageCentre;
        this.logicDiagramImageRight = logicDiagramImageRight;
        this.leftPortPinsX = leftPortPinsX;
        this.rightPortPinsX = leftPortPinsX + logicDiagramImageCentre.getWidth();
        this.leftPeripheralsX = logicDiagramImageLeft.getWidth();
        this.rightPeripheralsX = rightPeripheralsX;
        this.dots = dots;
        this.generateLineSegments(allPaths);
        this.setBackground(Color.WHITE);
        Gui.setSize(this, new Dimension(rightPeripheralsX + logicDiagramImageRight.getWidth() + 20, logicDiagramImageRight.getHeight()));
    }

    @Override
    public void paintComponent(Graphics g) {
        int x;
        int y;
        super.paintComponent(g);
        for (y = 0; y < this.logicDiagramImageLeft.getHeight(); ++y) {
            for (x = 0; x < this.logicDiagramImageLeft.getWidth(); ++x) {
                if (this.logicDiagramImageLeft.getRGB(x, y) != Color.BLACK.getRGB()) continue;
                g.fillRect(x, y, 1, 1);
            }
        }
        for (y = 0; y < this.logicDiagramImageCentre.getHeight(); ++y) {
            for (x = 0; x < this.logicDiagramImageCentre.getWidth(); ++x) {
                if (this.logicDiagramImageCentre.getRGB(x, y) != Color.BLACK.getRGB()) continue;
                g.fillRect(x + this.leftPortPinsX, y, 1, 1);
            }
        }
        for (y = 0; y < this.logicDiagramImageRight.getHeight(); ++y) {
            for (x = 0; x < this.logicDiagramImageRight.getWidth(); ++x) {
                if (this.logicDiagramImageRight.getRGB(x, y) != Color.BLACK.getRGB()) continue;
                g.fillRect(x + this.rightPeripheralsX, y, 1, 1);
            }
        }
        this.drawLineSegments(false, g);
        this.drawLineSegments(true, g);
        this.drawDots(false, g);
        this.drawDots(true, g);
    }

    void enable(boolean b, int id) {
        for (int i = 0; i < this.lineSegments.size(); ++i) {
            LineSegment lineSegment = (LineSegment)this.lineSegments.get(i);
            lineSegment.enable(b, id);
        }
        this.dots.enableDots(b, id);
    }

    void enableAll(boolean b) {
        for (int i = 0; i < this.lineSegments.size(); ++i) {
            LineSegment lineSegment = (LineSegment)this.lineSegments.get(i);
            lineSegment.enable(b);
        }
        this.dots.enableDots(b);
    }

    private void drawLineSegments(boolean enabled, Graphics g) {
        if (enabled) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        for (int i = 0; i < this.lineSegments.size(); ++i) {
            LineSegment lineSegment = (LineSegment)this.lineSegments.get(i);
            if (lineSegment.isEnabled() != enabled) continue;
            Point point1 = lineSegment.getPoint(0);
            for (int j = 1; j < lineSegment.getSize(); ++j) {
                Point point2 = lineSegment.getPoint(j);
                g.drawLine(point1.x, point1.y, point2.x, point2.y);
                point1 = point2;
            }
        }
    }

    private void drawDots(boolean enabled, Graphics g) {
        if (enabled) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        for (int pin = 0; pin < 32; ++pin) {
            int end;
            int start;
            int numberOfDots = this.dots.getNumberOfDots(pin);
            if (pin < 16) {
                start = 0;
                end = numberOfDots - 1;
            } else {
                start = 1;
                end = numberOfDots;
            }
            for (int i = start; i < end; ++i) {
                Point p = this.dots.getDot(pin, i);
                if (p.isEnabled() != enabled) continue;
                g.fillRect(p.x - 1, p.y - 1, 3, 3);
            }
        }
    }

    private void generateLineSegments(ArrayList allPaths) {
        int x = 0;
        int y = 0;
        for (int i = 0; i < allPaths.size(); ++i) {
            Path[] peripheralPaths = (Path[])allPaths.get(i);
            for (int j = 0; j < peripheralPaths.length; ++j) {
                Coordinate c;
                LineSegment lineSegment = new LineSegment(peripheralPaths[j].getId());
                int index = 0;
                while ((c = peripheralPaths[j].get(index)) != null) {
                    if (c.type == 1 || c.type == 0) {
                        x = c.type == 1 ? this.leftPeripheralsX : this.rightPeripheralsX;
                        y = c.value;
                    } else if (c.type == 6 || c.type == 4) {
                        y = c.value;
                    } else if (c.type == 5 || c.type == 7) {
                        x = c.value;
                    } else {
                        y = c.value;
                        lineSegment.addPoint(x, y);
                        x = c.type == 3 ? this.leftPortPinsX : this.rightPortPinsX;
                    }
                    lineSegment.addPoint(x, y);
                    ++index;
                }
                this.lineSegments.add(lineSegment);
            }
        }
    }
}

