/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BackgroundBorder;
import ch.randelshofer.quaqua.QuaquaMenuPainter;
import ch.randelshofer.quaqua.QuaquaMenuPainterClient;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.PaintableColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class QuaquaMenuUI
extends BasicMenuUI
implements QuaquaMenuPainterClient {
    private int lastMnemonic = 0;
    private static boolean crossMenuMnemonic = true;

    public static ComponentUI createUI(JComponent x) {
        return new QuaquaMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        QuaquaUtilities.installProperty(this.menuItem, "opaque", Boolean.TRUE);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        QuaquaMenuPainter.getInstance().paintMenuItem(this, g, c, checkIcon, arrowIcon, background, foreground, this.disabledForeground, this.selectionForeground, defaultTextIconGap, this.acceleratorFont);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension d = QuaquaMenuPainter.getInstance().getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap, this.acceleratorFont);
        return d;
    }

    public void paintBackground(Graphics gr, JComponent component, int menuWidth, int menuHeight) {
        AbstractButton menuItem = (AbstractButton)component;
        if (menuItem.isOpaque()) {
            boolean isSelected;
            Graphics2D g = (Graphics2D)gr;
            Color oldColor = g.getColor();
            boolean isTopLevel = ((JMenu)menuItem).isTopLevelMenu();
            ButtonModel model = menuItem.getModel();
            boolean bl = isSelected = model.isArmed() || menuItem instanceof JMenu && model.isSelected();
            if (isSelected) {
                g.setPaint(PaintableColor.getPaint(this.selectionBackground, menuItem));
            } else if (isTopLevel && component.getParent() != null) {
                g.setPaint(PaintableColor.getPaint(component.getParent().getBackground(), menuItem));
            } else {
                g.setPaint(PaintableColor.getPaint(menuItem.getBackground(), menuItem));
            }
            g.fillRect(0, 0, menuWidth, menuHeight);
            if (isTopLevel) {
                Color shadow;
                String bbName;
                String string = bbName = isSelected ? "MenuBar.selectedBorder" : "MenuBar.border";
                if (UIManager.getBorder(bbName) instanceof BackgroundBorder) {
                    Border bb = ((BackgroundBorder)UIManager.getBorder(bbName)).getBackgroundBorder();
                    bb.paintBorder(component, gr, 0, 0, menuWidth, menuHeight);
                }
                if ((shadow = UIManager.getColor("MenuBar.shadow")) != null) {
                    g.setColor(shadow);
                    g.fillRect(0, menuHeight - 1, menuWidth, 1);
                }
            }
            g.setColor(oldColor);
        }
    }
}

