/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.PFDocument;
import com.infocom.print.PFPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;

public class PFPrintPreview
extends JFrame {
    private JPanel viewPanel = new JPanel();
    private PagePanel pagePanel = new PagePanel();
    private BorderLayout mainLayout = new BorderLayout();
    private BorderLayout pageLayout = new BorderLayout();
    private JScrollBar verticalScrollBar = new JScrollBar(1);
    private JScrollBar horizontalScrollBar = new JScrollBar(0);
    private PFPrintPreviewToolBar toolbar = new PFPrintPreviewToolBar(this);
    private Dimension preferredSize = new Dimension(500, 700);
    private PFPage currentPage = null;
    private PFDocument document = null;
    private int pageIndex = 0;
    private int zoom = 1;

    public PFPrintPreview(PFDocument pFDocument) {
        this.document = pFDocument;
        this.init();
    }

    public void setDocument() {
    }

    public void setZoomIn(int n) {
        this.zoom = n;
    }

    public void setZoomOut(int n) {
        this.zoom = n;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void nextPage() {
        ++this.pageIndex;
        if (this.pageIndex > this.document.getPageCount() - 1) {
            --this.pageIndex;
        }
        this.renderPage();
    }

    public void previousPage() {
        --this.pageIndex;
        if (this.pageIndex < 0) {
            this.pageIndex = 0;
        }
        this.renderPage();
    }

    public void firstPage() {
        this.pageIndex = 0;
        this.renderPage();
    }

    public void lastPage() {
        this.pageIndex = this.document.getPageCount() - 1;
        this.renderPage();
    }

    public void print() {
        this.document.print();
    }

    private void renderPage() {
        this.pagePanel.renderPage(this.document.getPage(this.pageIndex));
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    private void init() {
        this.getContentPane().setLayout(this.mainLayout);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.pagePanel, "Center");
        this.getContentPane().add((Component)this.verticalScrollBar, "East");
        this.getContentPane().add((Component)this.horizontalScrollBar, "South");
        this.setTitle("Print preview:" + this.document.getDocumentName());
        this.setDefaultCloseOperation(3);
        this.pack();
        this.show();
        this.pagePanel.setBackground(Color.white);
        this.pagePanel.setBorder(BorderFactory.createLineBorder(Color.lightGray, 10));
        this.pagePanel.setPreferredSize(new Dimension(500, 900));
        this.renderPage();
    }

    public class PFPrintPreviewToolBar
    extends JToolBar
    implements ActionListener {
        private JButton firstPage = new JButton();
        private JButton lastPage = new JButton();
        private JButton nextPage = new JButton();
        private JButton previousPage = new JButton();
        private JButton zoomIn = new JButton();
        private JButton zoomOut = new JButton();
        private JButton print = new JButton();
        PFPrintPreview preview;

        public PFPrintPreviewToolBar(PFPrintPreview pFPrintPreview2) {
            this.preview = pFPrintPreview2;
            this.init();
        }

        private void init() {
            this.firstPage.setIcon(new ImageIcon(this.getClass().getResource("images/FirstPage.gif")));
            this.firstPage.setActionCommand("firstPage");
            this.firstPage.addActionListener(this);
            this.previousPage.setIcon(new ImageIcon(this.getClass().getResource("images/PreviousPage.gif")));
            this.previousPage.setActionCommand("previousPage");
            this.previousPage.addActionListener(this);
            this.nextPage.setIcon(new ImageIcon(this.getClass().getResource("images/NextPage.gif")));
            this.nextPage.setActionCommand("nextPage");
            this.nextPage.addActionListener(this);
            this.lastPage.setIcon(new ImageIcon(this.getClass().getResource("images/LastPage.gif")));
            this.lastPage.setActionCommand("lastPage");
            this.lastPage.addActionListener(this);
            this.zoomIn.setIcon(new ImageIcon(this.getClass().getResource("images/ZoomIn.gif")));
            this.zoomIn.setActionCommand("zoomIn");
            this.zoomIn.addActionListener(this);
            this.zoomIn.setEnabled(false);
            this.zoomOut.setIcon(new ImageIcon(this.getClass().getResource("images/ZoomOut.gif")));
            this.zoomOut.setActionCommand("zoomOut");
            this.zoomOut.addActionListener(this);
            this.zoomOut.setEnabled(false);
            this.print.setIcon(new ImageIcon(this.getClass().getResource("images/Print.gif")));
            this.print.setActionCommand("print");
            this.print.addActionListener(this);
            this.add(this.firstPage);
            this.add(this.previousPage);
            this.add(this.nextPage);
            this.add(this.lastPage);
            this.add(this.zoomIn);
            this.add(this.zoomOut);
            this.add(this.print);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("nextPage")) {
                this.preview.nextPage();
            } else if (string.equals("previousPage")) {
                this.preview.previousPage();
            } else if (string.equals("firstPage")) {
                this.preview.firstPage();
            } else if (string.equals("lastPage")) {
                this.preview.lastPage();
            } else if (string.equals("print")) {
                this.preview.print();
            }
        }
    }

    private class PagePanel
    extends JPanel {
        private PFPage page;
        private int zoom = 1;

        public void setZoomIn(int n) {
            this.zoom = n;
            this.setSize(this.getSize().width * this.zoom, this.getSize().height * this.zoom);
            this.repaint();
        }

        public void setZoomOut(int n) {
            this.zoom = n;
            this.setSize(this.getSize().width / this.zoom, this.getSize().height / this.zoom);
            this.repaint();
        }

        public void renderPage(PFPage pFPage) {
            this.page = pFPage;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Dimension dimension = this.getSize();
            double d = 0.77;
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.scale(d, d);
            graphics2D.setColor(Color.red);
            graphics2D.drawRect(0, 0, dimension.width, dimension.height);
            if (this.page != null) {
                this.page.print(graphics2D, new PageFormat(), 0);
            }
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, this);
            }
        }
    }
}

