/*
 * Decompiled with CFR 0.152.
 */
package com.informagen;

import com.informagen.FilterByMacOSType;
import com.informagen.Sequence;
import com.informagen.SequenceFile;
import com.informagen.swing.ExtensionFileFilter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import net.roydesign.mac.MRJAdapter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class MacVectorFile
extends SequenceFile {
    private DataInputStream stream = null;
    private static FileFilter fileFilter = null;
    static byte[] naCharSet = new byte[]{0, 65, 67, 77, 71, 82, 83, 86, 84, 87, 89, 72, 75, 68, 66, 78};
    static byte[] naOutCharSet = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 14, 2, 13, 0, 0, 4, 11, 0, 0, 12, 0, 3, 15, 0, 0, 0, 5, 6, 8, 8, 7, 9, 0, 10, 0};
    static byte[] aaCharSet = new byte[]{0, 65, 67, 68, 69, 70, 71, 72, 73, 75, 76, 77, 78, 80, 81, 82, 83, 84, 86, 87, 89, 66, 90, 88};
    static byte[] aaOutCharSet = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 21, 2, 3, 4, 5, 6, 7, 8, 0, 9, 10, 11, 12, 0, 13, 14, 15, 16, 17, 0, 18, 19, 23, 20, 22};

    public MacVectorFile() {
    }

    public MacVectorFile(File file) {
        super(file);
    }

    public FileFilter getFileFilter() {
        if (fileFilter != null) {
            return fileFilter;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            fileFilter = new FilterByMacOSType();
            ((FilterByMacOSType)fileFilter).addSignature("MVTR", "NUCL");
            ((FilterByMacOSType)fileFilter).addSignature("MVTR", "PROT");
            ((FilterByMacOSType)fileFilter).setDescription("MacVector");
        } else {
            fileFilter = new ExtensionFileFilter();
            ((ExtensionFileFilter)fileFilter).addExtension("seq");
            ((ExtensionFileFilter)fileFilter).addExtension("pro");
            ((ExtensionFileFilter)fileFilter).setDescription("MacVector");
        }
        return fileFilter;
    }

    public void close() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Sequence read() {
        Sequence sequence = new Sequence();
        sequence.setUID(StringUtils.substringBefore(this.file.getName(), "."));
        sequence.setTitle("MacVector file: " + this.file.getName());
        String string = "NUCL";
        try {
            string = MRJAdapter.getFileType(this.file);
        }
        catch (IOException iOException) {
            string = "NUCL";
        }
        byte[] byArray = string.equals("NUCL") ? naCharSet : aaCharSet;
        try {
            this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
            this.stream.skip(32L);
            int n = this.stream.readInt();
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byte by = this.stream.readByte();
                byArray2[i] = byArray[by];
            }
            if (string.equals("NUCL")) {
                sequence.setDNA();
            } else {
                sequence.setProtein();
            }
            sequence.setSequence(new String(byArray2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sequence;
    }

    public void write(Sequence sequence) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            String string = sequence.getSequence();
            if (string == null) {
                string = "";
            }
            int n = string.length();
            string = string.toUpperCase();
            byte[] byArray = new byte[12];
            byArray[0] = sequence.isProtein() ? (byte)1 : 0;
            byArray[4] = 1;
            byArray[5] = 1;
            byArray[6] = 66;
            byArray[7] = sequence.isNucleic() ? -128 : 0;
            byArray[8] = 2;
            byArray[9] = 5;
            byArray[10] = 2;
            byArray[11] = 106;
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n);
            byte[] byArray2 = sequence.isNucleic() ? naOutCharSet : aaOutCharSet;
            byte[] byArray3 = string.getBytes();
            for (int i = 0; i < byArray3.length; ++i) {
                dataOutputStream.writeByte(byArray2[byArray3[i]]);
            }
            dataOutputStream.writeInt(0);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(86);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeShort(83);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeShort(73);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeShort(31);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeShort(6);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeShort(12);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeByte(127);
            dataOutputStream.writeUTF("geneva");
            dataOutputStream.writeUTF("<Sequence Name>");
            dataOutputStream.writeInt(0x1000000);
            dataOutputStream.writeInt(3);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(25164800);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0x71000000);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(26368);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(100);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0x150000);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(6);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(-2147483392);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0x2C000000);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(6912);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0x6000000);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(2304);
            dataOutputStream.writeInt(0x810000);
            dataOutputStream.writeInt(65536);
            dataOutputStream.writeInt(0x1000100);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(768);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(2147024896);
            dataOutputStream.writeInt(93);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0x530000);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0x150000);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(6);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(4);
            dataOutputStream.writeInt(256);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0x1B000000);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(1536);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(150995073);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(196608);
            dataOutputStream.writeInt(256);
            dataOutputStream.writeInt(0xEE0000);
            dataOutputStream.writeInt(0x900000);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(28311624);
            dataOutputStream.writeInt(12);
            dataOutputStream.flush();
            dataOutputStream.close();
            MRJAdapter.setFileCreator(this.file, "MVTR");
            if (sequence.isDNA()) {
                MRJAdapter.setFileType(this.file, "NUCL");
            } else if (sequence.isRNA()) {
                MRJAdapter.setFileType(this.file, "NUCL");
            } else if (sequence.isProtein()) {
                MRJAdapter.setFileType(this.file, "PROT");
            } else {
                MRJAdapter.setFileType(this.file, "NUCL");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

