/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import java.awt.Color;
import java.util.Hashtable;

public class GIVColors {
    private static Hashtable colorTable = new Hashtable();
    private static Hashtable rgbTable = new Hashtable();

    private GIVColors() {
    }

    public static Color getColor(String string) {
        int[] nArray;
        if (string.startsWith("#")) {
            return GIVColors.getEncodedColor(string);
        }
        String string2 = string.toLowerCase();
        Object object = colorTable.get(string2);
        if (object == null && (nArray = (int[])rgbTable.get(string2)) != null) {
            object = new Color(nArray[0], nArray[1], nArray[2]);
            colorTable.put(string2, object);
        }
        if (object == null) {
            object = Color.black;
        }
        return (Color)object;
    }

    public static Color getEncodedColor(String string) {
        Color color;
        try {
            color = Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            color = Color.black;
        }
        return color;
    }

    private static void addColor(String string, int n, int n2, int n3) {
        String string2 = string.toLowerCase();
        int[] nArray = new int[]{n, n2, n3};
        rgbTable.put(string2, nArray);
    }

    private static void createJavaColors() {
        colorTable.put("Black", Color.black);
        colorTable.put("Blue", Color.blue);
        colorTable.put("Cyan", Color.cyan);
        colorTable.put("Dark Gray", Color.darkGray);
        colorTable.put("Gray", Color.gray);
        colorTable.put("Green", Color.green);
        colorTable.put("Light Gray", Color.lightGray);
        colorTable.put("Magenta", Color.magenta);
        colorTable.put("Orange", Color.orange);
        colorTable.put("Pink", Color.pink);
        colorTable.put("Red", Color.red);
        colorTable.put("White", Color.white);
        colorTable.put("Yellow", Color.yellow);
    }

    private static void createCrayolaColors() {
        GIVColors.addColor("Apricot", 255, 217, 179);
        GIVColors.addColor("Aquamarine", 0, 230, 230);
        GIVColors.addColor("Bittersweet", 217, 77, 0);
        GIVColors.addColor("Black", 0, 0, 0);
        GIVColors.addColor("Blue", 74, 77, 201);
        GIVColors.addColor("Blue Gray", 128, 158, 184);
        GIVColors.addColor("Blue Green", 0, 176, 161);
        GIVColors.addColor("Blue Violet", 23, 0, 84);
        GIVColors.addColor("Brick", 173, 0, 0);
        GIVColors.addColor("Brown", 128, 38, 0);
        GIVColors.addColor("Burnt Sienna", 150, 64, 0);
        GIVColors.addColor("Carnation", 255, 191, 191);
        GIVColors.addColor("Chinese Red", 128, 13, 0);
        GIVColors.addColor("Copper", 179, 51, 10);
        GIVColors.addColor("Cornflower", 163, 145, 255);
        GIVColors.addColor("Forest Green", 0, 94, 0);
        GIVColors.addColor("Gold", 255, 204, 0);
        GIVColors.addColor("Goldenrod", 255, 191, 51);
        GIVColors.addColor("Gray", 153, 153, 153);
        GIVColors.addColor("Gray Blue", 89, 143, 158);
        GIVColors.addColor("Green", 0, 209, 0);
        GIVColors.addColor("Green Blue", 0, 153, 161);
        GIVColors.addColor("Green Yellow", 204, 255, 0);
        GIVColors.addColor("Lavender", 255, 179, 255);
        GIVColors.addColor("Lemon", 255, 255, 77);
        GIVColors.addColor("Magenta", 255, 0, 255);
        GIVColors.addColor("Mahogany", 181, 64, 0);
        GIVColors.addColor("Maize", 255, 191, 26);
        GIVColors.addColor("Maroon", 199, 0, 66);
        GIVColors.addColor("Melon", 255, 89, 56);
        GIVColors.addColor("Midnight", 0, 20, 102);
        GIVColors.addColor("Mulberry", 214, 0, 120);
        GIVColors.addColor("Navy", 0, 0, 148);
        GIVColors.addColor("Olive", 214, 214, 69);
        GIVColors.addColor("Orange", 255, 153, 0);
        GIVColors.addColor("Orange Red", 255, 26, 0);
        GIVColors.addColor("Orange Yellow", 255, 191, 0);
        GIVColors.addColor("Orchid", 255, 128, 255);
        GIVColors.addColor("Peach", 255, 204, 166);
        GIVColors.addColor("Periwinkle", 179, 179, 217);
        GIVColors.addColor("Pine Green", 18, 105, 61);
        GIVColors.addColor("Plum", 71, 0, 102);
        GIVColors.addColor("Purple", 61, 0, 84);
        GIVColors.addColor("Raw Sienna", 176, 69, 0);
        GIVColors.addColor("Raw Umber", 84, 20, 0);
        GIVColors.addColor("Red", 224, 0, 0);
        GIVColors.addColor("Red Orange", 255, 64, 0);
        GIVColors.addColor("Red Violet", 222, 0, 186);
        GIVColors.addColor("Rose", 255, 128, 179);
        GIVColors.addColor("Salmon", 255, 153, 128);
        GIVColors.addColor("Seafoam", 0, 255, 102);
        GIVColors.addColor("Sepia", 117, 38, 51);
        GIVColors.addColor("Silver", 166, 166, 166);
        GIVColors.addColor("Sky", 184, 235, 255);
        GIVColors.addColor("Spring Green", 0, 255, 0);
        GIVColors.addColor("Swamp Fire", 222, 71, 0);
        GIVColors.addColor("Tan", 186, 99, 0);
        GIVColors.addColor("Turquoise", 0, 204, 204);
        GIVColors.addColor("Violet Blue", 51, 0, 84);
        GIVColors.addColor("Violet Red", 230, 0, 255);
        GIVColors.addColor("Yellow", 255, 255, 0);
        GIVColors.addColor("Yellow Green", 179, 255, 0);
        GIVColors.addColor("Yellow Orange", 255, 166, 0);
        GIVColors.addColor("White", 255, 255, 255);
    }

    private static void createGrayScaleColors() {
        GIVColors.addColor("White", 255, 255, 255);
        GIVColors.addColor("Black", 0, 0, 0);
        GIVColors.addColor("AGA 01", 238, 238, 238);
        GIVColors.addColor("AGA 02", 221, 221, 221);
        GIVColors.addColor("AGA 03", 204, 204, 204);
        GIVColors.addColor("AGA 04", 187, 187, 187);
        GIVColors.addColor("AGA 05", 170, 170, 170);
        GIVColors.addColor("AGA 06", 153, 153, 153);
        GIVColors.addColor("AGA 07", 136, 136, 136);
        GIVColors.addColor("AGA 08", 119, 119, 119);
        GIVColors.addColor("AGA 09", 102, 102, 102);
        GIVColors.addColor("AGA 10", 85, 85, 85);
        GIVColors.addColor("AGA 11", 68, 68, 68);
        GIVColors.addColor("AGA 12", 34, 34, 34);
        GIVColors.addColor("AGA A", 51, 51, 51);
        GIVColors.addColor("AGA A1", 204, 204, 255);
        GIVColors.addColor("AGA A2", 153, 153, 255);
        GIVColors.addColor("AGA A3", 102, 102, 204);
        GIVColors.addColor("AGA A4", 51, 51, 153);
    }

    static {
        GIVColors.createJavaColors();
        GIVColors.createGrayScaleColors();
        GIVColors.createCrayolaColors();
    }
}

