/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.primer3;

import com.informagen.primer3.CHECK_ERROR_Exception;
import com.informagen.primer3.dpal_args;
import com.informagen.primer3.dpal_results;

public class Dpal {
    static final int DPAL_MAX_ALIGN = 1600;
    public static final int DPAL_LOCAL = 0;
    public static final int DPAL_GLOBAL_END = 1;
    public static final int DPAL_GLOBAL = 2;
    public static final int DPAL_LOCAL_END = 3;

    private static void CHECK_ERROR(boolean bl, String string) throws CHECK_ERROR_Exception {
        if (bl) {
            throw new CHECK_ERROR_Exception(string);
        }
    }

    public static void dpal(char[] cArray, char[] cArray2, dpal_args dpal_args2, dpal_results dpal_results2) {
        StringBuffer stringBuffer = new StringBuffer("Illegal character in input: ");
        dpal_results2.score = Integer.MIN_VALUE;
        dpal_results2.path_length = 0;
        dpal_results2.msg = null;
        try {
            Dpal.CHECK_ERROR(null == cArray, "NULL first sequence");
            Dpal.CHECK_ERROR(null == cArray2, "NULL second sequence");
            Dpal.CHECK_ERROR(null == dpal_args2, "NULL 'in' pointer");
            Dpal.CHECK_ERROR(null == dpal_results2, "NULL 'out' pointer");
            Dpal.CHECK_ERROR(dpal_args2.flag != 2 && dpal_args2.flag != 1 && dpal_args2.flag != 3 && dpal_args2.flag != 0, "Illegal flag");
            if (dpal_args2.check_chars != 0) {
                Dpal.CHECK_ERROR(Dpal.illegal_char(new String(cArray), dpal_args2.ssm, stringBuffer), stringBuffer.toString());
                Dpal.CHECK_ERROR(Dpal.illegal_char(new String(cArray2), dpal_args2.ssm, stringBuffer), stringBuffer.toString());
            }
            int n = cArray.length;
            int n2 = cArray2.length;
            dpal_results2.align_end_1 = -1;
            dpal_results2.align_end_2 = -1;
            if ('\u0000' == cArray[0]) {
                dpal_results2.msg = "Empty first sequence";
                dpal_results2.score = 0;
                return;
            }
            if ('\u0000' == cArray2[0]) {
                dpal_results2.msg = "Empty second sequence";
                dpal_results2.score = 0;
                return;
            }
            Dpal.CHECK_ERROR(dpal_args2.debug != 0 && dpal_args2.score_only != 0, "score_only must be 0 if debug is non-0");
            if (1 == dpal_args2.force_generic || dpal_args2.debug == 1 || 0 == dpal_args2.score_only) {
                Dpal.CHECK_ERROR(n > 1600, "Sequence 1 longer than DPAL_MAX_ALIGN and alignment is requested");
                Dpal.CHECK_ERROR(n2 > 1600, "Sequence 2 longer than DPAL_MAX_ALIGN and alignment is requested");
                Dpal._dpal_generic(cArray, cArray2, n, n2, dpal_args2, dpal_results2);
            } else if (1 == dpal_args2.force_long_generic) {
                Dpal._dpal_long_nopath_generic(cArray, cArray2, n, n2, dpal_args2, dpal_results2);
            } else if (1 == dpal_args2.max_gap) {
                if (0 == dpal_args2.flag) {
                    Dpal._dpal_long_nopath_maxgap1_local(cArray, cArray2, n, n2, dpal_args2, dpal_results2);
                } else if (1 == dpal_args2.flag) {
                    Dpal._dpal_long_nopath_maxgap1_global_end(cArray, cArray2, n, n2, dpal_args2, dpal_results2);
                } else if (3 == dpal_args2.flag) {
                    Dpal._dpal_long_nopath_maxgap1_local_end(cArray, cArray2, n, n2, dpal_args2, dpal_results2);
                } else if (n <= 1600 && n2 <= 1600) {
                    Dpal._dpal_generic(cArray, cArray2, n, n2, dpal_args2, dpal_results2);
                } else {
                    Dpal._dpal_long_nopath_generic(cArray, cArray2, n, n2, dpal_args2, dpal_results2);
                }
            } else if (n < 1600 && n2 < 1600) {
                Dpal._dpal_generic(cArray, cArray2, n, n2, dpal_args2, dpal_results2);
            } else {
                Dpal._dpal_long_nopath_generic(cArray, cArray2, n, n2, dpal_args2, dpal_results2);
            }
            return;
        }
        catch (CHECK_ERROR_Exception cHECK_ERROR_Exception) {
            if (dpal_args2.fail_stop == 0) {
                return;
            }
            System.err.println("\n" + cHECK_ERROR_Exception.getMessage());
            return;
        }
    }

    private static boolean illegal_char(String string, int[][] nArray, StringBuffer stringBuffer) {
        char c;
        int n = 0;
        for (n = 0; n < string.length() && nArray[c = string.charAt(n)][c] != Integer.MIN_VALUE; ++n) {
        }
        if (n == string.length()) {
            return false;
        }
        stringBuffer.append(string.charAt(n) + " at position " + n);
        return true;
    }

    private static void _dpal_generic(char[] cArray, char[] cArray2, int n, int n2, dpal_args dpal_args2, dpal_results dpal_results2) {
    }

    private static void _dpal_long_nopath_generic(char[] cArray, char[] cArray2, int n, int n2, dpal_args dpal_args2, dpal_results dpal_results2) {
    }

    private static void _dpal_long_nopath_maxgap1_local(char[] cArray, char[] cArray2, int n, int n2, dpal_args dpal_args2, dpal_results dpal_results2) {
        int n3;
        int n4;
        int n5;
        int n6 = dpal_args2.gap;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = nArray;
        int[] nArray5 = nArray2;
        int[] nArray6 = nArray3;
        int n7 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = dpal_args2.ssm[cArray[0]][cArray2[n5]];
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > n7) {
                n7 = n4;
            }
            nArray4[n5] = n4;
        }
        n4 = dpal_args2.ssm[cArray[1]][cArray2[0]];
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > n7) {
            n7 = n4;
        }
        nArray5[0] = n4;
        for (n5 = 1; n5 < n2; ++n5) {
            n4 = nArray4[n5 - 1];
            if (n5 > 1 && (n3 = nArray4[n5 - 2] + n6) > n4) {
                n4 = n3;
            }
            if ((n4 += dpal_args2.ssm[cArray[1]][cArray2[n5]]) < 0) {
                n4 = 0;
            } else if (n4 > n7) {
                n7 = n4;
            }
            nArray5[n5] = n4;
        }
        for (int i = 2; i < n; ++i) {
            n4 = dpal_args2.ssm[cArray[i]][cArray2[0]];
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > n7) {
                n7 = n4;
            }
            nArray6[0] = n4;
            n4 = nArray5[0];
            n3 = nArray4[0] + n6;
            if (n3 > n4) {
                n4 = n3;
            }
            if ((n4 += dpal_args2.ssm[cArray[i]][cArray2[1]]) < 0) {
                n4 = 0;
            } else if (n4 > n7) {
                n7 = n4;
            }
            nArray6[1] = n4;
            for (n5 = 2; n5 < n2; ++n5) {
                n3 = nArray5[n5 - 2];
                n4 = nArray4[n5 - 1];
                if (n3 > n4) {
                    n4 = n3;
                }
                if ((n3 = nArray5[n5 - 1]) > (n4 += n6)) {
                    n4 = n3;
                }
                if ((n4 += dpal_args2.ssm[cArray[i]][cArray2[n5]]) < 0) {
                    n4 = 0;
                } else if (n4 > n7) {
                    n7 = n4;
                }
                nArray6[n5] = n4;
            }
            int[] nArray7 = nArray4;
            nArray4 = nArray5;
            nArray5 = nArray6;
            nArray6 = nArray7;
        }
        dpal_results2.score = n7;
        dpal_results2.path_length = 0;
        nArray = null;
        nArray2 = null;
        nArray3 = null;
    }

    private static void _dpal_long_nopath_maxgap1_global_end(char[] cArray, char[] cArray2, int n, int n2, dpal_args dpal_args2, dpal_results dpal_results2) {
        int[] nArray;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = dpal_args2.gap;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int[] nArray5 = nArray2;
        int[] nArray6 = nArray3;
        int[] nArray7 = nArray4;
        int n8 = dpal_args2.ssm[cArray[n - 1]][cArray2[0]];
        for (n6 = 0; n6 < n; ++n6) {
            nArray5[n6] = dpal_args2.ssm[cArray[n6]][cArray2[0]];
        }
        nArray6[0] = dpal_args2.ssm[cArray[0]][cArray2[1]];
        for (n6 = 1; n6 < n; ++n6) {
            n5 = nArray5[n6 - 1];
            if (n6 > 1 && (n4 = nArray5[n6 - 2] + n7) > n5) {
                n5 = n4;
            }
            if ((n5 += dpal_args2.ssm[cArray[n6]][cArray2[1]]) > n8 && n6 == n - 1) {
                n8 = n5;
            }
            nArray6[n6] = n5;
        }
        int n9 = n2 - n / 2 + 1;
        if (n9 < 1) {
            n9 = 1;
        }
        for (n6 = 2; n6 < n9 + 1; ++n6) {
            nArray7[0] = dpal_args2.ssm[cArray[0]][cArray2[n6]];
            n4 = nArray5[0] + n7;
            n5 = nArray6[0];
            if (n4 > n5) {
                n5 = n4;
            }
            nArray7[1] = n5 += dpal_args2.ssm[cArray[1]][cArray2[n6]];
            for (n3 = 2; n3 < n - 1; ++n3) {
                n4 = nArray5[n3 - 1];
                n5 = nArray6[n3 - 2];
                if (n4 > n5) {
                    n5 = n4;
                }
                if ((n4 = nArray6[n3 - 1]) > (n5 += n7)) {
                    n5 = n4;
                }
                nArray7[n3] = n5 += dpal_args2.ssm[cArray[n3]][cArray2[n6]];
            }
            n4 = nArray5[n - 2];
            n5 = nArray6[n - 3];
            if (n4 > n5) {
                n5 = n4;
            }
            if ((n4 = nArray6[n - 2]) > (n5 += n7)) {
                n5 = n4;
            }
            nArray7[n - 1] = n5 += dpal_args2.ssm[cArray[n - 1]][cArray2[n6]];
            if (n5 > n8) {
                n8 = n5;
            }
            nArray = nArray5;
            nArray5 = nArray6;
            nArray6 = nArray7;
            nArray7 = nArray;
        }
        int n10 = 2;
        for (n6 = n9 + 1; n6 < n2; ++n6) {
            for (n3 = n10; n3 < n - 1; ++n3) {
                n4 = nArray5[n3 - 1];
                n5 = nArray6[n3 - 2];
                if (n4 > n5) {
                    n5 = n4;
                }
                if ((n4 = nArray6[n3 - 1]) > (n5 += n7)) {
                    n5 = n4;
                }
                nArray7[n3] = n5 += dpal_args2.ssm[cArray[n3]][cArray2[n6]];
            }
            n10 += 2;
            n4 = nArray5[n - 2];
            n5 = nArray6[n - 3];
            if (n4 > n5) {
                n5 = n4;
            }
            if ((n4 = nArray6[n - 2]) > (n5 += n7)) {
                n5 = n4;
            }
            nArray7[n - 1] = n5 += dpal_args2.ssm[cArray[n - 1]][cArray2[n6]];
            if (n5 > n8) {
                n8 = n5;
            }
            nArray = nArray5;
            nArray5 = nArray6;
            nArray6 = nArray7;
            nArray7 = nArray;
        }
        nArray2 = null;
        nArray3 = null;
        nArray4 = null;
        dpal_results2.score = n8;
        dpal_results2.path_length = 0;
    }

    private static void _dpal_long_nopath_maxgap1_local_end(char[] cArray, char[] cArray2, int n, int n2, dpal_args dpal_args2, dpal_results dpal_results2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = dpal_args2.gap;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = nArray;
        int[] nArray5 = nArray2;
        int[] nArray6 = nArray3;
        int n8 = 0;
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = dpal_args2.ssm[cArray[0]][cArray2[n6]];
            if (n5 < 0) {
                n5 = 0;
            }
            nArray4[n6] = n5;
        }
        n5 = dpal_args2.ssm[cArray[1]][cArray2[0]];
        if (n5 < 0) {
            n5 = 0;
        }
        nArray5[0] = n5;
        for (n6 = 1; n6 < n2; ++n6) {
            n5 = nArray4[n6 - 1];
            if (n6 > 1 && (n4 = nArray4[n6 - 2] + n7) > n5) {
                n5 = n4;
            }
            if ((n5 += dpal_args2.ssm[cArray[1]][cArray2[n6]]) < 0) {
                n5 = 0;
            }
            nArray5[n6] = n5;
        }
        for (n3 = 2; n3 < n - 1; ++n3) {
            n5 = dpal_args2.ssm[cArray[n3]][cArray2[0]];
            if (n5 < 0) {
                n5 = 0;
            }
            nArray6[0] = n5;
            n4 = nArray4[0] + n7;
            n5 = nArray5[0];
            if (n4 > n5) {
                n5 = n4;
            }
            if ((n5 += dpal_args2.ssm[cArray[n3]][cArray2[1]]) < 0) {
                n5 = 0;
            }
            nArray6[1] = n5;
            for (n6 = 2; n6 < n2; ++n6) {
                n4 = nArray5[n6 - 2];
                n5 = nArray4[n6 - 1];
                if (n4 > n5) {
                    n5 = n4;
                }
                if ((n4 = nArray5[n6 - 1]) > (n5 += n7)) {
                    n5 = n4;
                }
                if ((n5 += dpal_args2.ssm[cArray[n3]][cArray2[n6]]) < 0) {
                    n5 = 0;
                }
                nArray6[n6] = n5;
            }
            int[] nArray7 = nArray4;
            nArray4 = nArray5;
            nArray5 = nArray6;
            nArray6 = nArray7;
        }
        n3 = n - 1;
        n5 = dpal_args2.ssm[cArray[n3]][cArray2[0]];
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 > n8) {
            n8 = n5;
        }
        nArray6[0] = n5;
        n5 = nArray5[0];
        n4 = nArray4[0] + n7;
        if (n4 > n5) {
            n5 = n4;
        }
        if ((n5 += dpal_args2.ssm[cArray[n3]][cArray2[1]]) < 0) {
            n5 = 0;
        } else if (n5 > n8) {
            n8 = n5;
        }
        nArray6[1] = n5;
        for (n6 = 2; n6 < n2; ++n6) {
            n4 = nArray5[n6 - 2];
            n5 = nArray4[n6 - 1];
            if (n4 > n5) {
                n5 = n4;
            }
            if ((n4 = nArray5[n6 - 1]) > (n5 += n7)) {
                n5 = n4;
            }
            if ((n5 += dpal_args2.ssm[cArray[n3]][cArray2[n6]]) < 0) {
                n5 = 0;
            } else if (n5 > n8) {
                n8 = n5;
            }
            nArray6[n6] = n5;
        }
        dpal_results2.score = n8;
        dpal_results2.path_length = 0;
        nArray = null;
        nArray2 = null;
        nArray3 = null;
    }

    static boolean dpal_set_ambiguity_code_matrix(dpal_args dpal_args2) {
        int n = 0;
        for (int i = 0; i < "BDHVRYKMSWN".length(); ++i) {
            char c;
            char c2;
            int n2;
            int n3;
            char c3 = "BDHVRYKMSWN".charAt(i);
            String string = Dpal.xlate_ambiguity_code(c3);
            if (string == null) {
                return false;
            }
            for (n3 = 0; n3 < "BDHVRYKMSWN".length(); ++n3) {
                char c4 = "BDHVRYKMSWN".charAt(n3);
                String string2 = Dpal.xlate_ambiguity_code(c4);
                if (string2 == null) {
                    return false;
                }
                n = Integer.MIN_VALUE;
                for (n2 = 0; n2 < string.length(); ++n2) {
                    c2 = string.charAt(n2);
                    for (int j = 0; j < string2.length(); ++j) {
                        c = string2.charAt(j);
                        if (dpal_args2.ssm[c2][c] <= n) continue;
                        n = dpal_args2.ssm[c2][c];
                    }
                }
                dpal_args2.ssm[c3][c4] = n;
            }
            for (n3 = 0; n3 < "ACGT".length(); ++n3) {
                c = "ACGT".charAt(n3);
                n = Integer.MIN_VALUE;
                for (n2 = 0; n2 < string.length(); ++n2) {
                    c2 = string.charAt(n2);
                    if (dpal_args2.ssm[c2][c] <= n) continue;
                    n = dpal_args2.ssm[c2][c];
                }
                dpal_args2.ssm[c3][c] = n;
                dpal_args2.ssm[c][c3] = n;
            }
        }
        return true;
    }

    private static String xlate_ambiguity_code(char c) {
        if ('N' == c) {
            return "ACGT";
        }
        if ('B' == c) {
            return "CGT";
        }
        if ('D' == c) {
            return "AGT";
        }
        if ('H' == c) {
            return "ACT";
        }
        if ('V' == c) {
            return "ACG";
        }
        if ('R' == c) {
            return "AG";
        }
        if ('Y' == c) {
            return "CT";
        }
        if ('K' == c) {
            return "GT";
        }
        if ('M' == c) {
            return "AC";
        }
        if ('S' == c) {
            return "CG";
        }
        if ('W' == c) {
            return "AT";
        }
        return null;
    }
}

