/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.giv.ElementStyle;
import com.informagen.giv.GIVColors;
import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapPanel;
import com.informagen.giv.MapTile;
import com.informagen.giv.MapView;
import com.informagen.sa.SequenceAnalysis;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DigestParser
extends DefaultHandler {
    private static final int kNoPCDATA = 0;
    private static final double kEdgeBorder = 0.05;
    private int minExtent = -5;
    private int maxExtent = 105;
    private MapView mapView;
    private MapPanel framePanel = null;
    private MapTile selectionTile;
    private MapTile cutsTile;
    private final Color defaultBkgColor = GIVColors.getColor("AGA 06");
    private final Hashtable elementStyleTable = new Hashtable();
    Reader reader;
    String enzymeName = null;

    public DigestParser(Reader reader) {
        this.reader = reader;
    }

    public MapView parseXML() throws IOException {
        this.mapView = new MapView();
        XMLReader xMLReader = null;
        try {
            xMLReader = SequenceAnalysis.getXMLReader();
            ErrorHandler errorHandler = SequenceAnalysis.getSAXErrorHandler();
            xMLReader.setErrorHandler(errorHandler);
            xMLReader.setContentHandler(this);
            InputSource inputSource = new InputSource(this.reader);
            xMLReader.parse(inputSource);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File not Found:  " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SAXException sAXException) {
            throw new IOException("Fatal SAX Error:  " + sAXException.getMessage());
        }
        catch (Exception exception) {
            throw new IOException("Exception:  " + exception.getMessage());
        }
        return this.mapView;
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("digest")) {
            this.doInitialize(attributes);
        } else if (string2.equals("enzyme")) {
            this.doEnzyme(attributes);
        } else if (string2.equals("selection")) {
            this.doSelection(attributes);
        } else if (string2.equals("cut")) {
            this.createCutGlyph(attributes, "cut");
        } else if (string2.equals("unique-cut")) {
            this.createCutGlyph(attributes, "unique-cut");
        } else if (string2.equals("selection-cut")) {
            this.createCutGlyph(attributes, "selection-cut");
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("enzyme")) {
            if (this.selectionTile != null) {
                this.framePanel.add(this.selectionTile);
            }
            this.framePanel.add(this.cutsTile);
        }
    }

    public void endDocument() throws SAXException {
    }

    private void doInitialize(Attributes attributes) {
        this.addStyleFor("selection", "Green", "Never", "Below", 8);
        this.addStyleFor("cut", "Navy", "Always", "Below", 10);
        this.addStyleFor("unique-cut", "Turquoise", "Always", "Below", 10);
        this.addStyleFor("selection-cut", "Red", "Always", "Below", 10);
        int n = Integer.parseInt(attributes.getValue("length"));
        this.minExtent = -((int)((double)n * 0.05));
        this.maxExtent = (int)((double)n * 1.05);
        this.minExtent = this.minExtent < -1 ? this.minExtent : -1;
        this.maxExtent = this.maxExtent > n + 2 ? this.maxExtent : n + 2;
        this.mapView.setExtent(this.minExtent, this.maxExtent);
    }

    private void doEnzyme(Attributes attributes) {
        this.enzymeName = attributes.getValue("label");
        String string = "Peach";
        String string2 = "StackDown";
        int n = 0;
        int n2 = 2;
        this.framePanel = new MapPanel();
        this.framePanel.setBuoyancy(string2, n, n2);
        this.framePanel.setWallpaper(GIVColors.getColor(string));
        this.framePanel.setTitle(this.enzymeName);
        this.framePanel.setExtent(this.minExtent, this.maxExtent);
        this.mapView.add(this.framePanel);
        this.selectionTile = null;
        this.cutsTile = new MapTile("Floating", 0, 0);
    }

    private void addStyleFor(String string, String string2, String string3, String string4, int n) {
        ElementStyle elementStyle = new ElementStyle();
        int n2 = 0;
        if (string3.equalsIgnoreCase("Always")) {
            n2 = 0;
        } else if (string3.equalsIgnoreCase("Bigger")) {
            n2 = 1;
        } else if (string3.equalsIgnoreCase("Never")) {
            n2 = 2;
        }
        elementStyle.labelDisplay(n2);
        int n3 = 0;
        if (string4.equalsIgnoreCase("Below")) {
            n3 = 0;
        } else if (string4.equalsIgnoreCase("Above")) {
            n3 = 1;
        }
        elementStyle.labelPosition(n3);
        elementStyle.barHeight(n);
        elementStyle.setColor(GIVColors.getColor(string2));
        this.elementStyleTable.put(string, elementStyle);
    }

    private void doSelection(Attributes attributes) {
        int n = Integer.parseInt(attributes.getValue("from"));
        int n2 = Integer.parseInt(attributes.getValue("to"));
        ElementStyle elementStyle = (ElementStyle)this.elementStyleTable.get("selection");
        MapGlyph mapGlyph = new MapGlyph("Selection", n, n2 + 1, elementStyle);
        if (this.selectionTile == null) {
            this.selectionTile = new MapTile("StackDown", 0, 3);
            this.framePanel.add(this.selectionTile);
        }
        this.selectionTile.add(mapGlyph);
    }

    private void createCutGlyph(Attributes attributes, String string) {
        int n;
        int n2 = n = Integer.parseInt(attributes.getValue("at"));
        ElementStyle elementStyle = (ElementStyle)this.elementStyleTable.get(string);
        MapGlyph mapGlyph = new MapGlyph(Integer.toString(n), n, n2, elementStyle);
        this.cutsTile.add(mapGlyph);
    }
}

