/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.Sequence;
import com.informagen.sa.digest.CutSite;
import com.informagen.sa.digest.Digest;
import com.informagen.sa.digest.DigestPanel;
import com.informagen.sa.digest.Enzyme;
import com.informagen.sa.digest.EnzymeCuts;
import com.informagen.sa.digest.Enzymes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnzymeSelectionPanel
extends JPanel {
    private final Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private static final int COLS = 5;
    private static final int ALL_ENZYMES = 0;
    private static final int FOUR_CUTTERS = 1;
    private static final int SIX_CUTTERS = 2;
    private static final int UNIQUE_CUTTERS = 3;
    private static final int FLANKING_CUTTERS = 4;
    private final JPanel buttonPanel = new JPanel();
    private JPanel enzymePanel;
    private GridLayout enzymeLayout;
    private JScrollPane enzymesScrollPane;
    private final JComboBox availableChoice = new JComboBox();
    private final JButton selectAllBtn = new JButton("Select All");
    private final JButton unselectAllBtn = new JButton("Unselect All");
    private final JCheckBox perfectChkBox = new JCheckBox("Unambiguous Recognition Sites Only", false);
    private final JButton importEnzymesBtn = new JButton("Import REBASE file");
    private final JButton forgetEnzymesBtn = new JButton("Forget Unselected Enzymes");
    private final JButton defaultEnzymesBtn = new JButton("Use REBASE");
    boolean waitOnBroadcasting = false;
    Vector selectedEnzymes = new Vector();
    private DigestPanel digestPanel;

    public EnzymeSelectionPanel(DigestPanel digestPanel) {
        this.digestPanel = digestPanel;
        this.buildUI();
        this.wireUI();
        this.availableChoice.setSelectedIndex(0);
    }

    void buildUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildButtonPanel(), "North");
        this.buildEnzymePanel();
    }

    void enzymeSelectionChanged() {
        this.digestPanel.enzymeSelectionChanged();
    }

    void wireUI() {
        this.availableChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                if (itemEvent.getStateChange() == 1) {
                    EnzymeSelectionPanel.this.doEnableEnzymes();
                }
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.perfectChkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                EnzymeSelectionPanel.this.doEnableEnzymes();
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.selectAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnzymeSelectionPanel.this.waitOnBroadcasting = true;
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                Component[] componentArray = EnzymeSelectionPanel.this.enzymePanel.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    JCheckBox jCheckBox = (JCheckBox)componentArray[i];
                    if (!jCheckBox.isEnabled()) continue;
                    jCheckBox.setSelected(true);
                }
                EnzymeSelectionPanel.this.waitOnBroadcasting = false;
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                EnzymeSelectionPanel.this.enzymeSelectionChanged();
            }
        });
        this.unselectAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnzymeSelectionPanel.this.waitOnBroadcasting = true;
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                Component[] componentArray = EnzymeSelectionPanel.this.enzymePanel.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    JCheckBox jCheckBox = (JCheckBox)componentArray[i];
                    if (!jCheckBox.isEnabled()) continue;
                    jCheckBox.setSelected(false);
                }
                EnzymeSelectionPanel.this.waitOnBroadcasting = false;
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                EnzymeSelectionPanel.this.enzymeSelectionChanged();
            }
        });
        this.forgetEnzymesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnzymeSelectionPanel.this.waitOnBroadcasting = true;
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                Component[] componentArray = EnzymeSelectionPanel.this.enzymePanel.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    JCheckBox jCheckBox = (JCheckBox)componentArray[i];
                    if (jCheckBox.isSelected()) continue;
                    Enzyme enzyme = (Enzyme)jCheckBox.getClientProperty("enzyme");
                    EnzymeSelectionPanel.this.preferences.remove("REBASE." + enzyme.getName());
                    EnzymeSelectionPanel.this.preferences.remove(enzyme.getName() + ".selected");
                }
                Enzymes.clear();
                EnzymeSelectionPanel.this.dismantleEnzymePanel();
                EnzymeSelectionPanel.this.buildEnzymePanel();
                EnzymeSelectionPanel.this.revalidate();
                EnzymeSelectionPanel.this.doEnableEnzymes();
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                EnzymeSelectionPanel.this.waitOnBroadcasting = false;
            }
        });
        this.defaultEnzymesBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnzymeSelectionPanel.this.waitOnBroadcasting = true;
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                Component[] componentArray = EnzymeSelectionPanel.this.enzymePanel.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    JCheckBox jCheckBox = (JCheckBox)componentArray[i];
                    Enzyme enzyme = (Enzyme)jCheckBox.getClientProperty("enzyme");
                    EnzymeSelectionPanel.this.preferences.remove("REBASE." + enzyme.getName());
                    EnzymeSelectionPanel.this.preferences.remove(enzyme.getName() + ".selected");
                }
                Enzymes.clear();
                Enzymes.getAllEnzymes();
                EnzymeSelectionPanel.this.dismantleEnzymePanel();
                EnzymeSelectionPanel.this.buildEnzymePanel();
                EnzymeSelectionPanel.this.revalidate();
                EnzymeSelectionPanel.this.doEnableEnzymes();
                EnzymeSelectionPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                EnzymeSelectionPanel.this.waitOnBroadcasting = false;
            }
        });
        this.importEnzymesBtn.setEnabled(false);
        this.defaultEnzymesBtn.setText("Use REBASE " + Enzymes.getREBASEVersion());
    }

    JPanel buildButtonPanel() {
        this.availableChoice.addItem("All Enzymes");
        this.availableChoice.addItem("Four Cutters");
        this.availableChoice.addItem("Six Cutters");
        this.availableChoice.addItem("Unique Sites");
        this.availableChoice.addItem("Selection Flanking Sites");
        JPanel jPanel = new JPanel();
        jPanel.add(this.availableChoice);
        jPanel.add(this.selectAllBtn);
        jPanel.add(this.unselectAllBtn);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.perfectChkBox, "South");
        jPanel2.add((Component)new JSeparator(1), "East");
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)jPanel2, "Center");
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.forgetEnzymesBtn, "Center");
        jPanel.add((Component)this.defaultEnzymesBtn, "South");
        this.buttonPanel.add((Component)jPanel, "East");
        return this.buttonPanel;
    }

    void dismantleEnzymePanel() {
        if (this.enzymesScrollPane != null) {
            this.enzymesScrollPane.setVisible(false);
            this.remove(this.enzymesScrollPane);
        }
    }

    void buildEnzymePanel() {
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JCheckBox jCheckBox = (JCheckBox)changeEvent.getSource();
                Enzyme enzyme = (Enzyme)jCheckBox.getClientProperty("enzyme");
                EnzymeSelectionPanel.this.preferences.putBoolean(enzyme.getName() + ".selected", jCheckBox.isSelected());
                if (!EnzymeSelectionPanel.this.waitOnBroadcasting) {
                    EnzymeSelectionPanel.this.enzymeSelectionChanged();
                }
            }
        };
        Vector vector = Enzymes.getAllEnzymes();
        Collections.sort(vector, Enzyme.getComparator());
        int n = vector.size();
        this.enzymePanel = new JPanel();
        this.enzymeLayout = new GridLayout(0, 5, 3, 3);
        this.enzymePanel.setLayout(this.enzymeLayout);
        this.enzymesScrollPane = new JScrollPane(this.enzymePanel, 22, 30);
        for (int i = 0; i < n; ++i) {
            Enzyme enzyme = (Enzyme)vector.elementAt(i);
            String string = enzyme.getName();
            JCheckBox jCheckBox = new JCheckBox(string, true);
            jCheckBox.setSelected(this.preferences.getBoolean(string + ".selected", true));
            jCheckBox.putClientProperty("enzyme", enzyme);
            jCheckBox.addChangeListener(changeListener);
            this.enzymePanel.add(jCheckBox);
        }
        this.add((Component)this.enzymesScrollPane, "Center");
    }

    public Vector getSelectedEnzymes() {
        this.selectedEnzymes.clear();
        Component[] componentArray = this.enzymePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Enzyme enzyme;
            JCheckBox jCheckBox = (JCheckBox)componentArray[i];
            if (!jCheckBox.isEnabled() || !jCheckBox.isSelected() || (enzyme = (Enzyme)jCheckBox.getClientProperty("enzyme")) == null) continue;
            this.selectedEnzymes.addElement(enzyme);
        }
        return this.selectedEnzymes;
    }

    public void sequenceChanged() {
        int n = this.availableChoice.getSelectedIndex();
        if (n == 3) {
            this.enableUniqueCutters();
        } else if (n == 4) {
            this.enableFlankingCutters();
        }
    }

    public boolean selectionChanged() {
        int n = this.availableChoice.getSelectedIndex();
        if (n == 4) {
            this.enableFlankingCutters();
            return true;
        }
        return false;
    }

    private void doEnableEnzymes() {
        int n = this.availableChoice.getSelectedIndex();
        switch (n) {
            case 0: {
                this.enableAllEnzymes();
                break;
            }
            case 3: {
                this.enableUniqueCutters();
                break;
            }
            case 4: {
                this.enableFlankingCutters();
                break;
            }
            case 1: {
                this.enableFourCutters();
                break;
            }
            case 2: {
                this.enableSixCutters();
            }
        }
        this.enzymeSelectionChanged();
    }

    private void disableAllEnzymes() {
        Component[] componentArray = this.enzymePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JCheckBox jCheckBox = (JCheckBox)componentArray[i];
            jCheckBox.setEnabled(false);
        }
    }

    private void resetDisabledCheckboxes() {
    }

    private void enableAllEnzymes() {
        this.waitOnBroadcasting = true;
        Component[] componentArray = this.enzymePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JCheckBox jCheckBox = (JCheckBox)componentArray[i];
            Enzyme enzyme = (Enzyme)jCheckBox.getClientProperty("enzyme");
            if (this.perfectChkBox.isSelected()) {
                jCheckBox.setEnabled(enzyme.isPerfect());
                continue;
            }
            jCheckBox.setEnabled(true);
        }
        this.resetDisabledCheckboxes();
        this.waitOnBroadcasting = false;
    }

    private void enableUniqueCutters() {
        this.waitOnBroadcasting = true;
        this.disableAllEnzymes();
        Sequence sequence = this.digestPanel.getSequence();
        Digest digest = new Digest(sequence, Enzymes.getAllEnzymes());
        digest.doDigest();
        Component[] componentArray = this.enzymePanel.getComponents();
        Iterator iterator = digest.getUniqueCutters().iterator();
        while (iterator.hasNext()) {
            EnzymeCuts enzymeCuts = (EnzymeCuts)iterator.next();
            Enzyme enzyme = enzymeCuts.getEnzyme();
            String string = enzyme.getName();
            for (int i = 0; i < componentArray.length; ++i) {
                JCheckBox jCheckBox = (JCheckBox)componentArray[i];
                if (!string.equals(jCheckBox.getText())) continue;
                if (this.perfectChkBox.isSelected()) {
                    jCheckBox.setEnabled(enzyme.isPerfect() && enzymeCuts.getCutCount() == 1);
                    continue;
                }
                jCheckBox.setEnabled(enzymeCuts.getCutCount() == 1);
            }
        }
        this.resetDisabledCheckboxes();
        this.waitOnBroadcasting = false;
    }

    private void enableFlankingCutters() {
        Object object;
        this.waitOnBroadcasting = true;
        Component[] componentArray = this.enzymePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            object = (JCheckBox)componentArray[i];
            ((AbstractButton)object).setEnabled(false);
        }
        Sequence sequence = this.digestPanel.getSequence();
        object = this.digestPanel.getSelection();
        Digest digest = new Digest(sequence, Enzymes.getAllEnzymes());
        digest.doDigest();
        Iterator iterator = digest.getCutters().iterator();
        while (iterator.hasNext()) {
            EnzymeCuts enzymeCuts = (EnzymeCuts)iterator.next();
            boolean bl = true;
            Iterator iterator2 = enzymeCuts.getCutSites().iterator();
            while (object != null && iterator2.hasNext()) {
                int n = ((CutSite)iterator2.next()).getCutPosition();
                if (n < object[0] || n > object[1]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            Enzyme enzyme = enzymeCuts.getEnzyme();
            String string = enzyme.getName();
            for (int i = 0; i < componentArray.length; ++i) {
                JCheckBox jCheckBox = (JCheckBox)componentArray[i];
                if (!string.equals(jCheckBox.getText())) continue;
                if (this.perfectChkBox.isSelected()) {
                    jCheckBox.setEnabled(enzyme.isPerfect());
                    continue;
                }
                jCheckBox.setEnabled(true);
            }
        }
        this.waitOnBroadcasting = false;
    }

    private void enableFourCutters() {
        this.waitOnBroadcasting = true;
        Component[] componentArray = this.enzymePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JCheckBox jCheckBox = (JCheckBox)componentArray[i];
            Enzyme enzyme = (Enzyme)jCheckBox.getClientProperty("enzyme");
            if (this.perfectChkBox.isSelected()) {
                jCheckBox.setEnabled(enzyme.isPerfect() && enzyme.isFourCutter());
                continue;
            }
            jCheckBox.setEnabled(enzyme.isFourCutter());
        }
        this.resetDisabledCheckboxes();
        this.waitOnBroadcasting = false;
    }

    private void enableSixCutters() {
        this.waitOnBroadcasting = true;
        Component[] componentArray = this.enzymePanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JCheckBox jCheckBox = (JCheckBox)componentArray[i];
            Enzyme enzyme = (Enzyme)jCheckBox.getClientProperty("enzyme");
            if (this.perfectChkBox.isSelected()) {
                jCheckBox.setEnabled(enzyme.isPerfect() && enzyme.isSixCutter());
                continue;
            }
            jCheckBox.setEnabled(enzyme.isSixCutter());
        }
        this.resetDisabledCheckboxes();
        this.waitOnBroadcasting = false;
    }
}

