/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.format;

import com.informagen.sa.format.SequenceFormatter;

public class EMBL
extends SequenceFormatter {
    public EMBL() {
        this.mLineSize = 60;
        this.mBlockSize = 10;
    }

    public StringBuffer allocate() {
        int n = this.mSequence.length();
        return new StringBuffer(n + 10 * (n / 50) + n / 10 + 120);
    }

    protected void formatHeader() {
        this.mFormatted.append("ID   ");
        this.mFormatted.append(this.mCodeword != null ? this.mCodeword : "UNTITLED");
        this.mFormatted.append(" unannotated; ");
        this.mFormatted.append(this.mIsProtein ? "PROTEIN; " : "DNA; ");
        this.mFormatted.append(this.mSequence.length());
        this.mFormatted.append(this.mIsProtein ? " AA." : " BP.");
        if (this.mTitle != null) {
            this.mFormatted.append("\nDE   " + this.mTitle + '\n');
        }
        this.mFormatted.append("XX\nDT   ").append(this.formatTime("dd-MMM-yyyy HH:mm") + '\n').append("XX\n");
        this.mFormatted.append("SQ   Sequence    ").append(this.mSequence.length()).append(this.mIsProtein ? " AA;\n" : " BP;\n");
    }

    protected void formatSequence() {
        this.mFormatted.append("     ");
        char[] cArray = this.mSequence.toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            this.mFormatted.append(cArray[i]);
            ++n;
            if (++n2 == this.mBlockSize) {
                this.mFormatted.append(" ");
                n2 = 0;
            }
            if (n != this.mLineSize) continue;
            this.mFormatted.append("\n     ");
            n = 0;
            n2 = 0;
        }
    }

    protected void formatEnding() {
        this.mFormatted.append("\n//\n");
    }
}

