/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.orf;

import com.informagen.Util;
import com.informagen.giv.GIVColors;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.ImagePrinter;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import com.informagen.sa.orf.ORFViewerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ORFAnalysisPanel
extends AnalysisPanel {
    private final Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    final int maxMinORFSize = 120;
    final JSlider blockSizeSlider = new JSlider(1, 120, 40);
    final JLabel blockSizeLbl = new JLabel(Integer.toString(this.blockSizeSlider.getValue()));
    final JPanel frameSelectionPanel = new JPanel();
    final ButtonGroup framesButtonGrp = new ButtonGroup();
    final JRadioButton allFramesBtn = new JRadioButton("All frames");
    final JRadioButton fwdFramesBtn = new JRadioButton("Forward frames only");
    final JRadioButton revFramesBtn = new JRadioButton("Reverse frames only");
    final JCheckBox showStartBtn = new JCheckBox("Start codons", true);
    final JCheckBox showStopBtn = new JCheckBox("Stop codons", true);
    final JCheckBox stopStopBtn = new JCheckBox("Stop->Stop", false);
    final JCheckBox collapseBtn = new JCheckBox("Collapse ORFs", true);
    final JCheckBox fromBeginningBtn = new JCheckBox("Translate from beginning of sequence", false);
    private final ORFViewerPanel orfViewerPanel = new ORFViewerPanel(this);

    public static String getAnalysisName() {
        return "ORF";
    }

    public ORFAnalysisPanel() {
        this.buildUI();
        this.wireUI();
        this.blockSizeSlider.setValue(this.preferences.getInt("minORFsize", 40));
        this.showStartBtn.setSelected(this.preferences.getBoolean("showStart", true));
        this.showStopBtn.setSelected(this.preferences.getBoolean("showStop", true));
        this.stopStopBtn.setSelected(this.preferences.getBoolean("stop2Stop", false));
        this.collapseBtn.setSelected(this.preferences.getBoolean("collapse", true));
        this.fromBeginningBtn.setSelected(this.preferences.getBoolean("fromBeginning", false));
        String string = this.preferences.get("showFrames", "forward only");
        if (string.equals("all frames")) {
            this.allFramesBtn.setSelected(true);
        } else if (string.equals("forward only")) {
            this.fwdFramesBtn.setSelected(true);
        } else if (string.equals("reverse only")) {
            this.revFramesBtn.setSelected(true);
        }
        this.adjustCheckboxGroup(this.frameSelectionPanel, true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("orfSelectionChanged")) {
            if (this.sequence == null) {
                return;
            }
            this.pcs.firePropertyChange("selectionChanged", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("orfDoubleClicked")) {
            if (this.sequence == null) {
                return;
            }
            this.pcs.firePropertyChange("action.translate", null, null);
        }
    }

    public boolean ignorePropertyChangeEvents() {
        return false;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.graphIt();
    }

    public void sequenceUnavailable() {
        this.saObject = null;
        this.sequence = null;
        this.orfViewerPanel.clear();
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.graphIt();
    }

    public void selectionChanged(int[] nArray) {
    }

    public void selectionCancelled() {
    }

    public void cursorPositionChanged(int n) {
    }

    private void buildUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 0;
        this.frameSelectionPanel.setLayout(new FlowLayout(0, 1, 1));
        this.frameSelectionPanel.add(this.allFramesBtn);
        this.frameSelectionPanel.add(this.fwdFramesBtn);
        this.frameSelectionPanel.add(this.revFramesBtn);
        Util.buildConstraints(gridBagConstraints, n++, n2, 0, 1, 100.0, 0.0, 17, 0);
        gridBagLayout.setConstraints(this.frameSelectionPanel, gridBagConstraints);
        this.add(this.frameSelectionPanel);
        n = 0;
        Util.buildConstraints(gridBagConstraints, n++, ++n2, 1, 1, 0.0, 0.0, 17, 0);
        this.showStartBtn.setForeground(GIVColors.getColor("Navy"));
        gridBagLayout.setConstraints(this.showStartBtn, gridBagConstraints);
        this.add(this.showStartBtn);
        Util.buildConstraints(gridBagConstraints, n++, n2, 1, 1, 0.0, 0.0, 17, 0);
        this.showStopBtn.setForeground(GIVColors.getColor("Magenta"));
        gridBagLayout.setConstraints(this.showStopBtn, gridBagConstraints);
        this.add(this.showStopBtn);
        n = 0;
        Util.buildConstraints(gridBagConstraints, n++, ++n2, 1, 1, 0.0, 0.0, 17, 0);
        gridBagLayout.setConstraints(this.stopStopBtn, gridBagConstraints);
        this.add(this.stopStopBtn);
        Util.buildConstraints(gridBagConstraints, n++, n2, 1, 1, 0.0, 0.0, 17, 0);
        gridBagLayout.setConstraints(this.collapseBtn, gridBagConstraints);
        this.add(this.collapseBtn);
        n = 2;
        Util.buildConstraints(gridBagConstraints, n++, --n2, 1, 1, 0.0, 0.0, 17, 0);
        JLabel jLabel = new JLabel("Min ORF protein size (aa): ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Util.buildConstraints(gridBagConstraints, n++, n2, 1, 1, 0.0, 0.0, 17, 0);
        gridBagLayout.setConstraints(this.blockSizeLbl, gridBagConstraints);
        this.add(this.blockSizeLbl);
        n = 3;
        Util.buildConstraints(gridBagConstraints, n++, ++n2, 0, 1, 100.0, 0.0, 10, 2);
        gridBagLayout.setConstraints(this.blockSizeSlider, gridBagConstraints);
        this.add(this.blockSizeSlider);
        this.blockSizeSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.blockSizeSlider.setSnapToTicks(true);
        n = 0;
        Util.buildConstraints(gridBagConstraints, n++, ++n2, 1, 2, 0.0, 0.0, 17, 0);
        gridBagLayout.setConstraints(this.fromBeginningBtn, gridBagConstraints);
        this.add(this.fromBeginningBtn);
        n = 0;
        Util.buildConstraints(gridBagConstraints, n++, n2 += 2, 0, 4, 100.0, 80.0, 17, 1);
        gridBagConstraints.insets = new Insets(10, 2, 5, 2);
        this.orfViewerPanel.setBackground(Color.white);
        gridBagLayout.setConstraints(this.orfViewerPanel, gridBagConstraints);
        this.add(this.orfViewerPanel);
    }

    private void wireUI() {
        this.fwdFramesBtn.setSelected(true);
        this.framesButtonGrp.add(this.allFramesBtn);
        this.framesButtonGrp.add(this.fwdFramesBtn);
        this.framesButtonGrp.add(this.revFramesBtn);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (ORFAnalysisPanel.this.allFramesBtn.isSelected()) {
                        ORFAnalysisPanel.this.preferences.put("showFrames", "all frames");
                    } else if (ORFAnalysisPanel.this.fwdFramesBtn.isSelected()) {
                        ORFAnalysisPanel.this.preferences.put("showFrames", "forward only");
                    } else if (ORFAnalysisPanel.this.revFramesBtn.isSelected()) {
                        ORFAnalysisPanel.this.preferences.put("showFrames", "reverse only");
                    }
                }
                ORFAnalysisPanel.this.graphIt();
            }
        };
        this.allFramesBtn.addItemListener(itemListener);
        this.fwdFramesBtn.addItemListener(itemListener);
        this.revFramesBtn.addItemListener(itemListener);
        this.blockSizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = ORFAnalysisPanel.this.blockSizeSlider.getValue();
                ORFAnalysisPanel.this.preferences.putInt("minORFsize", ORFAnalysisPanel.this.blockSizeSlider.getValue());
                ORFAnalysisPanel.this.blockSizeLbl.setText(Integer.toString(n));
                ORFAnalysisPanel.this.graphIt();
            }
        });
        this.fromBeginningBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ORFAnalysisPanel.this.preferences.putBoolean("fromBeginning", ORFAnalysisPanel.this.fromBeginningBtn.isSelected());
                ORFAnalysisPanel.this.graphIt();
            }
        });
        this.showStartBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ORFAnalysisPanel.this.preferences.putBoolean("showStart", ORFAnalysisPanel.this.showStartBtn.isSelected());
                ORFAnalysisPanel.this.graphIt();
            }
        });
        this.showStopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ORFAnalysisPanel.this.preferences.putBoolean("showStop", ORFAnalysisPanel.this.showStopBtn.isSelected());
                ORFAnalysisPanel.this.graphIt();
            }
        });
        this.stopStopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ORFAnalysisPanel.this.collapseBtn.setEnabled(!ORFAnalysisPanel.this.stopStopBtn.isSelected());
                ORFAnalysisPanel.this.fromBeginningBtn.setEnabled(!ORFAnalysisPanel.this.stopStopBtn.isSelected());
                ORFAnalysisPanel.this.preferences.putBoolean("stop2Stop", ORFAnalysisPanel.this.stopStopBtn.isSelected());
                ORFAnalysisPanel.this.graphIt();
            }
        });
        this.collapseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ORFAnalysisPanel.this.preferences.putBoolean("collapse", ORFAnalysisPanel.this.collapseBtn.isSelected());
                ORFAnalysisPanel.this.graphIt();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ORFAnalysisPanel.this.graphIt();
            }
        });
    }

    private void enableControls(boolean bl) {
        this.allFramesBtn.setEnabled(bl);
        this.fwdFramesBtn.setEnabled(bl);
        this.revFramesBtn.setEnabled(bl);
        this.showStartBtn.setEnabled(bl);
        this.showStopBtn.setEnabled(bl);
        this.stopStopBtn.setEnabled(bl);
        this.collapseBtn.setEnabled(!this.stopStopBtn.isSelected() && bl);
        this.fromBeginningBtn.setEnabled(!this.stopStopBtn.isSelected() && bl);
        this.blockSizeLbl.setEnabled(bl);
        this.blockSizeSlider.setEnabled(bl);
    }

    public void graphIt() {
        if (this.sequence == null) {
            return;
        }
        this.enableControls(this.sequence.isNucleic());
        if (this.workThread != null) {
            return;
        }
        this.workThread = new Thread(){

            public void run() {
                StringBuffer stringBuffer = new StringBuffer();
                int n = ORFAnalysisPanel.this.sequence.getLength();
                stringBuffer.append("<?xml version='1.0' standalone='yes'?>");
                stringBuffer.append("<ORF name='' length='").append(n).append("'>");
                if (ORFAnalysisPanel.this.sequence.isProtein()) {
                    stringBuffer.append("<frame label='Methionine -> End' frame='+1'>");
                    String string = ORFAnalysisPanel.this.sequence.getSequence();
                    string = string.toUpperCase();
                    int n2 = string.indexOf("M");
                    while (n2 != -1) {
                        stringBuffer.append("<peptide from='").append(n2 + 1).append("' ");
                        stringBuffer.append("to='").append(n).append("'></peptide>");
                        n2 = string.indexOf("M", n2 + 1);
                    }
                    stringBuffer.append("</frame>");
                } else if (ORFAnalysisPanel.this.sequence.getLength() >= 3) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7 = ORFAnalysisPanel.this.blockSizeSlider.getValue();
                    boolean bl = ORFAnalysisPanel.this.showStartBtn.isSelected();
                    boolean bl2 = ORFAnalysisPanel.this.showStopBtn.isSelected();
                    boolean bl3 = ORFAnalysisPanel.this.collapseBtn.isSelected();
                    boolean bl4 = ORFAnalysisPanel.this.stopStopBtn.isSelected();
                    boolean bl5 = ORFAnalysisPanel.this.fromBeginningBtn.isSelected();
                    int[][] nArray = null;
                    int[] nArray2 = null;
                    int[] nArray3 = null;
                    String string = ORFAnalysisPanel.this.sequence.getSequence();
                    string = string.toUpperCase();
                    string = string.replace('U', 'T');
                    if (ORFAnalysisPanel.this.allFramesBtn.isSelected() || ORFAnalysisPanel.this.fwdFramesBtn.isSelected()) {
                        for (n6 = 1; n6 <= 3; ++n6) {
                            stringBuffer.append("<frame label='Forward (+");
                            stringBuffer.append(n6);
                            stringBuffer.append(")' frame='+");
                            stringBuffer.append(n6).append("'>");
                            if (bl && (nArray2 = ORFAnalysisPanel.this.findStartCodons(string)) != null) {
                                for (n5 = 0; n5 < nArray2.length; ++n5) {
                                    stringBuffer.append("<start-codon at='").append(nArray2[n5] + (n6 - 1)).append("'/>");
                                }
                            }
                            if (bl2 && (nArray3 = ORFAnalysisPanel.this.findStopCodons(string)) != null) {
                                for (n5 = 0; n5 < nArray3.length; ++n5) {
                                    stringBuffer.append("<stop-codon at='").append(nArray3[n5] + (n6 - 1)).append("'/>");
                                }
                            }
                            int[][] nArray4 = nArray = bl4 ? ORFAnalysisPanel.this.findStopStopORFs(string, n7) : ORFAnalysisPanel.this.findStartStopORFs(string, n7, bl3, bl5);
                            if (nArray != null) {
                                for (n5 = 0; n5 < nArray.length; ++n5) {
                                    n4 = nArray[n5][0] + (n6 - 1);
                                    n3 = nArray[n5][1] + (n6 - 1);
                                    stringBuffer.append("<orf from='").append(n4).append("' ");
                                    stringBuffer.append("to='").append(n3).append("'/>");
                                }
                            }
                            stringBuffer.append("</frame>");
                            string = string.substring(1);
                        }
                    }
                    ORFAnalysisPanel.this.sequence.revComp();
                    string = ORFAnalysisPanel.this.sequence.getSequence();
                    ORFAnalysisPanel.this.sequence.revComp();
                    string = string.toUpperCase();
                    if (ORFAnalysisPanel.this.allFramesBtn.isSelected() || ORFAnalysisPanel.this.revFramesBtn.isSelected()) {
                        for (n6 = 1; n6 <= 3; ++n6) {
                            stringBuffer.append("<frame label='Reverse (-");
                            stringBuffer.append(n6);
                            stringBuffer.append(")' frame='-");
                            stringBuffer.append(n6).append("'>");
                            if (bl && (nArray2 = ORFAnalysisPanel.this.findStartCodons(string)) != null) {
                                for (n5 = 0; n5 < nArray2.length; ++n5) {
                                    stringBuffer.append("<start-codon at='").append(n - nArray2[n5] - (n6 - 1) - 1).append("'/>");
                                }
                            }
                            if (bl2 && (nArray3 = ORFAnalysisPanel.this.findStopCodons(string)) != null) {
                                for (n5 = 0; n5 < nArray3.length; ++n5) {
                                    stringBuffer.append("<stop-codon at='").append(n - nArray3[n5] - (n6 - 1) - 1).append("'/>");
                                }
                            }
                            int[][] nArray5 = nArray = bl4 ? ORFAnalysisPanel.this.findStopStopORFs(string, n7) : ORFAnalysisPanel.this.findStartStopORFs(string, n7, bl3, bl5);
                            if (nArray != null) {
                                for (n5 = 0; n5 < nArray.length; ++n5) {
                                    n4 = n - nArray[n5][1] - (n6 - 1) + 1;
                                    n3 = n - nArray[n5][0] - (n6 - 1) + 1;
                                    stringBuffer.append("<orf from='").append(n4).append("' ");
                                    stringBuffer.append("to='").append(n3).append("'/>");
                                }
                            }
                            stringBuffer.append("</frame>");
                            string = string.substring(1);
                        }
                    }
                }
                stringBuffer.append("</ORF>");
                ORFAnalysisPanel.this.orfViewerPanel.buildORFmap(stringBuffer.toString());
                ORFAnalysisPanel.this.orfViewerPanel.initialZoom();
                ORFAnalysisPanel.this.orfViewerPanel.invalidate();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ORFAnalysisPanel.this.revalidate();
                    }
                });
                ORFAnalysisPanel.this.workThread = null;
            }
        };
        try {
            this.workThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void adjustCheckboxGroup(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (bl) {
                componentArray[i].setEnabled(true);
                continue;
            }
            componentArray[i].setEnabled(false);
        }
    }

    private int[][] findStartStopORFs(String string, int n, boolean bl, boolean bl2) {
        Vector<int[]> vector = new Vector<int[]>();
        int n2 = string.length();
        int[] nArray = null;
        for (int i = 0; i < n2 - 2; i += 3) {
            String string2 = string.substring(i, i + 3);
            if (!string2.equals("ATG") && (i != 0 || !bl2)) continue;
            int[] nArray2 = new int[]{i, this.findNextStopCodon(string, i) - 1};
            if (bl && nArray != null && nArray[1] > nArray2[0]) {
                nArray2[1] = nArray2[0];
            }
            if ((nArray2[1] - nArray2[0] + 1) / 3 < n) continue;
            vector.addElement(nArray2);
            nArray = nArray2;
        }
        return this.convertToArray(vector);
    }

    private int[][] findStopStopORFs(String string, int n) {
        Vector<int[]> vector = new Vector<int[]>();
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3 - 2) {
            int[] nArray = new int[]{n2, this.findNextStopCodon(string, n2) - 1};
            if ((nArray[1] - nArray[0] + 1) / 3 >= n) {
                vector.addElement(nArray);
            }
            n2 = nArray[1] + 1 + 3;
        }
        return this.convertToArray(vector);
    }

    private int[][] convertToArray(Vector vector) {
        int[][] nArray = null;
        int n = vector.size();
        if (n > 0) {
            nArray = new int[n][2];
            for (int i = 0; i < n; ++i) {
                int[] nArray2 = (int[])vector.elementAt(i);
                nArray[i][0] = nArray2[0] + 1;
                nArray[i][1] = nArray2[1] + 1;
            }
        }
        return nArray;
    }

    private int findNextStopCodon(String string, int n) {
        String string2;
        int n2;
        int n3 = string.length();
        int n4 = n2;
        for (n2 = n; !(n2 >= n3 - 2 || (string2 = string.substring(n2, n2 + 3)).equals("TAA") || string2.equals("TGA") || string2.equals("TAG")); n2 += 3) {
        }
        n4 = n2;
        return n4;
    }

    private int[] findStartCodons(String string) {
        int n;
        int[] nArray = null;
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = string.length();
        for (n = 0; n < n2 - 2; n += 3) {
            String string2 = string.substring(n, n + 3);
            if (!string2.equals("ATG")) continue;
            vector.addElement(new Integer(n));
        }
        n2 = vector.size();
        if (n2 > 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)vector.elementAt(n) + 1;
            }
        }
        return nArray;
    }

    private int[] findStopCodons(String string) {
        int n;
        int[] nArray = null;
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = string.length();
        for (n = 0; n < n2 - 2; n += 3) {
            String string2 = string.substring(n, n + 3);
            if (!string2.equals("TAA") && !string2.equals("TGA") && !string2.equals("TAG")) continue;
            vector.addElement(new Integer(n));
        }
        n2 = vector.size();
        if (n2 > 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = (Integer)vector.elementAt(n) + 1;
            }
        }
        return nArray;
    }

    public void savePanel() {
        int n = this.orfViewerPanel.getSize().width;
        int n2 = this.orfViewerPanel.getSize().height;
        Image image = this.orfViewerPanel.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.orfViewerPanel.paintAll(graphics);
        graphics.dispose();
        String string = this.sequence != null ? this.sequence.getUID() : "";
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveImage(frame, image, string, "Structure");
    }

    public void printPanel() {
        ImagePrinter imagePrinter = new ImagePrinter();
        int n = this.orfViewerPanel.getSize().width;
        int n2 = this.orfViewerPanel.getSize().height;
        Image image = this.orfViewerPanel.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.orfViewerPanel.paintAll(graphics);
        graphics.dispose();
        imagePrinter.setImage(image);
        imagePrinter.print();
    }
}

