/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.primerdesign;

import com.informagen.Sequence;
import com.informagen.Util;
import com.informagen.primer3.Primer3;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.PanelPrinter;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import com.informagen.sa.primerdesign.PrimerOrder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PrimerDesignPanel
extends AnalysisPanel
implements Observer {
    final JCheckBox mPickLeftPrimer = new JCheckBox("Pick left primer", true);
    final JTextField mLeftPrimerInputFld = new JTextField();
    final JCheckBox mPickInternalOligo = new JCheckBox("Pick Internal Oligo", false);
    final JTextField mInternalOligoInputFld = new JTextField();
    final JCheckBox mPickRightPrimer = new JCheckBox("Pick right primer", true);
    final JTextField mRightPrimerInputFld = new JTextField();
    final JTabbedPane mCardTabbedPane = new JTabbedPane();
    final JTabbedPane mOutputTabbedPane = new JTabbedPane();
    final JTextField mTargetFromField = new JTextField("", 4);
    final JTextField mTargetToField = new JTextField("", 4);
    final JTextField mMinProductSizeField = new JTextField("", 4);
    final JTextField mOptProductSizeField = new JTextField("", 4);
    final JTextField mMaxProductSizeField = new JTextField("", 4);
    final JTextField m3primeExcludeField = new JTextField("", 4);
    final JTextField mNumberToReturnField = new JTextField("", 4);
    final JComboBox mMisPrimingLibs = new JComboBox();
    final JCheckBox mShowAlignment = new JCheckBox("Show alignment");
    final JTextField mMinPrimerSizeField = new JTextField("", 4);
    final JTextField mOptPrimerSizeField = new JTextField("", 4);
    final JTextField mMaxPrimerSizeField = new JTextField("", 4);
    final JTextField mMinPrimerTmField = new JTextField("", 4);
    final JTextField mOptPrimerTmField = new JTextField("", 4);
    final JTextField mMaxPrimerTmField = new JTextField("", 4);
    final JTextField mMaxDiffPrimerTmField = new JTextField("", 4);
    final JTextField mMinPrimerGCField = new JTextField("", 4);
    final JTextField mMaxPrimerGCField = new JTextField("", 4);
    final JTextField mPrimerNumberOfNsField = new JTextField("", 4);
    final JTextField mPrimerMaxPolyXField = new JTextField("", 4);
    final JTextField mPrimerGCclampField = new JTextField("", 4);
    final JTextField mExcludeSiteField = new JTextField("", 8);
    JPanel mInternalOligoCard;
    final JTextField mOptOligoSizeField = new JTextField("", 4);
    final JTextField mMinOligoSizeField = new JTextField("", 4);
    final JTextField mMaxOligoSizeField = new JTextField("", 4);
    final JTextField mOptOligoTmField = new JTextField("", 4);
    final JTextField mMinOligoTmField = new JTextField("", 4);
    final JTextField mMaxOligoTmField = new JTextField("", 4);
    final JTextField mMaxDiffOligoTmField = new JTextField("", 4);
    final JTextField mMinOligoGCField = new JTextField("", 4);
    final JTextField mOptOligoGCField = new JTextField("", 4);
    final JTextField mMaxOligoGCField = new JTextField("", 4);
    final JTextField mOligoNumberOfNsField = new JTextField("", 4);
    final JTextField mOligoMaxPolyXField = new JTextField("", 4);
    final JTextField mOligoReportField = new JTextField("", 4);
    final JComboBox mMisHybLibs = new JComboBox();
    final JLabel mChargeBack = new JLabel();
    final JTextField mCostCenter = new JTextField("", 4);
    final JTextField mName = new JTextField("", 12);
    final JTextField mBuilding = new JTextField("", 4);
    final JTextField mRoom = new JTextField("", 4);
    final JTextField mPhone = new JTextField("", 4);
    final JTextField mFAX = new JTextField("", 4);
    final JTextField mEmail = new JTextField("", 4);
    final JRadioButton mPlates = new JRadioButton("Plates", true);
    final JRadioButton mTubes = new JRadioButton("Tubes", false);
    final JComboBox mScale = new JComboBox();
    final JComboBox mFivePrimeCombo = new JComboBox();
    final Vector mFivePrimeMods = new Vector();
    final JComboBox mThreePrimeCombo = new JComboBox();
    final Vector mThreePrimeMods = new Vector();
    final JComboBox mPurityCombo = new JComboBox();
    final Vector mPurityMods = new Vector();
    final JTextField mForwardSuffix = new JTextField("", 5);
    final JTextField mInternalSuffix = new JTextField("", 5);
    final JTextField mReverseSuffix = new JTextField("", 5);
    final JButton mSaveProfileBtn = new JButton("Save");
    final JButton mLoadProfileBtn = new JButton("Load");
    JPanel mProgressCard;
    JTextArea mProgress;
    final JButton mCanelThreadBtn = new JButton("Cancel");
    JButton mDefaultsBtn = new JButton("Reset Values");
    JButton mClearDefaultsBtn = new JButton("Clear Values");
    JButton mCopyrightBtn = new JButton("Copyright");
    JButton mDoPrimer3 = new JButton("Pick Primers");
    JTextArea mOutputArea;
    JTextArea mForOutputArea;
    JTextArea mIntOutputArea;
    JTextArea mRevOutputArea;
    JTextArea mOrderArea;
    final Vector orders = new Vector();
    int mSeqLength;
    Primer3 primer3;
    Thread primer3Thread;
    private Sequence sequence;
    private int[] selection;
    private boolean threadIsRunning = false;

    public static String getAnalysisName() {
        return "Primer3";
    }

    public PrimerDesignPanel() {
        this.buildUI();
        this.wireUI();
        this.doDefaults();
    }

    public boolean ignorePropertyChangeEvents() {
        return true;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = nArray;
        this.mDoPrimer3.setEnabled(this.sequence.isNucleic());
        if (this.selection != null && this.selection[0] != this.selection[1]) {
            this.mTargetFromField.setText(Integer.toString(nArray[0]));
            this.mTargetToField.setText(Integer.toString(nArray[1]));
        }
        this.clearTextAreas();
        this.mCardTabbedPane.setSelectedIndex(1);
    }

    public void sequenceUnavailable() {
        this.saObject = null;
        this.selection = null;
        this.sequence = null;
        this.clearTextAreas();
        this.mCardTabbedPane.setSelectedIndex(1);
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = null;
        this.clearTextAreas();
        this.mTargetFromField.setText("");
        this.mTargetToField.setText("");
        this.mDoPrimer3.setEnabled(this.sequence.isNucleic());
        this.mCardTabbedPane.setSelectedIndex(1);
    }

    public void selectionChanged(int[] nArray) {
        if (nArray[0] != nArray[1]) {
            this.mTargetFromField.setText(Integer.toString(nArray[0]));
            this.mTargetToField.setText(Integer.toString(nArray[1]));
        } else {
            this.mTargetFromField.setText("");
            this.mTargetToField.setText("");
        }
    }

    public void selectionCancelled() {
        this.mTargetFromField.setText("");
        this.mTargetToField.setText("");
        this.mCardTabbedPane.setSelectedIndex(1);
    }

    public void cursorPositionChanged(int n) {
    }

    public void printPanel() {
        PanelPrinter panelPrinter = new PanelPrinter();
        switch (this.mOutputTabbedPane.getSelectedIndex()) {
            case 0: {
                panelPrinter.setText(this.mOutputArea.getText());
                panelPrinter.setPointSize(10);
                break;
            }
            case 1: {
                panelPrinter.setText(this.mForOutputArea.getText());
                panelPrinter.setPointSize(10);
                break;
            }
            case 2: {
                panelPrinter.setText(this.mIntOutputArea.getText());
                panelPrinter.setPointSize(10);
                break;
            }
            case 3: {
                panelPrinter.setText(this.mRevOutputArea.getText());
                panelPrinter.setPointSize(10);
            }
        }
        panelPrinter.print();
    }

    public void savePanel() {
        String string = "";
        String string2 = "";
        switch (this.mOutputTabbedPane.getSelectedIndex()) {
            case 0: {
                string = this.mOutputArea.getText();
                string2 = "Summary";
                break;
            }
            case 1: {
                string = this.mForOutputArea.getText();
                string2 = "For";
                break;
            }
            case 2: {
                string = this.mIntOutputArea.getText();
                string2 = "Int";
                break;
            }
            case 3: {
                string = this.mRevOutputArea.getText();
                string2 = "Rev";
            }
        }
        String string3 = this.sequence != null ? this.sequence.getUID() : "";
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveText(frame, string, string3 + "-" + string2 + ".txt");
    }

    void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.createOutputAreas();
        int n = 0;
        int n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2, n++, 1, 1, 1.0, 0.0, 10, 2);
        this.add((Component)this.buildParameterCards(), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2, n++, 1, 1, 1.0, 0.0, 10, 2);
        this.add((Component)this.buildButtons(), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2, n++, 1, 1, 1.0, 1.0, 10, 1);
        this.add((Component)this.buildOutputArea(), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2, n++, 1, 1, 1.0, 0.0, 10, 2);
        this.mCardTabbedPane.setSelectedIndex(1);
        this.mOutputTabbedPane.setSelectedIndex(0);
    }

    void wireUI() {
        this.mClearDefaultsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrimerDesignPanel.this.doClearDefaults();
            }
        });
        this.mDefaultsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrimerDesignPanel.this.doDefaults();
            }
        });
        this.mCopyrightBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrimerDesignPanel.this.doCopyright();
            }
        });
        this.mDoPrimer3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrimerDesignPanel.this.doPrimer3();
            }
        });
        this.mPickInternalOligo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                switch (itemEvent.getStateChange()) {
                    case 2: {
                        PrimerDesignPanel.this.enableInternalOligoCard(false);
                        break;
                    }
                    case 1: {
                        PrimerDesignPanel.this.enableInternalOligoCard(true);
                    }
                }
            }
        });
    }

    JPanel buildPrimerParameters() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 0;
        Util.buildConstraints(gridBagConstraints, n, n2++, 1, 1, 0.33, 0.0, 10, 0);
        this.mPickLeftPrimer.setEnabled(false);
        this.mPickLeftPrimer.setVisible(false);
        jPanel.add((Component)this.mPickLeftPrimer, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n, n2++, 1, 1, 0.33, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Use the left primer below"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n, n2++, 1, 1, 0.33, 0.0, 10, 2);
        jPanel.add((Component)this.mLeftPrimerInputFld, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, ++n, n2++, 1, 1, 0.33, 0.0, 10, 0);
        this.mPickInternalOligo.setEnabled(true);
        jPanel.add((Component)this.mPickInternalOligo, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n, n2++, 1, 1, 0.33, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("or use the oligo below"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n, n2++, 1, 1, 0.33, 0.0, 10, 2);
        jPanel.add((Component)this.mInternalOligoInputFld, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, ++n, n2++, 1, 1, 0.33, 0.0, 10, 0);
        this.mPickRightPrimer.setEnabled(false);
        this.mPickRightPrimer.setVisible(false);
        jPanel.add((Component)this.mPickRightPrimer, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n, n2++, 1, 1, 0.33, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Use the right primer below"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n, n2++, 1, 1, 0.33, 0.0, 10, 2);
        jPanel.add((Component)this.mRightPrimerInputFld, gridBagConstraints);
        return jPanel;
    }

    JPanel buildParameterCards() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = new String[]{"Use Primers", "Product", "Primers", "Internal Oligo", "Progress"};
        Util.buildConstraints(gridBagConstraints, 0, 0, 0, 0, 1.0, 1.0, 10, 1);
        jPanel.add((Component)this.mCardTabbedPane, gridBagConstraints);
        int n = 0;
        this.mCardTabbedPane.addTab(stringArray[n++], this.buildPrimerParameters());
        this.mCardTabbedPane.addTab(stringArray[n++], this.createProductCard());
        this.mCardTabbedPane.addTab(stringArray[n++], this.createPrimersCard());
        int n2 = n++;
        this.mInternalOligoCard = this.createInternalOligoCard();
        this.mCardTabbedPane.addTab(stringArray[n2], this.mInternalOligoCard);
        int n3 = n++;
        this.mProgressCard = this.createProgressCard();
        this.mCardTabbedPane.addTab(stringArray[n3], this.mProgressCard);
        this.mProgressCard.setEnabled(false);
        return jPanel;
    }

    JPanel createProductCard() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 1;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Min"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Opt"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Max"), gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Region to Amplify:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.mTargetFromField, gridBagConstraints);
        int n3 = ++n2;
        ++n2;
        Util.buildConstraints(gridBagConstraints, n3, n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.mTargetToField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Product size:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.mMinProductSizeField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.mOptProductSizeField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.mMaxProductSizeField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Ignore 3' bases:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.m3primeExcludeField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Number to return:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mNumberToReturnField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 0, 0.0, 1.0, 10, 3);
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        n2 = 6;
        n = 0;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 0, 1.0, 0.0, 10, 2);
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        return jPanel;
    }

    JPanel createPrimersCard() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 1;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Min"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Opt"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Max"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)new JLabel("Max Diff."), gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Primer Size (bp):"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMinPrimerSizeField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mOptPrimerSizeField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMaxPrimerSizeField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Primer Tm (C):"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMinPrimerTmField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mOptPrimerTmField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMaxPrimerTmField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mMaxDiffPrimerTmField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Primer GC (%):"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMinPrimerGCField, gridBagConstraints);
        int n3 = ++n2;
        ++n2;
        Util.buildConstraints(gridBagConstraints, n3, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMaxPrimerGCField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("N's:"), gridBagConstraints);
        n2 += 2;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mPrimerNumberOfNsField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Poly-X:"), gridBagConstraints);
        n2 += 2;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mPrimerMaxPolyXField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 0, 0.0, 1.0, 13, 3);
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        n = 1;
        n2 = 5;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 1.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("GC Clamp:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mPrimerGCclampField, gridBagConstraints);
        n2 = 5;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 1.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Exclude site:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 1.0, 0.0, 17, 2);
        jPanel.add((Component)this.mExcludeSiteField, gridBagConstraints);
        return jPanel;
    }

    JPanel createInternalOligoCard() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 1;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Min"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Opt"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)new JLabel("Max"), gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Oligo Size (bp):"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMinOligoSizeField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mOptOligoSizeField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMaxOligoSizeField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Oligo Tm (C):"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMinOligoTmField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mOptOligoTmField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMaxOligoTmField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Oligo GC (%):"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMinOligoGCField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mOptOligoGCField, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 10, 0);
        jPanel.add((Component)this.mMaxOligoGCField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("N's:"), gridBagConstraints);
        n2 += 2;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mOligoNumberOfNsField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Poly-X:"), gridBagConstraints);
        n2 += 2;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mOligoMaxPolyXField, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 0, 0.0, 1.0, 13, 3);
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        n = 1;
        n2 = 4;
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 1.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Max Report:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n2++, n, 1, 1, 1.0, 0.0, 17, 0);
        jPanel.add((Component)this.mOligoReportField, gridBagConstraints);
        return jPanel;
    }

    private void enableInternalOligoCard(boolean bl) {
        int n = this.mCardTabbedPane.indexOfComponent(this.mInternalOligoCard);
        if (n != -1) {
            this.mCardTabbedPane.setEnabledAt(n, bl);
        }
        this.mOptOligoSizeField.setEnabled(bl);
        this.mMinOligoSizeField.setEnabled(bl);
        this.mMaxOligoSizeField.setEnabled(bl);
        this.mOptOligoTmField.setEnabled(bl);
        this.mMinOligoTmField.setEnabled(bl);
        this.mMaxOligoTmField.setEnabled(bl);
        this.mMaxDiffOligoTmField.setEnabled(bl);
        this.mMinOligoGCField.setEnabled(bl);
        this.mOptOligoGCField.setEnabled(bl);
        this.mMaxOligoGCField.setEnabled(bl);
        this.mOligoNumberOfNsField.setEnabled(bl);
        this.mOligoMaxPolyXField.setEnabled(bl);
        this.mOligoReportField.setEnabled(bl);
        this.mMisHybLibs.setEnabled(bl);
    }

    JPanel createOrderCard() {
        int n;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 0;
        int n3 = 0;
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Account: "), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mChargeBack, gridBagConstraints);
        n3 = 0;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Your cost center: "), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 2, 1, 0.0, 0.0, 17, 2);
        jPanel.add((Component)this.mCostCenter, gridBagConstraints);
        n3 = 0;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Name/Building/Room:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 2, 1, 0.0, 0.0, 10, 2);
        jPanel.add((Component)this.mName, gridBagConstraints);
        int n4 = ++n3;
        Util.buildConstraints(gridBagConstraints, n4, n2, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mBuilding, gridBagConstraints);
        int n5 = ++n3;
        ++n3;
        Util.buildConstraints(gridBagConstraints, n5, n2, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mRoom, gridBagConstraints);
        n3 = 0;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Phone:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 2, 1, 0.0, 0.0, 10, 2);
        jPanel.add((Component)this.mPhone, gridBagConstraints);
        n3 = 0;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("FAX:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 2, 1, 0.0, 0.0, 10, 2);
        jPanel.add((Component)this.mFAX, gridBagConstraints);
        n3 = 0;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("E-mail:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 4, 1, 0.0, 0.0, 10, 2);
        jPanel.add((Component)this.mEmail, gridBagConstraints);
        n3 = 1;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.mPlates, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mTubes, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mPlates);
        buttonGroup.add(this.mTubes);
        n3 += 2;
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Profile:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 1.0, 0.0, 10, 0);
        jPanel.add((Component)this.mSaveProfileBtn, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 1.0, 0.0, 10, 0);
        jPanel.add((Component)this.mLoadProfileBtn, gridBagConstraints);
        n3 = 0;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 0, 0.0, 1.0, 13, 3);
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        n2 = 0;
        n3 = n = 5;
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 1.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Scale:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 0, 1, 1.0, 0.0, 17, 0);
        jPanel.add((Component)this.mScale, gridBagConstraints);
        n3 = n;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 1.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("5' Mod:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 0, 1, 1.0, 0.0, 17, 0);
        jPanel.add((Component)this.mFivePrimeCombo, gridBagConstraints);
        n3 = n;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 1.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("3' Mod:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 0, 1, 1.0, 0.0, 17, 0);
        jPanel.add((Component)this.mThreePrimeCombo, gridBagConstraints);
        n3 = n;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 1.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Purity:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 0, 1, 1.0, 0.0, 17, 0);
        jPanel.add((Component)this.mPurityCombo, gridBagConstraints);
        n3 = n;
        Util.buildConstraints(gridBagConstraints, n3++, ++n2, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)new JLabel("Suffixes:"), gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 1.0, 0.0, 17, 2);
        jPanel.add((Component)this.mForwardSuffix, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 1.0, 0.0, 17, 2);
        jPanel.add((Component)this.mInternalSuffix, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n3++, n2, 1, 1, 1.0, 0.0, 17, 2);
        jPanel.add((Component)this.mReverseSuffix, gridBagConstraints);
        this.fillOrderCard();
        this.wireOrderCard();
        return jPanel;
    }

    void wireOrderCard() {
    }

    void fillOrderCard() {
        this.mScale.addItem("50");
        this.mFivePrimeCombo.addItem("No Modification");
        this.mThreePrimeCombo.addItem("No Modification");
        this.mPurityCombo.addItem("Standard");
    }

    void loadProfile(File file) {
        Properties properties = this.loadProperties(file);
        if (properties != null) {
            this.mCostCenter.setText((String)properties.get("Account"));
            this.mName.setText((String)properties.get("Name"));
            this.mBuilding.setText((String)properties.get("Building"));
            this.mRoom.setText((String)properties.get("Room"));
            this.mPhone.setText((String)properties.get("Phone"));
            this.mFAX.setText((String)properties.get("Fax"));
            this.mEmail.setText((String)properties.get("Email"));
            this.mForwardSuffix.setText((String)properties.get("ForwardSuffix"));
            this.mInternalSuffix.setText((String)properties.get("InternalSuffix"));
            this.mReverseSuffix.setText((String)properties.get("ReverseSuffix"));
        }
    }

    Properties loadProperties(File file) {
        Properties properties = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties = new Properties();
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, fileNotFoundException.toString());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage());
        }
        return properties;
    }

    void saveProfile(File file) {
    }

    JPanel createProgressCard() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, n, 0, 1, 1.0, 1.0, 10, 1);
        jPanel.add((Component)this.mProgress, gridBagConstraints);
        n2 = 0;
        Util.buildConstraints(gridBagConstraints, n2++, ++n, 1, 1, 0.0, 0.0, 13, 0);
        jPanel.add((Component)this.mCanelThreadBtn, gridBagConstraints);
        this.mCanelThreadBtn.setEnabled(false);
        this.mCanelThreadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PrimerDesignPanel.this.primer3Thread != null) {
                    PrimerDesignPanel.this.primer3Thread.interrupt();
                }
            }
        });
        return jPanel;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof Primer3) {
            final String string = (String)object;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PrimerDesignPanel.this.mProgress.setText(string);
                }
            });
        }
    }

    JPanel buildButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 10;
        int n2 = 5;
        int n3 = 5;
        int n4 = 10;
        gridBagConstraints.insets = new Insets(10, 5, 5, 10);
        int n5 = 0;
        Util.buildConstraints(gridBagConstraints, n5++, 0, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mClearDefaultsBtn, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n5++, 0, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mDefaultsBtn, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n5++, 0, 1, 1, 0.0, 0.0, 17, 0);
        jPanel.add((Component)this.mCopyrightBtn, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n5++, 0, 1, 1, 1.0, 0.0, 13, 0);
        jPanel.add((Component)this.mDoPrimer3, gridBagConstraints);
        return jPanel;
    }

    JPanel buildOutputArea() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.mOutputTabbedPane, "Center");
        JScrollPane jScrollPane = null;
        int n = 0;
        jScrollPane = new JScrollPane(this.mOutputArea, 22, 31);
        this.mOutputTabbedPane.add("Summary", jScrollPane);
        this.mOutputTabbedPane.setBackgroundAt(n++, this.mOutputArea.getBackground());
        jScrollPane = new JScrollPane(this.mForOutputArea, 22, 31);
        this.mOutputTabbedPane.add("Left Primers", jScrollPane);
        this.mOutputTabbedPane.setBackgroundAt(n++, this.mForOutputArea.getBackground());
        jScrollPane = new JScrollPane(this.mIntOutputArea, 22, 31);
        this.mOutputTabbedPane.add("Internal Oligos", jScrollPane);
        this.mOutputTabbedPane.setBackgroundAt(n++, this.mIntOutputArea.getBackground());
        jScrollPane = new JScrollPane(this.mRevOutputArea, 22, 31);
        this.mOutputTabbedPane.add("Right Primers", jScrollPane);
        this.mOutputTabbedPane.setBackgroundAt(n++, this.mRevOutputArea.getBackground());
        return jPanel;
    }

    void createOutputAreas() {
        Font font = new Font("Courier", 0, Util.isWindows() ? 10 : 12);
        Insets insets = new Insets(5, 5, 5, 5);
        this.mOutputArea = new JTextArea(80, 80);
        this.mOutputArea.setMargin(insets);
        this.mOutputArea.setFont(font);
        this.mOutputArea.setBackground(Color.white);
        this.mRevOutputArea = new JTextArea(80, 80);
        this.mRevOutputArea.setMargin(insets);
        this.mRevOutputArea.setFont(font);
        this.mRevOutputArea.setBackground(new Color(102, 255, 102));
        this.mForOutputArea = new JTextArea(80, 80);
        this.mForOutputArea.setMargin(insets);
        this.mForOutputArea.setFont(font);
        this.mForOutputArea.setBackground(new Color(255, 137, 137));
        this.mIntOutputArea = new JTextArea(80, 80);
        this.mIntOutputArea.setMargin(insets);
        this.mIntOutputArea.setFont(font);
        this.mIntOutputArea.setBackground(new Color(178, 178, 255));
        this.mOrderArea = new JTextArea(80, 80);
        this.mOrderArea.setMargin(insets);
        this.mOrderArea.setFont(font);
        this.mProgress = new JTextArea(80, 80);
        this.mProgress.setMargin(insets);
        this.mProgress.setFont(new Font("Courier", 0, 10));
    }

    void fillLibraries(JComboBox jComboBox) {
        jComboBox.addItem("None");
        File file = new File(System.getProperty("user.dir") + File.separator + "repbase");
        if (file.exists()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                jComboBox.addItem(stringArray[i]);
            }
        }
    }

    void doReverseComplement(JTextArea jTextArea) {
        String string = new String(jTextArea.getText());
        Sequence sequence = new Sequence(string);
        sequence.revComp();
        jTextArea.setText(sequence.toString());
    }

    protected void doDefaults() {
        this.mPickLeftPrimer.setSelected(true);
        this.mPickInternalOligo.setSelected(false);
        this.mPickRightPrimer.setSelected(true);
        this.mTargetFromField.setText("");
        this.mTargetToField.setText("");
        this.m3primeExcludeField.setText("0");
        this.mMinProductSizeField.setText("");
        this.mOptProductSizeField.setText("");
        this.mMaxProductSizeField.setText("");
        this.mNumberToReturnField.setText("5");
        this.mShowAlignment.setSelected(false);
        this.mMinPrimerSizeField.setText("17");
        this.mOptPrimerSizeField.setText("20");
        this.mMaxPrimerSizeField.setText("23");
        this.mOptPrimerTmField.setText("60");
        this.mMinPrimerTmField.setText("57");
        this.mMaxPrimerTmField.setText("63");
        this.mMaxDiffPrimerTmField.setText("100");
        this.mMinPrimerGCField.setText("43");
        this.mMaxPrimerGCField.setText("60");
        this.mPrimerNumberOfNsField.setText("0");
        this.mPrimerMaxPolyXField.setText("2");
        this.mPrimerGCclampField.setText("2");
        this.mExcludeSiteField.setText("");
        this.mMinOligoSizeField.setText("30");
        this.mOptOligoSizeField.setText("30");
        this.mMaxOligoSizeField.setText("30");
        this.mMinOligoTmField.setText("50");
        this.mOptOligoTmField.setText("60");
        this.mMaxOligoTmField.setText("70");
        this.mMinOligoGCField.setText("43");
        this.mOptOligoGCField.setText("50");
        this.mMaxOligoGCField.setText("60");
        this.mOligoNumberOfNsField.setText("0");
        this.mOligoMaxPolyXField.setText("2");
        this.mOligoReportField.setText("100");
        this.mTubes.setSelected(true);
    }

    void doClearDefaults() {
        this.mPickLeftPrimer.setSelected(true);
        this.mPickInternalOligo.setSelected(false);
        this.mPickRightPrimer.setSelected(true);
        this.mLeftPrimerInputFld.setText("");
        this.mInternalOligoInputFld.setText("");
        this.mRightPrimerInputFld.setText("");
        this.mTargetFromField.setText("");
        this.mTargetToField.setText("");
        this.m3primeExcludeField.setText("");
        this.mMinProductSizeField.setText("");
        this.mOptProductSizeField.setText("");
        this.mMaxProductSizeField.setText("");
        this.mNumberToReturnField.setText("");
        this.mShowAlignment.setSelected(false);
        this.mMinPrimerSizeField.setText("");
        this.mOptPrimerSizeField.setText("");
        this.mMaxPrimerSizeField.setText("");
        this.mOptPrimerTmField.setText("");
        this.mMinPrimerTmField.setText("");
        this.mMaxPrimerTmField.setText("");
        this.mMaxDiffPrimerTmField.setText("");
        this.mMinPrimerGCField.setText("");
        this.mMaxPrimerGCField.setText("");
        this.mPrimerNumberOfNsField.setText("");
        this.mPrimerMaxPolyXField.setText("");
        this.mPrimerGCclampField.setText("");
        this.mExcludeSiteField.setText("");
        this.mMinOligoSizeField.setText("");
        this.mOptOligoSizeField.setText("");
        this.mMaxOligoSizeField.setText("");
        this.mMinOligoTmField.setText("");
        this.mOptOligoTmField.setText("");
        this.mMaxOligoTmField.setText("");
        this.mMinOligoGCField.setText("");
        this.mOptOligoGCField.setText("");
        this.mMaxOligoGCField.setText("");
        this.mOligoNumberOfNsField.setText("");
        this.mOligoMaxPolyXField.setText("");
        this.mOligoReportField.setText("");
        this.clearTextAreas();
    }

    void clearTextAreas() {
        this.mOutputArea.setText("");
        this.mRevOutputArea.setText("");
        this.mForOutputArea.setText("");
        this.mIntOutputArea.setText("");
        this.mOrderArea.setText("");
        this.mProgress.setText("");
    }

    public void doCopyright() {
        String[] stringArray = new String[]{"-copyright"};
        StringWriter stringWriter = new StringWriter();
        try {
            Primer3 primer3 = new Primer3(null, stringArray, stringWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mOutputArea.setText(stringWriter.toString());
        this.mOutputArea.select(0, 0);
        int n = -1;
        n = this.mOutputTabbedPane.indexOfComponent(this.mOutputArea);
        if (n != -1) {
            this.mOutputTabbedPane.setSelectedIndex(n);
        }
    }

    public void doPrimer3() {
        if (!this.sequence.isNucleic()) {
            return;
        }
        this.mProgressCard.setEnabled(true);
        this.mCardTabbedPane.setSelectedComponent(this.mProgressCard);
        this.primer3Thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PrimerDesignPanel.this.mDoPrimer3.setEnabled(false);
                PrimerDesignPanel.this.mCopyrightBtn.setEnabled(false);
                PrimerDesignPanel.this.mCanelThreadBtn.setEnabled(true);
                PrimerDesignPanel.this.orders.removeAllElements();
                Hashtable hashtable = PrimerDesignPanel.this.setupPrimer3();
                PrimerDesignPanel.this.setupSequence(hashtable);
                PrimerDesignPanel.this.setupExcludedRange(hashtable);
                PrimerDesignPanel.this.setupPrimerExcludedSite(hashtable);
                String[] stringArray = new String[]{"-format_output"};
                StringWriter stringWriter = new StringWriter();
                StringWriter stringWriter2 = new StringWriter();
                StringWriter stringWriter3 = new StringWriter();
                StringWriter stringWriter4 = new StringWriter();
                PrimerDesignPanel.this.clearTextAreas();
                try {
                    PrimerDesignPanel.this.primer3 = new Primer3(hashtable, stringArray, stringWriter);
                    PrimerDesignPanel.this.primer3.addObserver(PrimerDesignPanel.this);
                    PrimerDesignPanel.this.primer3.setReportFrequency(100);
                    PrimerDesignPanel.this.primer3.setRevOutputStream(stringWriter2);
                    PrimerDesignPanel.this.primer3.setForOutputStream(stringWriter3);
                    PrimerDesignPanel.this.primer3.setIntOutputStream(stringWriter4);
                    PrimerDesignPanel.this.primer3.run();
                    PrimerDesignPanel.this.orders.addElement(new PrimerOrder(PrimerDesignPanel.this.sequence.getUID(), PrimerDesignPanel.this.primer3.getBestForward(), PrimerDesignPanel.this.primer3.getBestInternal(), PrimerDesignPanel.this.primer3.getBestReverse()));
                    PrimerDesignPanel.this.primer3 = null;
                    PrimerDesignPanel.this.mRevOutputArea.setText(stringWriter2.toString());
                    PrimerDesignPanel.this.mForOutputArea.setText(stringWriter3.toString());
                    PrimerDesignPanel.this.mIntOutputArea.setText(stringWriter4.toString());
                    PrimerDesignPanel.this.writeEmailOrder();
                }
                catch (InterruptedException interruptedException) {
                    stringWriter.write("\n*** Interrupted ***\n");
                }
                catch (Exception exception) {
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    stringWriter.write("\n--------------------------------\nERROR:\n");
                    exception.printStackTrace(printWriter);
                    stringWriter.write("\n--------------------------------\n\n");
                }
                finally {
                    PrimerDesignPanel.this.mOutputArea.setText(stringWriter.toString().replace('\r', '\n'));
                    PrimerDesignPanel.this.mOutputArea.select(0, 0);
                    PrimerDesignPanel.this.mOutputTabbedPane.setSelectedIndex(0);
                    PrimerDesignPanel.this.mDoPrimer3.setEnabled(true);
                    PrimerDesignPanel.this.mCopyrightBtn.setEnabled(true);
                    PrimerDesignPanel.this.mCanelThreadBtn.setEnabled(false);
                }
            }
        };
        this.primer3Thread.setPriority(Thread.currentThread().getPriority() - 2);
        this.primer3Thread.start();
    }

    protected void writeEmailOrder() {
        String string;
        String string2;
        String string3;
        PrimerOrder primerOrder;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("H1:").append(this.mChargeBack.getText()).append("\n");
        stringBuffer.append("H3:").append(this.mCostCenter.getText()).append("\n");
        stringBuffer.append("HA:").append(this.mName.getText()).append("/").append(this.mBuilding.getText()).append("/").append(this.mRoom.getText()).append("\n");
        stringBuffer.append("HB:").append(this.mPhone.getText()).append("\n");
        stringBuffer.append("HC:").append(this.mFAX.getText()).append("\n");
        stringBuffer.append("HD:").append(this.mEmail.getText()).append("\n");
        stringBuffer.append("HX:").append(this.mPlates.isSelected() ? "P" : "T").append("\n");
        int n = 0;
        Iterator iterator = this.orders.iterator();
        while (iterator.hasNext()) {
            primerOrder = (PrimerOrder)iterator.next();
            string3 = primerOrder.forward;
            string2 = primerOrder.internal;
            string = primerOrder.reverse;
            if (string3 != null && string3.length() > 0) {
                ++n;
            }
            if (string2 != null && string2.length() > 0) {
                ++n;
            }
            if (string == null || string.length() <= 0) continue;
            ++n;
        }
        stringBuffer.append("HZ:").append(n).append("\n");
        stringBuffer.append("*\n");
        iterator = this.orders.iterator();
        while (iterator.hasNext()) {
            primerOrder = (PrimerOrder)iterator.next();
            string3 = primerOrder.name;
            string2 = primerOrder.forward;
            string = primerOrder.internal;
            String string4 = primerOrder.reverse;
            if (string2 != null && string2.length() > 0) {
                this.writePrimer(stringBuffer, string3, this.mForwardSuffix.getText(), string2);
                this.writeOptions(stringBuffer);
                stringBuffer.append("*\n");
            }
            if (string != null && string.length() > 0) {
                this.writePrimer(stringBuffer, string3, this.mInternalSuffix.getText(), string);
                stringBuffer.append("D4:").append("200").append("\n");
                stringBuffer.append("D7:").append("HPL").append("\n");
                stringBuffer.append("*\n");
            }
            if (string4 == null || string4.length() <= 0) continue;
            this.writePrimer(stringBuffer, string3, this.mReverseSuffix.getText(), string4);
            this.writeOptions(stringBuffer);
            stringBuffer.append("*\n");
        }
        this.mOrderArea.setText(stringBuffer.toString());
    }

    void writePrimer(StringBuffer stringBuffer, String string, String string2, String string3) {
        stringBuffer.append("D1:").append(this.mName.getText()).append("\n");
        stringBuffer.append("D2:" + string + string2 + "\n");
        stringBuffer.append("D3:" + string3 + "\n");
    }

    void writeOptions(StringBuffer stringBuffer) {
    }

    protected Hashtable setupPrimer3() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.setupWebDefaults(hashtable);
        this.setupTask(hashtable);
        this.setupTargetRange(hashtable);
        this.setupProductSize(hashtable);
        this.setupExcludedRange(hashtable);
        this.setupPrimerSize(hashtable);
        this.setupPrimerTm(hashtable);
        this.setupPrimerGC(hashtable);
        this.setupPrimerOther(hashtable);
        this.setupReportCount(hashtable);
        if (this.mPickInternalOligo.isSelected()) {
            this.setupOligoSize(hashtable);
            this.setupOligoTm(hashtable);
            this.setupOligoGC(hashtable);
            this.setupOligoOther(hashtable);
        }
        try {
            int n = Integer.parseInt(this.mNumberToReturnField.getText());
            hashtable.put("PRIMER_NUM_RETURN", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        hashtable.put("PRIMER_FILE_FLAG", "1");
        hashtable.put("PRIMER_EXPLAIN_FLAG", "1");
        hashtable.put("PRIMER_FIRST_BASE_INDEX", "1");
        if (!this.mShowAlignment.isSelected()) {
            hashtable.put("PRIMER_ALIGNMENT_FLAG", "0");
        }
        return hashtable;
    }

    protected void setupWebDefaults(Hashtable hashtable) {
        hashtable.put("PRIMER_MAX_END_STABILITY", "9.0");
        hashtable.put("PRIMER_MAX_MISPRIMING", "12.0");
        hashtable.put("PRIMER_PAIR_MAX_MISPRIMING", "24.0");
        hashtable.put("PRIMER_SELF_ANY", "8.0");
        hashtable.put("PRIMER_SELF_END", "3.0");
        hashtable.put("PRIMER_OUTSIDE_PENALTY", "0");
        hashtable.put("PRIMER_LIBERAL_BASE", "1");
        hashtable.put("PRIMER_MIN_END_QUALITY", "0");
        hashtable.put("PRIMER_QUALITY_RANGE_MAX", "0");
        hashtable.put("PRIMER_WT_POS_PENALTY", "0.0");
        hashtable.put("PRIMER_PAIR_WT_PRODUCT_SIZE_LT", "0.05");
        hashtable.put("PRIMER_PAIR_WT_PRODUCT_SIZE_GT", "0.05");
    }

    protected void setupSequence(Hashtable hashtable) {
        String string = this.sequence.getUID();
        hashtable.put("PRIMER_SEQUENCE_ID", string == null ? "Untitled" : string);
        String string2 = this.sequence.getSequence();
        this.mSeqLength = string2.length();
        hashtable.put("SEQUENCE", string2);
    }

    protected void setupTask(Hashtable hashtable) {
        boolean bl = this.mPickLeftPrimer.isSelected();
        boolean bl2 = this.mPickInternalOligo.isSelected();
        boolean bl3 = this.mPickRightPrimer.isSelected();
        if (bl2) {
            hashtable.put("PRIMER_TASK", "PICK_PCR_PRIMERS_AND_HYB_PROBE");
        } else {
            hashtable.put("PRIMER_TASK", "PICK_PCR_PRIMERS");
        }
        if (bl2) {
            hashtable.put("PRIMER_PICK_INTERNAL_OLIGO", "1");
            hashtable.put("PRIMER_INTERNAL_OLIGO_SELF_ANY", "12.0");
            hashtable.put("PRIMER_INTERNAL_OLIGO_SELF_END", "12.0");
            hashtable.put("PRIMER_INTERNAL_OLIGO_MAX_MISHYB", "12.0");
        }
        if (bl && this.mLeftPrimerInputFld.getText().length() > 0) {
            hashtable.put("PRIMER_LEFT_INPUT", this.mLeftPrimerInputFld.getText());
        }
        if (bl2 && this.mInternalOligoInputFld.getText().length() > 0) {
            hashtable.put("PRIMER_INTERNAL_OLIGO_INPUT", this.mInternalOligoInputFld.getText());
        }
        if (bl && this.mRightPrimerInputFld.getText().length() > 0) {
            hashtable.put("PRIMER_RIGHT_INPUT", this.mRightPrimerInputFld.getText());
        }
    }

    protected void setupTargetRange(Hashtable hashtable) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (this.mTargetFromField.getText().length() > 0 && this.mTargetToField.getText().length() > 0) {
            try {
                n = Integer.parseInt(this.mTargetFromField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                n2 = Integer.parseInt(this.mTargetToField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.mTargetFromField.setText(Integer.toString(n));
            this.mTargetToField.setText(Integer.toString(n2));
            int n3 = n2 - n + 1;
            hashtable.put("TARGET", n + "," + n3);
        }
    }

    protected void setupExcludedRange(Hashtable hashtable) {
        int n = 0;
        try {
            n = Integer.parseInt(this.m3primeExcludeField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n == 0) {
            return;
        }
        int n2 = this.mSeqLength - n;
        hashtable.put("EXCLUDED_REGION", n2 + "," + n);
    }

    protected void setupProductSize(Hashtable hashtable) {
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(this.mMinProductSizeField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 100;
        }
        try {
            n2 = Integer.parseInt(this.mMaxProductSizeField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 1000;
        }
        if (n != 0 && n2 != 0) {
            hashtable.put("PRIMER_PRODUCT_SIZE_RANGE", n + "-" + n2);
        }
        try {
            int n3 = Integer.parseInt(this.mOptProductSizeField.getText());
            hashtable.put("PRIMER_PRODUCT_OPT_SIZE", Integer.toString(n3));
        }
        catch (NumberFormatException numberFormatException) {
            hashtable.put("PRIMER_PRODUCT_OPT_SIZE", "200");
        }
    }

    protected void setupPrimerSize(Hashtable hashtable) {
        int n;
        try {
            n = Integer.parseInt(this.mMinPrimerSizeField.getText());
            hashtable.put("PRIMER_MIN_SIZE", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(this.mOptPrimerSizeField.getText());
            hashtable.put("PRIMER_OPT_SIZE", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n2 = Integer.parseInt(this.mMaxPrimerSizeField.getText());
            hashtable.put("PRIMER_MAX_SIZE", Integer.toString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setupPrimerTm(Hashtable hashtable) {
        int n;
        try {
            n = Integer.parseInt(this.mMinPrimerTmField.getText());
            hashtable.put("PRIMER_MIN_TM", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(this.mOptPrimerTmField.getText());
            hashtable.put("PRIMER_OPT_TM", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n2 = Integer.parseInt(this.mMaxPrimerTmField.getText());
            hashtable.put("PRIMER_MAX_TM", Integer.toString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n3 = Integer.parseInt(this.mMaxDiffPrimerTmField.getText());
            hashtable.put("PRIMER_MAX_DIFF_TM", Integer.toString(n3));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setupPrimerGC(Hashtable hashtable) {
        int n;
        try {
            n = Integer.parseInt(this.mMinPrimerGCField.getText());
            hashtable.put("PRIMER_MIN_GC", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(this.mMaxPrimerGCField.getText());
            hashtable.put("PRIMER_MAX_GC", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setupPrimerExcludedSite(Hashtable hashtable) {
        String string = (String)hashtable.get("SEQUENCE");
        if ((string = string.toUpperCase()) == null) {
            return;
        }
        String string2 = this.mExcludeSiteField.getText();
        if (string2.length() == 0) {
            return;
        }
        string2 = string2.toUpperCase();
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        while ((n = string.indexOf(string2, n)) != -1) {
            stringBuffer.append(n + 1);
            stringBuffer.append(",");
            stringBuffer.append(string2.length());
            stringBuffer.append(" ");
            ++n;
        }
        if (stringBuffer.length() > 0) {
            String string3 = (String)hashtable.get("EXCLUDED_REGION");
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            hashtable.put("EXCLUDED_REGION", stringBuffer.toString());
        }
    }

    protected void setupPrimerOther(Hashtable hashtable) {
        int n;
        try {
            n = Integer.parseInt(this.mPrimerNumberOfNsField.getText());
            hashtable.put("PRIMER_NUM_NS_ACCEPTED", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(this.mPrimerMaxPolyXField.getText());
            hashtable.put("PRIMER_MAX_POLY_X", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n2 = Integer.parseInt(this.mPrimerGCclampField.getText());
            hashtable.put("PRIMER_GC_CLAMP", Integer.toString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setupOligoSize(Hashtable hashtable) {
        int n;
        try {
            n = Integer.parseInt(this.mMinOligoSizeField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_MIN_SIZE", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(this.mOptOligoSizeField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_OPT_SIZE", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n2 = Integer.parseInt(this.mMaxOligoSizeField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_MAX_SIZE", Integer.toString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setupOligoTm(Hashtable hashtable) {
        int n;
        try {
            n = Integer.parseInt(this.mMinOligoTmField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_MIN_TM", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(this.mOptOligoTmField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_OPT_TM", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n2 = Integer.parseInt(this.mMaxOligoTmField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_MAX_TM", Integer.toString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setupOligoGC(Hashtable hashtable) {
        int n;
        try {
            n = Integer.parseInt(this.mMinOligoGCField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_MIN_GC", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(this.mOptOligoGCField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_OPT_GC_PERCENT", Integer.toString(n));
            hashtable.put("PRIMER_PAIR_WT_IO_PENALTY", "1.0");
            hashtable.put("PRIMER_IO_WT_GC_PERCENT_LT", "1.0");
            hashtable.put("PRIMER_IO_WT_GC_PERCENT_GT", "1.0");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n2 = Integer.parseInt(this.mMaxOligoGCField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_MAX_GC", Integer.toString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setupOligoOther(Hashtable hashtable) {
        int n;
        try {
            n = Integer.parseInt(this.mOligoNumberOfNsField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_NUM_NS", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = Integer.parseInt(this.mOligoMaxPolyXField.getText());
            hashtable.put("PRIMER_INTERNAL_OLIGO_MAX_POLY_X", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setupMisPrimingLib(Hashtable hashtable) {
        int n = this.mMisPrimingLibs.getSelectedIndex();
        if (n == 0) {
            return;
        }
        File file = new File(System.getProperty("user.dir") + File.separator + "repbase" + File.separator + (String)this.mMisPrimingLibs.getItemAt(n));
        hashtable.put("PRIMER_MISPRIMING_LIBRARY", file.getAbsolutePath());
    }

    protected void setupMisHybridLib(Hashtable hashtable) {
        int n = this.mMisHybLibs.getSelectedIndex();
        if (n == 0) {
            return;
        }
        File file = new File(System.getProperty("user.dir") + File.separator + "repbase" + File.separator + (String)this.mMisHybLibs.getItemAt(n));
        hashtable.put("PRIMER_INTERNAL_OLIGO_MISHYB_LIBRARY", file.getAbsolutePath());
    }

    protected void setupReportCount(Hashtable hashtable) {
        hashtable.put("PRIMER_FORWARD_REPORT_COUNT", "100");
        hashtable.put("PRIMER_REVERSE_REPORT_COUNT", "100");
        try {
            int n = Integer.parseInt(this.mOligoReportField.getText());
            hashtable.put("PRIMER_IO_REPORT_COUNT", Integer.toString(n));
        }
        catch (NumberFormatException numberFormatException) {
            hashtable.put("PRIMER_IO_REPORT_COUNT", "100");
        }
    }
}

