/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeadMethod
extends HttpMethodBase {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$methods$HeadMethod != null ? class$org$apache$commons$httpclient$methods$HeadMethod : (class$org$apache$commons$httpclient$methods$HeadMethod = HeadMethod.class$("org.apache.commons.httpclient.methods.HeadMethod")));
    private int bodyCheckTimeout = -1;
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$HeadMethod;

    public HeadMethod() {
        this.setFollowRedirects(true);
    }

    public HeadMethod(String uri) {
        super(uri);
        this.setFollowRedirects(true);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public int getBodyCheckTimeout() {
        return this.bodyCheckTimeout;
    }

    public String getName() {
        return "HEAD";
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException {
        LOG.trace("enter HeadMethod.readResponseBody(HttpState, HttpConnection)");
        if (this.bodyCheckTimeout < 0) {
            this.responseBodyConsumed();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check for non-compliant response body. Timeout in " + this.bodyCheckTimeout + " ms");
            }
            if (conn.isResponseAvailable(this.bodyCheckTimeout)) {
                if (this.isStrictMode()) {
                    throw new HttpException("Body content may not be sent in response to HTTP HEAD request");
                }
                LOG.warn("Body content returned in response to HTTP HEAD");
                super.readResponseBody(state, conn);
            }
        }
    }

    public void recycle() {
        super.recycle();
        this.setFollowRedirects(true);
    }

    public void setBodyCheckTimeout(int timeout) {
        this.bodyCheckTimeout = timeout;
    }
}

