/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.uniform;

public class signrank {
    public static final double SIGNRANK_NMAX = 50.0;
    private static double[][] w;

    private static double csignrank(int k, int n) {
        int u = n * (n + 1) / 2;
        int c = u / 2;
        if (k < 0 || k > u) {
            return 0.0;
        }
        if (k > c) {
            k = u - k;
        }
        if (w[n] == null) {
            signrank.w[n] = new double[c + 1];
            int i = 0;
            while (i <= c) {
                signrank.w[n][i] = -1.0;
                ++i;
            }
        }
        if (w[n][k] < 0.0) {
            signrank.w[n][k] = n == 0 ? (k == 0 ? 1.0 : 0.0) : signrank.csignrank(k - n, n - 1) + signrank.csignrank(k, n - 1);
        }
        return w[n][k];
    }

    public static double density(double x2, double n) {
        if (Double.isNaN(x2) || Double.isNaN(n)) {
            return x2 + n;
        }
        if ((n = Math.floor(n + 0.5)) <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (n >= 50.0) {
            System.out.println("n should be less than %d\n50.0");
            return Double.NaN;
        }
        if ((x2 = Math.floor(x2 + 0.5)) < 0.0 || x2 > n * (n + 1.0) / 2.0) {
            return 0.0;
        }
        return Math.exp(Math.log(signrank.csignrank((int)x2, (int)n)) - n * Math.log(2.0));
    }

    public static double cumulative(double x2, double n) {
        double p = 0.0;
        if (Double.isNaN(x2) || Double.isNaN(n)) {
            return x2 + n;
        }
        if (Double.isInfinite(n)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if ((n = Math.floor(n + 0.5)) <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (n >= 50.0) {
            System.out.println("n should be less than %d\n50.0");
            return Double.NaN;
        }
        if ((x2 = Math.floor(x2 + 0.5)) < 0.0) {
            return 0.0;
        }
        if (x2 >= n * (n + 1.0) / 2.0) {
            return 1.0;
        }
        int i = 0;
        while ((double)i <= x2) {
            p += signrank.density(i, n);
            ++i;
        }
        return p;
    }

    public static double quantile(double x2, double n) {
        if (Double.isNaN(x2) || Double.isNaN(n)) {
            return x2 + n;
        }
        if (Double.isInfinite(x2) || Double.isInfinite(n)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        n = Math.floor(n + 0.5);
        if (x2 < 0.0 || x2 > 1.0 || n <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (n >= 50.0) {
            System.out.println("n should be less than %d\n50.0");
            return Double.NaN;
        }
        if (x2 == 0.0) {
            return 0.0;
        }
        if (x2 == 1.0) {
            return n * (n + 1.0) / 2.0;
        }
        double p = 0.0;
        double q = 0.0;
        while (!((p += signrank.density(q, n)) >= x2)) {
            q += 1.0;
        }
        return q;
    }

    public static double random(double n) {
        if (Double.isNaN(n)) {
            return n;
        }
        if ((n = Math.floor(n + 0.5)) < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (n == 0.0) {
            return 0.0;
        }
        double r = 0.0;
        int k = (int)n;
        int i = 0;
        while (i < k) {
            r += (double)(++i) * Math.floor(uniform.random() + 0.5);
        }
        return r;
    }
}

